/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.moresparkles.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.unariginal.moresparkles.MoreSparkles;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.bossbar.BossBar;

public class MessagesConfig {
    public String prefix = "<gray>[<light_purple>MoreSparkles<gray>]";
    public Map<String, String> messages = new HashMap<String, String>();
    public BossBar.Color globalBarColor = BossBar.Color.PINK;
    public BossBar.Color playerBarColor = BossBar.Color.PINK;
    public BossBar.Overlay globalBarOverlay = BossBar.Overlay.PROGRESS;
    public BossBar.Overlay playerBarOverlay = BossBar.Overlay.PROGRESS;
    public String globalBarText = "<gray>GLOBAL %multiplier%x Shiny Boost | %time_remaining% Remaining";
    public String playerBarText = "<gray>%multiplier%x Shiny Boost | %time_remaining% Remaining";
    public String globalBarTextPaused = "<gray>GLOBAL %multiplier%x Shiny Boost | PAUSED";
    public String playerBarTextPaused = "<gray>%multiplier%x Shiny Boost | PAUSED";

    public MessagesConfig() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            MoreSparkles.logError("Unable to load messages config file. Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadConfig() throws IOException {
        void var7_12;
        this.fillMessages();
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/messages.json").toFile();
        JsonObject newRoot = new JsonObject();
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            root = JsonParser.parseReader((Reader)new FileReader(configFile)).getAsJsonObject();
        }
        if (root.has("prefix")) {
            this.prefix = root.get("prefix").getAsString();
        }
        newRoot.addProperty("prefix", this.prefix);
        JsonObject messagesObject = new JsonObject();
        if (root.has("messages")) {
            messagesObject = root.get("messages").getAsJsonObject();
        }
        for (String string : messagesObject.keySet()) {
            this.messages.put(string, messagesObject.get(string).getAsString());
        }
        for (Map.Entry entry : this.messages.entrySet()) {
            messagesObject.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        newRoot.add("messages", (JsonElement)messagesObject);
        JsonObject bossBarObject = new JsonObject();
        if (root.has("bossbar_settings")) {
            bossBarObject = root.get("bossbar_settings").getAsJsonObject();
        }
        JsonObject jsonObject = new JsonObject();
        if (bossBarObject.has("global_boost")) {
            JsonObject jsonObject2 = bossBarObject.get("global_boost").getAsJsonObject();
        }
        if (var7_12.has("bar_color")) {
            String globalBarColorString = var7_12.get("bar_color").getAsString();
            if (Arrays.stream(BossBar.Color.values()).anyMatch(value -> value.name().equalsIgnoreCase(globalBarColorString))) {
                this.globalBarColor = BossBar.Color.valueOf((String)globalBarColorString.toUpperCase());
            }
        }
        var7_12.addProperty("bar_color", this.globalBarColor.toString());
        if (var7_12.has("bar_overlay")) {
            String globalBarOverlayString = var7_12.get("bar_overlay").getAsString();
            if (Arrays.stream(BossBar.Overlay.values()).anyMatch(value -> value.name().equalsIgnoreCase(globalBarOverlayString))) {
                this.globalBarOverlay = BossBar.Overlay.valueOf((String)globalBarOverlayString.toUpperCase());
            }
        }
        var7_12.addProperty("bar_overlay", this.globalBarOverlay.toString());
        if (var7_12.has("bar_text")) {
            this.globalBarText = var7_12.get("bar_text").getAsString();
        }
        var7_12.addProperty("bar_text", this.globalBarText);
        if (var7_12.has("bar_text_paused")) {
            this.globalBarTextPaused = var7_12.get("bar_text_paused").getAsString();
        }
        var7_12.addProperty("bar_text_paused", this.globalBarTextPaused);
        bossBarObject.add("global_boost", (JsonElement)var7_12);
        JsonObject playerBarObject = new JsonObject();
        if (bossBarObject.has("player_boost")) {
            playerBarObject = bossBarObject.get("player_boost").getAsJsonObject();
        }
        if (playerBarObject.has("bar_color")) {
            String playerBarColorString = playerBarObject.get("bar_color").getAsString();
            if (Arrays.stream(BossBar.Color.values()).anyMatch(value -> value.name().equalsIgnoreCase(playerBarColorString))) {
                this.playerBarColor = BossBar.Color.valueOf((String)playerBarColorString.toUpperCase());
            }
        }
        playerBarObject.addProperty("bar_color", this.playerBarColor.toString());
        if (playerBarObject.has("bar_overlay")) {
            String playerBarOverlayString = playerBarObject.get("bar_overlay").getAsString();
            if (Arrays.stream(BossBar.Overlay.values()).anyMatch(value -> value.name().equalsIgnoreCase(playerBarOverlayString))) {
                this.playerBarOverlay = BossBar.Overlay.valueOf((String)playerBarOverlayString.toUpperCase());
            }
        }
        playerBarObject.addProperty("bar_overlay", this.playerBarOverlay.toString());
        if (playerBarObject.has("bar_text")) {
            this.playerBarText = playerBarObject.get("bar_text").getAsString();
        }
        playerBarObject.addProperty("bar_text", this.playerBarText);
        if (playerBarObject.has("bar_text_paused")) {
            this.playerBarTextPaused = playerBarObject.get("bar_text_paused").getAsString();
        }
        playerBarObject.addProperty("bar_text_paused", this.playerBarTextPaused);
        bossBarObject.add("player_boost", (JsonElement)playerBarObject);
        newRoot.add("bossbar_settings", (JsonElement)bossBarObject);
        configFile.delete();
        configFile.createNewFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileWriter writer = new FileWriter(configFile);
        gson.toJson((JsonElement)newRoot, (Appendable)writer);
        ((Writer)writer).close();
    }

    private void fillMessages() {
        this.messages.clear();
        this.messages.put("command_reload", "%prefix% <green>Reloaded!");
        this.messages.put("player_boost_started", "%prefix% <green>Started a %multiplier%x boost for %duration% for %player.name%!");
        this.messages.put("player_boost_added_to_queue", "%prefix% <green>Added a %multiplier%x boost with a %duration% duration to %player.name%'s queue!");
        this.messages.put("global_boost_started", "%prefix% <green>Started a global %multiplier%x boost for %duration%!");
        this.messages.put("global_boost_added_to_queue", "%prefix% <green>Added a global %multiplier%x boost with a %duration% duration to queue!");
        this.messages.put("player_boost_stopped", "%prefix% <green>Stopped %player.name%'s current boost!");
        this.messages.put("global_boost_stopped", "%prefix% <green>Stopped the current global boost!");
        this.messages.put("command_check_rate", "%prefix% <gray>Base: <yellow>1/%base_shiny_rate%<gray> | Effective: <yellow>1/%player.shiny_rate%");
        this.messages.put("player_queue_cleared", "%prefix% <green>Cleared %player.name%'s queued boosts!");
        this.messages.put("global_queue_cleared", "%prefix% <green>Cleared the global queued boosts!");
        this.messages.put("player_boost_information", "%prefix% <gray>Player: %player.name% | Multiplier: %multiplier%x | Timer: %time_remaining% / %duration%");
        this.messages.put("global_boost_information", "%prefix% <gray>Multiplier: %multiplier%x | Timer: %time_remaining% / %duration%");
        this.messages.put("no_active_boosts", "%prefix% <red>No Active Boosts");
        this.messages.put("no_queued_boosts", "%prefix% <red>No Queued boosts");
        this.messages.put("area_info", "%prefix% <gray>Area \"%area%\": %area.type% type | %multiplier%x multiplier");
        this.messages.put("not_in_area", "%prefix% <red>You're not in an area!");
    }

    public String getMessage(String id) {
        if (this.messages.containsKey(id)) {
            return this.messages.get(id);
        }
        return "null";
    }
}

