/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.moresparkles.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.unariginal.moresparkles.MoreSparkles;
import net.fabricmc.loader.api.FabricLoader;

public class ItemsConfig {
    public Map<String, List<String>> shinyLore = new HashMap<String, List<String>>(Map.of("shiny_charm", List.of("<gray>Having one of these mysterious shining charms makes it more likely you'll encounter Shiny Pok\u00e9mon in the wild.")));
    public Map<String, Float> shinyMultipliers = new HashMap<String, Float>(Map.of("shiny_charm", Float.valueOf(2.0f)));

    public ItemsConfig() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            MoreSparkles.logError("Unable to load items config file. Error: " + e.getMessage());
        }
    }

    private void loadConfig() throws IOException {
        JsonObject shinyCharmItem;
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/items.json").toFile();
        JsonObject root = new JsonObject();
        JsonObject newRoot = new JsonObject();
        if (configFile.exists()) {
            root = JsonParser.parseReader((Reader)new FileReader(configFile)).getAsJsonObject();
        }
        JsonObject shinyCharmsObject = new JsonObject();
        if (root.has("shiny_charms")) {
            shinyCharmsObject = root.getAsJsonObject("shiny_charms");
            this.shinyMultipliers.clear();
            this.shinyLore.clear();
        }
        for (String key : shinyCharmsObject.keySet()) {
            List<String> lore;
            shinyCharmItem = shinyCharmsObject.getAsJsonObject(key);
            if (!shinyCharmItem.has("multiplier")) continue;
            if (shinyCharmItem.has("lore") && !(lore = shinyCharmItem.getAsJsonArray("lore").asList().stream().map(JsonElement::getAsString).toList()).isEmpty()) {
                this.shinyLore.put(key, lore);
            }
            float multiplier = shinyCharmItem.get("multiplier").getAsFloat();
            this.shinyMultipliers.put(key, Float.valueOf(multiplier));
        }
        for (String key : this.shinyMultipliers.keySet()) {
            shinyCharmItem = new JsonObject();
            List<Object> lore = new ArrayList();
            if (this.shinyLore.containsKey(key)) {
                lore = this.shinyLore.get(key);
            }
            JsonArray shinyLore = new JsonArray();
            for (String line : lore) {
                shinyLore.add(line);
            }
            shinyCharmItem.addProperty("multiplier", (Number)this.shinyMultipliers.get(key));
            shinyCharmItem.add("lore", (JsonElement)shinyLore);
            shinyCharmsObject.add(key, (JsonElement)shinyCharmItem);
        }
        newRoot.add("shiny_charms", (JsonElement)shinyCharmsObject);
        configFile.delete();
        configFile.createNewFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileWriter writer = new FileWriter(configFile);
        gson.toJson((JsonElement)newRoot, (Appendable)writer);
        ((Writer)writer).close();
    }
}

