/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.moresparkles;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.api.reactive.ObservableSubscription;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Unit;
import me.unariginal.moresparkles.commands.SparkleCommands;
import me.unariginal.moresparkles.configs.Config;
import me.unariginal.moresparkles.configs.ItemsConfig;
import me.unariginal.moresparkles.configs.MessagesConfig;
import me.unariginal.moresparkles.configs.PlayerDataManager;
import me.unariginal.moresparkles.configs.SparkleAreasConfig;
import me.unariginal.moresparkles.data.ShinyBoost;
import me.unariginal.moresparkles.data.SparkleArea;
import me.unariginal.moresparkles.items.ShinyCharms;
import me.unariginal.moresparkles.managers.TickManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreSparkles
implements ModInitializer {
    public static final String MOD_ID = "moresparkles";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"moresparkles");
    public static boolean DEBUG = false;
    public static MoreSparkles INSTANCE;
    private MinecraftServer server;
    private FabricServerAudiences audiences;
    private Config config;
    private MessagesConfig messages = new MessagesConfig();
    private SparkleAreasConfig boostAreasConfig;
    private ItemsConfig itemsConfig = new ItemsConfig();
    public ShinyBoost globalBoost = null;
    public Queue<ShinyBoost> queuedGlobalBoosts = new ConcurrentLinkedQueue<ShinyBoost>();
    public List<ShinyBoost> activeBoosts = new ArrayList<ShinyBoost>();
    public List<ShinyBoost> queuedBoosts = new ArrayList<ShinyBoost>();
    private ObservableSubscription<ShinyChanceCalculationEvent> shinySubscription = null;

    public void onInitialize() {
        INSTANCE = this;
        new SparkleCommands();
        if (this.isPolymerEnabled()) {
            PolymerResourcePackUtils.markAsRequired();
            PolymerResourcePackUtils.addModAssets((String)MOD_ID);
            ShinyCharms.INSTANCE.fillPolymerModelData();
            ShinyCharms.INSTANCE.fillPolymerItems();
            class_1792 icon = class_1802.field_8137;
            if (ShinyCharms.INSTANCE.shinyCharmPolymerItems.containsKey("shiny_charm")) {
                icon = (class_1792)ShinyCharms.INSTANCE.shinyCharmPolymerItems.get("shiny_charm");
            }
            class_1761 moreSparklesGroup = FabricItemGroup.builder().method_47320(() -> ((class_1792)icon).method_7854()).method_47321((class_2561)class_2561.method_43470((String)"More Sparkles")).method_47317((displayContext, entries) -> {
                for (String key : ShinyCharms.INSTANCE.shinyCharmPolymerItems.keySet()) {
                    entries.method_45421((class_1935)ShinyCharms.INSTANCE.shinyCharmPolymerItems.get(key));
                }
            }).method_47324();
            PolymerItemGroupUtils.registerPolymerItemGroup((class_2960)class_2960.method_60655((String)MOD_ID, (String)"more_sparkles"), (class_1761)moreSparklesGroup);
        } else {
            MoreSparkles.logError("[MoreSparkles] Polymer is not found. Items will not be loaded!");
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
            this.audiences = FabricServerAudiences.of((MinecraftServer)server);
            this.reload(false);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.shinySubscription = CobblemonEvents.SHINY_CHANCE_CALCULATION.subscribe(Priority.NORMAL, event -> {
                if (this.globalBoost == null || !this.config.pausePlayerBoostsDuringGlobalBoost) {
                    for (ShinyBoost shinyBoost : this.activeBoosts) {
                        event.addModificationFunction((rate, player, pokemon) -> {
                            if (player != null && shinyBoost.playerUUID.equals(player.method_5667())) {
                                return Float.valueOf(Math.max(rate.floatValue() / shinyBoost.multiplier, 1.0f));
                            }
                            return rate;
                        });
                    }
                }
                if (this.globalBoost != null) {
                    event.addModificationFunction((rate, player, pokemon) -> Float.valueOf(Math.max(rate.floatValue() / this.globalBoost.multiplier, 1.0f)));
                }
                for (SparkleArea boostArea : this.boostAreasConfig.areas) {
                    event.addModificationFunction((rate, player, pokemon) -> {
                        if (player != null && boostArea.isInArea(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321())) {
                            return Float.valueOf(Math.max(rate.floatValue() / boostArea.multiplier, 1.0f));
                        }
                        return rate;
                    });
                }
                event.addModificationFunction((rate, player, pokemon) -> {
                    if (player != null) {
                        for (String key : ShinyCharms.INSTANCE.shinyCharmPolymerItems.keySet()) {
                            if (!player.method_31548().method_7379(ShinyCharms.INSTANCE.getShinyCharm(key))) continue;
                            rate = Float.valueOf(Math.max(rate.floatValue() / ShinyCharms.INSTANCE.shinyCharmPolymerItems.get(key).getMultiplier(), 1.0f));
                        }
                    }
                    return rate;
                });
                return Unit.INSTANCE;
            });
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            TickManager.tickBoosts();
            TickManager.updateBossbars();
            TickManager.tickParticles();
        });
        ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, minecraftServer) -> {
            class_3222 player = serverPlayNetworkHandler.method_32311();
            ShinyBoost boost = this.getActiveBoost(player);
            if (boost != null) {
                player.hideBossBar(boost.bossBar);
            }
            if (this.globalBoost != null) {
                player.hideBossBar(this.globalBoost.bossBar);
            }
            PlayerDataManager.savePlayerBoostData(player);
            this.activeBoosts.removeIf(shinyBoost -> shinyBoost.playerUUID.equals(player.method_5667()));
        });
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, sender, minecraftServer) -> {
            class_3222 player = serverPlayNetworkHandler.method_32311();
            ShinyBoost boost = PlayerDataManager.loadPlayerBoostData(player);
            this.activeBoosts.removeIf(shinyBoost -> shinyBoost.playerUUID.equals(player.method_5667()));
            if (boost != null) {
                this.activeBoosts.add(boost);
                player.showBossBar(boost.bossBar);
            }
            if (this.globalBoost != null) {
                player.showBossBar(this.globalBoost.bossBar);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            for (ShinyBoost shinyBoost : this.activeBoosts) {
                PlayerDataManager.savePlayerBoostData(shinyBoost);
            }
            this.config.saveGlobalBoostData();
            this.activeBoosts.clear();
            this.queuedBoosts.clear();
            this.globalBoost = null;
            this.queuedGlobalBoosts.clear();
            if (this.shinySubscription != null) {
                this.shinySubscription.unsubscribe();
            }
        });
    }

    public boolean isPolymerEnabled() {
        return FabricLoader.getInstance().isModLoaded("polymer-bundled") || FabricLoader.getInstance().isModLoaded("polymer-common") && FabricLoader.getInstance().isModLoaded("polymer-core") && FabricLoader.getInstance().isModLoaded("polymer-autohost") && FabricLoader.getInstance().isModLoaded("polymer-resource-pack");
    }

    public static void logInfo(String info) {
        if (DEBUG) {
            LOGGER.info(info);
        }
    }

    public static void logError(String error) {
        LOGGER.error(error);
    }

    public void reload(boolean fromCommand) {
        if (fromCommand) {
            for (ShinyBoost shinyBoost : this.activeBoosts) {
                PlayerDataManager.savePlayerBoostData(shinyBoost);
            }
            this.config.saveGlobalBoostData();
        }
        this.messages = new MessagesConfig();
        this.boostAreasConfig = new SparkleAreasConfig();
        this.itemsConfig = new ItemsConfig();
        this.config = new Config();
    }

    public Config getConfig() {
        return this.config;
    }

    public MessagesConfig getMessages() {
        return this.messages;
    }

    public SparkleAreasConfig getBoostAreasConfig() {
        return this.boostAreasConfig;
    }

    public ItemsConfig getItemsConfig() {
        return this.itemsConfig;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public FabricServerAudiences getAudiences() {
        return this.audiences;
    }

    public ShinyBoost getActiveBoost(class_3222 player) {
        for (ShinyBoost boost : this.activeBoosts) {
            if (!boost.playerUUID.equals(player.method_5667())) continue;
            return boost;
        }
        return null;
    }

    public ShinyBoost getNextQueuedBoost(class_3222 player) {
        for (ShinyBoost boost : this.queuedBoosts) {
            if (!boost.playerUUID.equals(player.method_5667())) continue;
            return boost;
        }
        return null;
    }

    public List<ShinyBoost> getQueuedBoosts(class_3222 player) {
        ArrayList<ShinyBoost> boosts = new ArrayList<ShinyBoost>();
        for (ShinyBoost boost : this.queuedBoosts) {
            if (!boost.playerUUID.equals(player.method_5667())) continue;
            boosts.add(boost);
        }
        return boosts;
    }

    public List<ShinyBoost> getQueuedBoosts(UUID uuid) {
        ArrayList<ShinyBoost> boosts = new ArrayList<ShinyBoost>();
        for (ShinyBoost boost : this.queuedBoosts) {
            if (!boost.playerUUID.equals(uuid)) continue;
            boosts.add(boost);
        }
        return boosts;
    }

    public void clearQueue(class_3222 player) {
        ArrayList<ShinyBoost> toRemove = new ArrayList<ShinyBoost>();
        for (ShinyBoost boost : this.queuedBoosts) {
            if (!boost.playerUUID.equals(player.method_5667())) continue;
            toRemove.add(boost);
        }
        for (ShinyBoost boost : toRemove) {
            this.queuedBoosts.remove(boost);
        }
    }
}

