/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.util;

import com.anthonyhilyard.prism.util.ColorUtil;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5251;
import net.minecraft.class_768;

public class ImageAnalysis {
    public static class_5251 getDominantColor(class_2960 imageLocation, class_768 region) {
        class_5251 class_52512;
        block9: {
            class_310 minecraft = class_310.method_1551();
            class_3300 resourceManager = minecraft.method_1478();
            InputStream imageStream = resourceManager.method_14486(imageLocation).isPresent() ? ((class_3298)resourceManager.method_14486(imageLocation).get()).method_14482() : null;
            try {
                BufferedImage image = ImageIO.read(imageStream);
                if (region != null) {
                    image = image.getSubimage(region.method_3321(), region.method_3322(), region.method_3319(), region.method_3320());
                }
                class_52512 = ImageAnalysis.getDominantColor(image);
                if (imageStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            imageStream.close();
        }
        return class_52512;
    }

    public static class_5251 getDominantColor(BufferedImage image) {
        record ImageSampleData(float weight, int count) {
        }
        HashMap samples = Maps.newHashMap();
        Function<Integer, Float> getWeight = color -> {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color >> 0 & 0xFF) / 255.0f;
            if (r <= 0.06f && g <= 0.06f && b <= 0.06f || a < 0.3f) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((1.0f - (1.0f - a) * (1.0f - a) + 1.0f - (1.0f - r) * (1.0f - r) + 1.0f - (1.0f - g) * (1.0f - g) + 1.0f - (1.0f - r) * (1.0f - r) + 1.0f - (1.0f - g) * (1.0f - g) + 1.0f - (1.0f - b) * (1.0f - b) + 1.0f - (1.0f - b) * (1.0f - b)) / 7.0f);
        };
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int degrade = 0; degrade < 8; degrade += 2) {
                    int color2 = image.getRGB(x, y);
                    int degradedColor = ColorUtil.combineARGB((color2 >> 24 & 0xFF) >> degrade, (color2 >> 16 & 0xFF) >> degrade, (color2 >> 8 & 0xFF) >> degrade, (color2 >> 0 & 0xFF) >> degrade);
                    if (!samples.containsKey(degradedColor)) {
                        float weight = getWeight.apply(degradedColor).floatValue();
                        if (weight == 0.0f) continue;
                        ImageSampleData data = new ImageSampleData(weight, 1);
                        samples.put(degradedColor, data);
                        continue;
                    }
                    samples.replace(degradedColor, new ImageSampleData(((ImageSampleData)samples.get(degradedColor)).weight(), ((ImageSampleData)samples.get(degradedColor)).count() + 1));
                }
            }
        }
        HashMap groups = Maps.newHashMap();
        for (Integer color3 : samples.keySet()) {
            groups.put(color3, Float.valueOf((float)((ImageSampleData)samples.get(color3)).count() * ((ImageSampleData)samples.get(color3)).weight()));
        }
        if (groups.isEmpty()) {
            return null;
        }
        return class_5251.method_27717((int)((Integer)((Map.Entry)groups.entrySet().stream().max((a, b) -> Float.compare(((Float)a.getValue()).floatValue(), ((Float)b.getValue()).floatValue())).get()).getKey()));
    }
}

