/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.Capabilities;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.TargetContentsFilterLogic;

public class HopperUpgradeWrapper
extends UpgradeWrapperBase<HopperUpgradeWrapper, HopperUpgradeItem>
implements ITickableUpgrade,
INeighborChangeListenerUpgrade {
    private final Set<class_2350> pullDirections = new LinkedHashSet<class_2350>();
    private final Set<class_2350> pushDirections = new LinkedHashSet<class_2350>();
    private final Map<class_2350, ItemHandlerHolder> handlerCache = new EnumMap<class_2350, ItemHandlerHolder>(class_2350.class);
    private final ContentsFilterLogic inputFilterLogic;
    private final TargetContentsFilterLogic outputFilterLogic;
    private long coolDownTime = 0L;

    protected HopperUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getInputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModCoreDataComponents.INPUT_FILTER_ATTRIBUTES);
        this.outputFilterLogic = new TargetContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getOutputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModDataComponents.OUTPUT_FILTER_ATTRIBUTES);
        this.deserialize();
    }

    public void tick(@Nullable class_1297 entity, class_1937 level, class_2338 pos) {
        this.initDirections(level, pos);
        if (this.coolDownTime > level.method_8510()) {
            return;
        }
        for (class_2350 pushDirection : this.pushDirections) {
            if (this.runOnItemHandlers(level, pos, pushDirection, this::pushItems, entity)) break;
        }
        for (class_2350 pullDirection : this.pullDirections) {
            if (this.runOnItemHandlers(level, pos, pullDirection, this::pullItems, entity)) break;
        }
        this.coolDownTime = level.method_8510() + ((HopperUpgradeItem)this.upgradeItem).getTransferSpeedTicks();
    }

    private void initDirections(class_1937 level, class_2338 pos) {
        if (this.upgrade.sophisticatedCore_has(ModDataComponents.PUSH_DIRECTIONS) || this.upgrade.sophisticatedCore_has(ModDataComponents.PULL_DIRECTIONS)) {
            return;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            class_2350 horizontalDirection = storageBlock.getHorizontalDirection(state);
            VerticalFacing verticalFacing = storageBlock.getVerticalFacing(state);
            this.pullDirections.clear();
            this.pushDirections.clear();
            this.initDirections(BlockSide.BOTTOM.toDirection(horizontalDirection, verticalFacing), BlockSide.TOP.toDirection(horizontalDirection, verticalFacing));
        } else {
            this.initDirections(class_2350.field_11033, class_2350.field_11036);
        }
    }

    private boolean pullItems(List<Storage<ItemVariant>> fromHandlers) {
        for (Storage<ItemVariant> fromHandler : fromHandlers) {
            if (!this.moveItems(fromHandler, (Storage<ItemVariant>)this.storageWrapper.getInventoryForUpgradeProcessing(), (FilterLogic)this.inputFilterLogic)) continue;
            return true;
        }
        return false;
    }

    private boolean pushItems(List<Storage<ItemVariant>> toHandlers) {
        for (Storage<ItemVariant> toHandler : toHandlers) {
            this.outputFilterLogic.setInventory(toHandler);
            if (!this.moveItems((Storage<ItemVariant>)this.storageWrapper.getInventoryForUpgradeProcessing(), toHandler, (FilterLogic)this.outputFilterLogic)) continue;
            return true;
        }
        return false;
    }

    private boolean moveItems(Storage<ItemVariant> fromHandler, Storage<ItemVariant> toHandler, FilterLogic filterLogic) {
        for (StorageView view : fromHandler.nonEmptyViews()) {
            ItemVariant resource = (ItemVariant)view.getResource();
            class_1799 slotStack = resource.toStack((int)view.getAmount());
            if (slotStack.method_7960() || !filterLogic.matchesFilter(slotStack)) continue;
            long maxExtracted = StorageUtil.simulateExtract((StorageView)view, (Object)resource, (long)((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize(), null);
            Transaction transferTransaction = Transaction.openOuter();
            try {
                long accepted = toHandler.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                if (fromHandler.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                transferTransaction.commit();
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    @Override
    public void onNeighborChange(class_1937 level, class_2338 pos, class_2350 direction) {
        if (!level.method_8608() && (this.pushDirections.contains(direction) || this.pullDirections.contains(direction)) && this.needsCacheUpdate(level, pos, direction)) {
            this.handlerCache.remove(direction);
        }
    }

    private boolean needsCacheUpdate(class_1937 level, class_2338 pos, class_2350 direction) {
        ItemHandlerHolder holder = this.handlerCache.get(direction);
        if (holder == null || holder.handlers().isEmpty()) {
            return !level.method_8320(pos).method_26215();
        }
        if (holder.refreshOnEveryNeighborChange()) {
            return true;
        }
        for (BlockApiCache<Storage<ItemVariant>, class_2350> handler : holder.handlers()) {
            if (handler.find((Object)direction.method_10153()) != null) continue;
            return true;
        }
        return false;
    }

    public void updateCacheOnSide(class_1937 level, class_2338 pos, class_2350 direction) {
        if (!(level.method_8477(pos) && level.method_8477(pos.method_10093(direction)) && level instanceof class_3218)) {
            this.handlerCache.remove(direction);
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        ItemHandlerHolder itemHandlers = this.getItemHandlerHolder(level, pos, direction, serverLevel);
        this.handlerCache.put(direction, itemHandlers);
    }

    private ItemHandlerHolder getItemHandlerHolder(class_1937 level, class_2338 pos, class_2350 direction, class_3218 serverLevel) {
        List<class_2338> list;
        class_2680 storageState = level.method_8320(pos);
        class_2248 class_22482 = storageState.method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.method_10093(direction));
        }
        List<class_2338> offsetPositions = list;
        ArrayList<BlockApiCache<Storage<ItemVariant>, class_2350>> caches = new ArrayList<BlockApiCache<Storage<ItemVariant>, class_2350>>();
        AtomicBoolean refreshOnEveryNeighborChange = new AtomicBoolean(false);
        offsetPositions.forEach(offsetPos -> {
            offsetPos = level.method_35230(offsetPos, ModBlocks.STORAGE_INPUT_BLOCK_ENTITY_TYPE.get()).flatMap(storageInputBlockEntity -> {
                refreshOnEveryNeighborChange.set(true);
                return storageInputBlockEntity.getControllerPos();
            }).orElse(offsetPos);
            caches.add(BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)serverLevel, (class_2338)offsetPos));
        });
        return new ItemHandlerHolder(caches, refreshOnEveryNeighborChange.get());
    }

    private boolean runOnItemHandlers(class_1937 level, class_2338 pos, class_2350 direction, Predicate<List<Storage<ItemVariant>>> run, @Nullable class_1297 entity) {
        ItemHandlerHolder holder = this.getItemHandlerHolder(level, pos, direction, entity == null);
        if (holder == null) {
            return this.runOnAutomationEntityItemHandlers(level, pos, direction, run, entity);
        }
        List<Storage> handler = holder.handlers().stream().map(handlerCache -> (Storage)handlerCache.find((Object)direction.method_10153())).filter(Objects::nonNull).toList();
        return handler.isEmpty() ? this.runOnAutomationEntityItemHandlers(level, pos, direction, run, entity) : run.test(handler);
    }

    private boolean runOnAutomationEntityItemHandlers(class_1937 level, class_2338 pos, class_2350 direction, Predicate<List<Storage<ItemVariant>>> run, @Nullable class_1297 entity) {
        List<class_2338> list;
        Object object;
        class_2680 storageState = level.method_8320(pos);
        if (entity == null && (object = storageState.method_26204()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)object;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.method_10093(direction));
        }
        List<class_2338> offsetPositions = list;
        ArrayList entities = new ArrayList();
        for (class_2338 offsetPosition : offsetPositions) {
            entities.addAll(level.method_8333((class_1297)null, new class_238(offsetPosition), e -> e != entity && class_1301.field_6154.test(e)));
        }
        if (!entities.isEmpty()) {
            Collections.shuffle(entities);
            for (class_1297 e2 : entities) {
                IInventoryHandlerHelper entityCap = (IInventoryHandlerHelper)Capabilities.ItemHandler.ENTITY_AUTOMATION.find(e2, (Object)direction.method_10153());
                if (entityCap == null) continue;
                return run.test(List.of(entityCap));
            }
        }
        return false;
    }

    @Nullable
    private ItemHandlerHolder getItemHandlerHolder(class_1937 level, class_2338 pos, class_2350 direction, boolean useCache) {
        if (useCache) {
            if (!this.handlerCache.containsKey(direction)) {
                this.updateCacheOnSide(level, pos, direction);
            }
            return this.handlerCache.get(direction);
        }
        return this.getItemHandlerHolder(level, pos, direction, (class_3218)level);
    }

    public ContentsFilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public ContentsFilterLogic getOutputFilterLogic() {
        return this.outputFilterLogic;
    }

    public boolean isPullingFrom(class_2350 direction) {
        return this.pullDirections.contains(direction);
    }

    public boolean isPushingTo(class_2350 direction) {
        return this.pushDirections.contains(direction);
    }

    public void setPullingFrom(class_2350 direction, boolean shouldPull) {
        if (shouldPull) {
            this.pullDirections.add(direction);
        } else {
            this.pullDirections.remove(direction);
        }
        this.serializePullDirections();
    }

    public void setPushingTo(class_2350 direction, boolean isPushing) {
        if (isPushing) {
            this.pushDirections.add(direction);
        } else {
            this.pushDirections.remove(direction);
        }
        this.serializePushDirections();
    }

    private void serializePullDirections() {
        this.upgrade.sophisticatedCore_set(ModDataComponents.PULL_DIRECTIONS, Set.copyOf(this.pullDirections));
        this.save();
    }

    private void serializePushDirections() {
        this.upgrade.sophisticatedCore_set(ModDataComponents.PUSH_DIRECTIONS, Set.copyOf(this.pushDirections));
        this.save();
    }

    public void deserialize() {
        this.pullDirections.clear();
        this.pushDirections.clear();
        Set directions = (Set)this.upgrade.sophisticatedCore_get(ModDataComponents.PULL_DIRECTIONS);
        if (directions != null) {
            this.pullDirections.addAll(directions);
        }
        if ((directions = (Set)this.upgrade.sophisticatedCore_get(ModDataComponents.PUSH_DIRECTIONS)) != null) {
            this.pushDirections.addAll(directions);
        }
    }

    public void initDirections(class_2350 pushDirection, class_2350 pullDirection) {
        this.setPushingTo(pushDirection, true);
        this.setPullingFrom(pullDirection, true);
    }

    private record ItemHandlerHolder(List<BlockApiCache<Storage<ItemVariant>, class_2350>> handlers, boolean refreshOnEveryNeighborChange) {
    }
}

