/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlockItem
extends WoodStorageBlockItem {
    public static final Codec<Map<BarrelMaterial, class_2960>> MATERIALS_CODEC = Codec.simpleMap(BarrelMaterial.CODEC, (Codec)class_2960.field_25139, (Keyable)class_3542.method_28142((class_3542[])BarrelMaterial.values())).codec();
    public static final class_9139<class_2540, Map<BarrelMaterial, class_2960>> MATERIALS_STREAM_CODEC = class_9139.method_56437((buf, map) -> buf.method_34063(map, BarrelMaterial.STREAM_CODEC, (class_9142)class_2960.field_48267), buf -> buf.method_34067(BarrelMaterial.STREAM_CODEC, (class_9141)class_2960.field_48267));

    public BarrelBlockItem(class_2248 block) {
        this(block, new class_1792.class_1793());
    }

    public BarrelBlockItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public static void toggleFlatTop(class_1799 stack) {
        boolean flatTop = BarrelBlockItem.isFlatTop((SophisticatedDataComponentHolder)stack);
        BarrelBlockItem.setFlatTop(stack, !flatTop);
    }

    public static void setFlatTop(class_1799 stack, boolean flatTop) {
        if (flatTop) {
            stack.sophisticatedCore_set(ModDataComponents.FLAT_TOP, (Object)true);
        } else {
            stack.sophisticatedCore_remove(ModDataComponents.FLAT_TOP);
        }
    }

    public static boolean isFlatTop(SophisticatedDataComponentHolder componentHolder) {
        return (Boolean)componentHolder.sophisticatedCore_getOrDefault(ModDataComponents.FLAT_TOP, (Object)false);
    }

    public static void setMaterials(class_1799 barrel, Map<BarrelMaterial, class_2960> materials) {
        barrel.sophisticatedCore_set(ModDataComponents.BARREL_MATERIALS, Map.copyOf(materials));
    }

    public static Map<BarrelMaterial, class_2960> getMaterials(class_1799 barrel) {
        return (Map)barrel.sophisticatedCore_getOrDefault(ModDataComponents.BARREL_MATERIALS, Map.of());
    }

    public static void removeMaterials(class_1799 stack) {
        stack.sophisticatedCore_remove(ModDataComponents.BARREL_MATERIALS);
    }

    public static void uncompactMaterials(Map<BarrelMaterial, class_2960> materials) {
        if (materials.isEmpty()) {
            return;
        }
        EnumMap uncompactedMaterials = new EnumMap(BarrelMaterial.class);
        materials.forEach((mat, texture) -> {
            for (BarrelMaterial child : mat.getChildren()) {
                uncompactedMaterials.put(child, texture);
            }
        });
        materials.clear();
        materials.putAll(uncompactedMaterials);
    }

    public static void compactMaterials(Map<BarrelMaterial, class_2960> materials) {
        for (BarrelMaterial material : BarrelMaterial.values()) {
            if (material.isLeaf()) continue;
            class_2960 firstChildTexture = null;
            boolean allChildrenHaveSameTexture = true;
            for (BarrelMaterial child : material.getChildren()) {
                class_2960 texture = materials.get((Object)child);
                if (texture == null || firstChildTexture != null && !firstChildTexture.equals((Object)texture)) {
                    allChildrenHaveSameTexture = false;
                    break;
                }
                if (firstChildTexture != null) continue;
                firstChildTexture = texture;
            }
            if (firstChildTexture == null || !allChildrenHaveSameTexture) continue;
            materials.put(material, firstChildTexture);
            for (BarrelMaterial child : material.getChildren()) {
                materials.remove((Object)child);
            }
        }
    }

    public static void removeCoveredTints(class_1799 barrelStackCopy, Map<BarrelMaterial, class_2960> materials) {
        class_1792 class_17922 = barrelStackCopy.method_7909();
        if (class_17922 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
            boolean hasMainTint = tintableBlockItem.getMainColor(barrelStackCopy).isPresent();
            boolean hasAccentTint = tintableBlockItem.getAccentColor(barrelStackCopy).isPresent();
            if (hasMainTint || hasAccentTint) {
                if (hasMainTint && (materials.containsKey((Object)BarrelMaterial.ALL) || materials.containsKey((Object)BarrelMaterial.ALL_BUT_TRIM))) {
                    tintableBlockItem.removeMainColor(barrelStackCopy);
                }
                if (hasAccentTint && (materials.containsKey((Object)BarrelMaterial.ALL) || materials.containsKey((Object)BarrelMaterial.ALL_TRIM))) {
                    tintableBlockItem.removeAccentColor(barrelStackCopy);
                }
            }
        }
    }

    public static Map<BarrelMaterial, class_2960> getUncompactedMaterials(class_1799 storageStack) {
        EnumMap<BarrelMaterial, class_2960> materials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(storageStack));
        BarrelBlockItem.uncompactMaterials(materials);
        return materials;
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        class_2561 name = BarrelBlockItem.getMaterials(stack).isEmpty() ? super.method_7864(stack) : BarrelBlockItem.getDisplayName(this.method_7876(), null);
        if (BarrelBlockItem.isFlatTop((SophisticatedDataComponentHolder)stack)) {
            return name.method_27661().method_10852((class_2561)class_2561.method_43471((String)(StorageTranslationHelper.INSTANCE.translBlockTooltipKey("barrel") + ".flat_top")));
        }
        return name;
    }

    @Override
    public boolean isTintable(class_1799 stack) {
        return BarrelBlockItem.getMaterials(stack).isEmpty();
    }
}

