/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.rei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_437;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.compat.rei.REISettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.rei.REIStorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.rei.SophisticatedTransferHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.rei.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.rei.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.rei.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.rei.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.rei.subtypes.BarrelSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.rei.subtypes.ChestSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.rei.subtypes.ShulkerBoxSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class REIClientCompat
implements REIClientPlugin {
    private static Consumer<CategoryRegistry> additionalCategories = registration -> {};
    private final PropertyBasedSubtypeInterpreter chestSubtypeInterpreter = new ChestSubtypeInterpreter();
    private final PropertyBasedSubtypeInterpreter barrelSubtypeInterpreter = new BarrelSubtypeInterpreter();
    private final PropertyBasedSubtypeInterpreter shulkerBoxSubtypeInterpreter = new ShulkerBoxSubtypeInterpreter();

    public static void setAdditionalCategories(Consumer<CategoryRegistry> additionalCategories) {
        REIClientCompat.additionalCategories = additionalCategories;
    }

    private Map<class_1747, PropertyBasedSubtypeInterpreter> getSubtypeIntepreters() {
        return new HashMap<class_1747, PropertyBasedSubtypeInterpreter>(){
            {
                this.put(ModBlocks.BARREL_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.COPPER_BARREL_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.IRON_BARREL_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.GOLD_BARREL_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_BARREL_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_BARREL_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.CHEST_ITEM.get(), REIClientCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.COPPER_CHEST_ITEM.get(), REIClientCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.IRON_CHEST_ITEM.get(), REIClientCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.GOLD_CHEST_ITEM.get(), REIClientCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_CHEST_ITEM.get(), REIClientCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_CHEST_ITEM.get(), REIClientCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_1_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_2_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_3_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_4_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get(), REIClientCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.SHULKER_BOX_ITEM.get(), REIClientCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), REIClientCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.IRON_SHULKER_BOX_ITEM.get(), REIClientCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), REIClientCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), REIClientCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get(), REIClientCompat.this.shulkerBoxSubtypeInterpreter);
            }
        };
    }

    private Optional<PropertyBasedSubtypeInterpreter> getSubtypeInterpreter(Map<class_1747, PropertyBasedSubtypeInterpreter> subtypeInterpreters, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return Optional.empty();
        }
        class_1747 blockItem = (class_1747)class_17922;
        return Optional.ofNullable(subtypeInterpreters.get(blockItem));
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(StorageScreen.class, screen -> {
            ArrayList ret = new ArrayList();
            screen.getUpgradeSlotsRectangle().ifPresent(ret::add);
            ret.addAll(screen.getUpgradeSettingsControl().getTabRectangles());
            screen.getSortButtonsRectangle().ifPresent(ret::add);
            return ret.stream().map(r -> new Rectangle(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())).toList();
        });
        zones.register(StorageSettingsScreen.class, screen -> screen.getSettingsTabControl().getTabRectangles().stream().map(r -> new Rectangle(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())).toList());
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(SophisticatedTransferHandler.crafting(StorageContainerMenu.class));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)ModItems.CRAFTING_UPGRADE.get()))});
        registry.addWorkstations(BuiltinPlugin.STONE_CUTTING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)ModItems.STONECUTTER_UPGRADE.get()))});
        additionalCategories.accept(registry);
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new REIStorageGhostIngredientHandler<StorageScreenBase<?>>(this){

            public <R extends class_437> boolean isHandingScreen(R screen) {
                return screen instanceof StorageScreen;
            }
        });
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new REISettingsGhostIngredientHandler());
    }

    public void registerDisplays(DisplayRegistry registry) {
        Map<class_1747, PropertyBasedSubtypeInterpreter> subtypeInterpreters = this.getSubtypeIntepreters();
        REIClientCompat.registerRecipes(registry, DyeRecipesMaker.getRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)), BuiltinPlugin.CRAFTING);
        REIClientCompat.registerRecipes(registry, TierUpgradeRecipesMaker.getShapedCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)), BuiltinPlugin.CRAFTING);
        REIClientCompat.registerRecipes(registry, TierUpgradeRecipesMaker.getShapelessCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)), BuiltinPlugin.CRAFTING);
        REIClientCompat.registerRecipes(registry, ShulkerBoxFromChestRecipesMaker.getRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)), BuiltinPlugin.CRAFTING);
        REIClientCompat.registerRecipes(registry, FlatBarrelRecipesMaker.getRecipes(), BuiltinPlugin.CRAFTING);
    }

    public static void registerRecipes(DisplayRegistry registry, Collection<?> recipes, CategoryIdentifier<?> identifier) {
        recipes.forEach(recipe -> {
            Collection displays = registry.tryFillDisplay(recipe);
            for (Display display : displays) {
                if (!Objects.equals(display.getCategoryIdentifier(), identifier)) continue;
                registry.add(display, recipe);
            }
        });
    }
}

