/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3738;
import net.minecraft.class_5560;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;

public class ChestBlockEntity
extends WoodStorageBlockEntity {
    public static final String STORAGE_TYPE = "chest";
    public static final String DOUBLE_CHEST_MAIN_POS_TAG = "doubleMainPos";
    private final class_5560 chestLidController = new class_5560();
    @Nullable
    private class_2338 doubleMainPos = null;
    public boolean showUpgradesOnTop = false;
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 state) {
            if (state.method_11654(ChestBlock.TYPE) != class_2745.field_12574) {
                ChestBlockEntity.this.playSound(state, class_3417.field_14982);
            }
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            if (state.method_11654(ChestBlock.TYPE) != class_2745.field_12574) {
                ChestBlockEntity.this.playSound(state, class_3417.field_14823);
            }
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int previousOpenCount, int openCount) {
            ChestBlockEntity.this.chestLidController.method_31674(openCount > 0);
        }

        protected boolean method_31679(class_1657 player) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)class_17032;
                return storageContainerMenu.getStorageBlockEntity() == ChestBlockEntity.this;
            }
            return false;
        }

        public void method_31684(class_1657 player, class_1937 level, class_2338 pos, class_2680 state) {
            super.method_31684(player, level, pos, state);
            if (ChestBlockEntity.this.isMainChest()) {
                ChestBlockEntity.runOnTheOtherPart(level, pos, state, (blockEntity, neighborPos) -> blockEntity.openersCounter.method_31684(player, level, neighborPos, level.method_8320(neighborPos)));
            }
        }

        public void method_31685(class_1657 player, class_1937 level, class_2338 pos, class_2680 state) {
            super.method_31685(player, level, pos, state);
            if (ChestBlockEntity.this.isMainChest()) {
                ChestBlockEntity.runOnTheOtherPart(level, pos, state, (blockEntity, neighborPos) -> blockEntity.openersCounter.method_31685(player, level, neighborPos, level.method_8320(neighborPos)));
            }
        }
    };
    private boolean isDestroyedByPlayer = false;

    public void joinWithChest(ChestBlockEntity mainBE) {
        this.setMainPos(mainBE.method_11016());
        this.expandAndMoveItemsAndSettings(mainBE);
        this.removeFromController();
        this.setNotLinked();
        this.tryToAddToController();
    }

    public class_5560 getChestLidController() {
        return this.chestLidController;
    }

    public void setMainPos(class_2338 doubleMainPos) {
        this.doubleMainPos = doubleMainPos;
        this.method_5431();
    }

    private void expandAndMoveItemsAndSettings(ChestBlockEntity mainBE) {
        int n;
        InventoryHandler mainInventoryHandler = mainBE.getStorageWrapper().getInventoryHandler();
        int originalNumberOfSlots = mainInventoryHandler.getSlotCount();
        InventoryHandler thisInventoryHandler = this.getStorageWrapper().getInventoryHandler();
        class_2248 class_22482 = mainBE.method_11010().method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        int inventorySlotDiff = 2 * n - mainInventoryHandler.getSlotCount();
        mainBE.changeStorageSize(inventorySlotDiff, 0);
        ChestBlockEntity.moveStacksToMain(thisInventoryHandler, mainInventoryHandler, originalNumberOfSlots);
        this.copySettings(this, mainBE, 0, originalNumberOfSlots);
        this.deleteSettingsFromSlot(this, 0);
        WorldHelper.notifyBlockUpdate((class_2586)mainBE);
    }

    private void copySettings(ChestBlockEntity from, ChestBlockEntity to, int startFromSlot, int slotOffset) {
        SettingsHandler mainSettingsHandler = to.getStorageWrapper().getSettingsHandler();
        from.getStorageWrapper().getSettingsHandler().getSettingsCategories().forEach((name, category) -> this.copyCategorySettings((ISettingsCategory)category, (ISettingsCategory<?>)mainSettingsHandler.getTypeCategory(category.getClass()), startFromSlot, slotOffset));
    }

    private void deleteSettingsFromSlot(ChestBlockEntity from, int startFromSlot) {
        from.getStorageWrapper().getSettingsHandler().getSettingsCategories().forEach((name, category) -> category.deleteSlotSettingsFrom(startFromSlot));
    }

    private <T extends ISettingsCategory<?>> void copyCategorySettings(ISettingsCategory<T> category, ISettingsCategory<?> mainCategory, int startFromSlot, int slotOffset) {
        category.copyTo(mainCategory, startFromSlot, slotOffset);
    }

    private static void moveStacksToMain(InventoryHandler thisInventoryHandler, InventoryHandler mainInventoryHandler, int originalNumberOfSlots) {
        int slot;
        int thisSlots = thisInventoryHandler.getSlotCount();
        int mainSlots = mainInventoryHandler.getSlotCount();
        for (slot = 0; slot < thisSlots && slot + originalNumberOfSlots < mainSlots; ++slot) {
            class_1799 slotStack = thisInventoryHandler.getSlotStack(slot);
            if (slotStack.method_7960()) continue;
            mainInventoryHandler.setStackInSlot(slot + originalNumberOfSlots, slotStack);
        }
        for (slot = 0; slot < thisSlots; ++slot) {
            thisInventoryHandler.setStackInSlot(slot, class_1799.field_8037);
        }
    }

    public void syncTogglesFrom(ChestBlockEntity chestBE) {
        if (chestBE.isLocked() != this.isLocked()) {
            this.toggleJustMyLock();
        }
        if (chestBE.shouldShowLock() != this.shouldShowLock()) {
            this.toggleJustMyLockVisibility();
        }
        if (chestBE.shouldShowTier() != this.shouldShowTier()) {
            this.toggleJustMyTierVisiblity();
        }
        if (chestBE.shouldShowUpgrades() != this.shouldShowUpgrades()) {
            this.toggleJustMyUpgradesVisiblity();
        }
    }

    @Override
    public void dropContents() {
        if (this.isDestroyedByPlayer && this.method_11010().method_11654(ChestBlock.TYPE) != class_2745.field_12569) {
            if (this.doubleMainPos != null) {
                this.moveMyStacksFromMain();
            } else {
                this.moveOtherPartStacksToIt();
            }
        }
        super.dropContents();
    }

    @Override
    public void onNeighborChange(class_2338 neighborPos) {
        class_2350 direction = this.getNeighborDirection(neighborPos);
        if (direction == null) {
            return;
        }
        this.getMainStorageWrapper().getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.field_11863, this.field_11867, direction));
    }

    private void moveOtherPartStacksToIt() {
        ChestBlockEntity.runOnTheOtherPart(this.field_11863, this.method_11016(), this.method_11010(), (be, pos) -> {
            int firstIndex;
            be.removeDoubleMainPos();
            InventoryHandler mainInventoryHandler = this.getStorageWrapper().getInventoryHandler();
            for (int slot = firstIndex = mainInventoryHandler.getSlotCount() / 2; slot < mainInventoryHandler.getSlotCount(); ++slot) {
                class_1799 slotStack = mainInventoryHandler.getSlotStack(slot);
                be.getStorageWrapper().getInventoryHandler().setSlotStack(slot - firstIndex, slotStack.method_7971(slotStack.method_7914()));
                mainInventoryHandler.setSlotStack(slot, slotStack);
            }
            this.copySettings(this, (ChestBlockEntity)be, firstIndex, -firstIndex);
            be.removeControllerPos();
            be.tryToAddToController();
            be.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
            WorldHelper.notifyBlockUpdate((class_2586)be);
        });
    }

    private void moveMyStacksFromMain() {
        this.field_11863.method_35230(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(mainBE -> {
            int n;
            int firstIndex;
            StorageWrapper mainStorageWrapper = mainBE.getStorageWrapper();
            InventoryHandler mainInventoryHandler = mainStorageWrapper.getInventoryHandler();
            for (int slot = firstIndex = mainInventoryHandler.getSlotCount() / 2; slot < mainInventoryHandler.getSlotCount(); ++slot) {
                this.getStorageWrapper().getInventoryHandler().setSlotStack(slot - firstIndex, mainInventoryHandler.getSlotStack(slot));
                mainInventoryHandler.setSlotStack(slot, class_1799.field_8037);
            }
            class_2248 patt0$temp = mainBE.method_11010().method_26204();
            if (patt0$temp instanceof StorageBlockBase) {
                StorageBlockBase storageBlock = (StorageBlockBase)patt0$temp;
                n = storageBlock.getNumberOfInventorySlots();
            } else {
                n = 0;
            }
            int inventorySlotDiff = n - mainInventoryHandler.getSlotCount();
            mainBE.changeStorageSize(inventorySlotDiff, 0);
            this.deleteSettingsFromSlot((ChestBlockEntity)mainBE, firstIndex);
            ((ItemDisplaySettingsCategory)mainStorageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).setDisplaySide(DisplaySide.FRONT);
            mainStorageWrapper.getUpgradeHandler().refreshUpgradeWrappers();
            WorldHelper.notifyBlockUpdate((class_2586)mainBE);
        });
    }

    public boolean hasStorageData() {
        return this.isMainChest();
    }

    @Override
    protected class_5561 getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    public ChestBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get());
    }

    public static void lidAnimateTick(ChestBlockEntity chestBlockEntity) {
        chestBlockEntity.chestLidController.method_31672();
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.method_31673(partialTicks);
    }

    @Override
    public void toggleLock() {
        super.toggleLock();
        if (this.field_11863 != null) {
            ChestBlockEntity.runOnTheOtherPart(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867), (be, pos) -> be.toggleJustMyLock());
        }
    }

    private void toggleJustMyLock() {
        super.toggleLock();
    }

    @Override
    public void toggleLockVisibility() {
        super.toggleLockVisibility();
        if (this.field_11863 != null) {
            ChestBlockEntity.runOnTheOtherPart(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867), (be, pos) -> be.toggleJustMyLockVisibility());
        }
    }

    private void toggleJustMyLockVisibility() {
        super.toggleLockVisibility();
    }

    @Override
    public void toggleTierVisiblity() {
        super.toggleTierVisiblity();
        if (this.field_11863 != null) {
            ChestBlockEntity.runOnTheOtherPart(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867), (be, pos) -> be.toggleJustMyTierVisiblity());
        }
    }

    private void toggleJustMyTierVisiblity() {
        super.toggleTierVisiblity();
    }

    @Override
    public void toggleUpgradesVisiblity() {
        super.toggleUpgradesVisiblity();
        if (this.field_11863 != null) {
            ChestBlockEntity.runOnTheOtherPart(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867), (be, pos) -> be.toggleJustMyUpgradesVisiblity());
        }
    }

    private void toggleJustMyUpgradesVisiblity() {
        super.toggleUpgradesVisiblity();
    }

    private static void runOnTheOtherPart(class_1937 level, class_2338 pos, class_2680 state, BiConsumer<ChestBlockEntity, class_2338> execute) {
        class_2745 chestType = (class_2745)state.method_11654(ChestBlock.TYPE);
        if (chestType == class_2745.field_12569) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)ChestBlock.FACING);
        class_2338 neighborPos = chestType == class_2745.field_12571 ? pos.method_10093(facing.method_10160()) : pos.method_10093(facing.method_10170());
        level.method_35230(neighborPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(chestBlockEntity -> execute.accept((ChestBlockEntity)chestBlockEntity, neighborPos));
    }

    public void removeDoubleMainPos() {
        this.doubleMainPos = null;
    }

    @Override
    @Nullable
    public SlottedStackStorage getExternalItemHandler(@Nullable class_2350 side) {
        if (this.field_11863 == null) {
            return null;
        }
        if (this.doubleMainPos != null) {
            return this.field_11863.method_35230(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(be -> be.getExternalItemHandler(side)).orElse(null);
        }
        return super.getExternalItemHandler(side);
    }

    public boolean isMainChest() {
        return this.doubleMainPos == null;
    }

    @Override
    public void loadSynchronizedData(class_2487 tag, class_7225.class_7874 registries) {
        super.loadSynchronizedData(tag, registries);
        this.doubleMainPos = NBTHelper.getLong((class_2487)tag, (String)DOUBLE_CHEST_MAIN_POS_TAG).map(class_2338::method_10092).orElse(null);
    }

    @Override
    protected void saveSynchronizedData(class_2487 tag) {
        super.saveSynchronizedData(tag);
        if (this.doubleMainPos != null) {
            tag.method_10544(DOUBLE_CHEST_MAIN_POS_TAG, this.doubleMainPos.method_10063());
        }
    }

    @Override
    public class_2487 getStorageContentsTag() {
        class_2487 tag = super.getStorageContentsTag();
        tag.method_10551(DOUBLE_CHEST_MAIN_POS_TAG);
        return tag;
    }

    @Override
    protected class_1799 addWrappedStorageStackData(class_1799 cloneItemStack, class_2680 state) {
        class_1799 ret = super.addWrappedStorageStackData(cloneItemStack, state);
        if (state.method_11654(ChestBlock.TYPE) != class_2745.field_12569) {
            ChestBlockItem.setDoubleChest(ret, true);
        }
        return ret;
    }

    public StorageWrapper getMainStorageWrapper() {
        if (this.doubleMainPos != null) {
            return this.field_11863.method_35230(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(StorageBlockEntity::getStorageWrapper).orElseGet(this::getStorageWrapper);
        }
        return this.getStorageWrapper();
    }

    @Nullable
    public ChestBlockEntity getMainChestBlockEntity() {
        if (this.doubleMainPos != null) {
            return this.field_11863.method_35230(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).orElse(null);
        }
        return this;
    }

    @Override
    public boolean canBeLinked() {
        return this.isMainChest() && super.canBeLinked();
    }

    public void dropSecondPartContents(ChestBlock chestBlock, class_2338 dropPosition) {
        InventoryHandler invHandler = this.getStorageWrapper().getInventoryHandler();
        ArrayList<class_1799> dropItems = new ArrayList<class_1799>();
        for (int slot = chestBlock.getNumberOfInventorySlots(); slot < invHandler.getSlotCount(); ++slot) {
            class_1799 slotStack = invHandler.getSlotStack(slot);
            if (slotStack.method_7960()) continue;
            dropItems.add(slotStack.method_7972());
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(serverLevel.method_8503().method_3780(), () -> dropItems.forEach(itemStack -> class_1264.method_5449((class_1937)serverLevel, (double)dropPosition.method_10263(), (double)dropPosition.method_10264(), (double)dropPosition.method_10260(), (class_1799)itemStack))));
        }
        int inventorySlotDiff = chestBlock.getNumberOfInventorySlots() - invHandler.getSlotCount();
        this.changeStorageSize(inventorySlotDiff, 0);
        this.deleteSettingsFromSlot(this, chestBlock.getNumberOfInventorySlots());
        ((ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).setDisplaySide(DisplaySide.FRONT);
        this.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    public void setDestroyedByPlayer() {
        this.isDestroyedByPlayer = true;
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        if (!this.isBeingUpgraded() && this.method_11010().method_11654(ChestBlock.TYPE) == class_2745.field_12569) {
            class_2248 class_22482 = this.method_11010().method_26204();
            if (class_22482 instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)class_22482;
                if (this.getStorageWrapper().getInventoryHandler().getSlotCount() > chestBlock.getNumberOfInventorySlots()) {
                    this.dropSecondPartContents(chestBlock, this.field_11867);
                }
            }
            if (!this.isMainChest()) {
                this.removeDoubleMainPos();
            }
        }
    }

    public void changeSlots(int newSlots) {
        if (this.hasStorageData()) {
            super.changeSlots(newSlots);
        }
    }
}

