/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.telescope;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.luckystudio.cozyhome.block.custom.telescope.TelescopeBlockEntity;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.block.util.interfaces.SeatBlock;
import net.luckystudio.cozyhome.util.ModScreenTexts;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class TelescopeBlock
extends class_2237
implements class_3737,
SeatBlock {
    public static final MapCodec<TelescopeBlock> CODEC = TelescopeBlock.method_54094(TelescopeBlock::new);
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 TRIGGERED = class_2741.field_12522;
    public static final class_265 SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final List<String> GENERAL_FACTS = Arrays.asList("message.cozyhome.telescope.moon_fact_0", "message.cozyhome.telescope.moon_fact_1", "message.cozyhome.telescope.moon_fact_2");
    private static final Supplier<List<String>> FULL_MOON_FACTS_SUPPLIER = () -> {
        ArrayList<String> facts = new ArrayList<String>(Arrays.asList("message.cozyhome.telescope.full_moon_facts_0", "message.cozyhome.telescope.full_moon_facts_1", "message.cozyhome.telescope.full_moon_facts_2", "message.cozyhome.telescope.full_moon_facts_3", "message.cozyhome.telescope.full_moon_facts_4"));
        facts.add(TelescopeBlock.randomText(GENERAL_FACTS));
        return facts;
    };
    private static final List<String> WANING_GIBBOUS_FACTS = Arrays.asList("message.cozyhome.telescope.waning_gibbous_facts_0", GENERAL_FACTS.get(class_5819.method_43053().method_43048(GENERAL_FACTS.size())));
    private static final List<String> LAST_QUARTER_FACTS = Arrays.asList("message.cozyhome.telescope.last_quarter_facts_0", GENERAL_FACTS.get(class_5819.method_43047().method_43048(GENERAL_FACTS.size())));
    private static final List<String> WANING_CRESCENT_FACTS = Arrays.asList("message.cozyhome.telescope.waning_crescent_facts_0", GENERAL_FACTS.get(class_5819.method_43047().method_43048(GENERAL_FACTS.size())));
    private static final List<String> NEW_MOON_FACTS = Arrays.asList("message.cozyhome.telescope.new_moon_facts_0", "message.cozyhome.telescope.new_moon_facts_1", "message.cozyhome.telescope.new_moon_facts_2", GENERAL_FACTS.get(class_5819.method_43047().method_43048(GENERAL_FACTS.size())));
    private static final List<String> WAXING_CRESCENT_FACTS = Arrays.asList("message.cozyhome.telescope.waxing_crescent_facts_0", GENERAL_FACTS.get(class_5819.method_43047().method_43048(GENERAL_FACTS.size())));
    private static final List<String> FIRST_QUARTER_FACTS = Arrays.asList("message.cozyhome.telescope.first_quarter_facts_0", GENERAL_FACTS.get(class_5819.method_43047().method_43048(GENERAL_FACTS.size())));
    private static final List<String> WAXING_GIBBOUS_FACTS = Arrays.asList("message.cozyhome.telescope.waxing_gibbous_facts_0", GENERAL_FACTS.get(class_5819.method_43047().method_43048(GENERAL_FACTS.size())));

    private static List<String> getFullMoonFacts() {
        return FULL_MOON_FACTS_SUPPLIER.get();
    }

    private static String randomText(List<String> facts) {
        return facts.get(class_5819.method_43047().method_43048(facts.size()));
    }

    public TelescopeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.FALSE)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, TRIGGERED});
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TelescopeBlockEntity(pos, state);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean bl = fluidState.method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        boolean isDay = world.method_8530();
        if (!player.method_5715()) {
            SeatBlock.sitDown(state, world, pos, player);
            return class_1269.field_5812;
        }
        if (isDay) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.cozyhome.telescope.cant_use"), true);
        } else {
            int phase = world.method_30273();
            String moonPhaseSymbol = this.getMoonSymbol(phase);
            class_5250 moonPhaseName = class_2561.method_43471((String)this.getMoonPhaseName(phase));
            class_5250 moonPhaseFact = class_2561.method_43471((String)this.getMoonPhaseFact(phase));
            class_5250 message = class_2561.method_43470((String)moonPhaseSymbol).method_10852((class_2561)moonPhaseName).method_27693(": ").method_10852((class_2561)moonPhaseFact);
            player.method_7353((class_2561)message, true);
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    private String getMoonSymbol(int phase) {
        return switch (phase) {
            case 0 -> "\u00a79\u00a7l\ud83c\udf15\u00a7r ";
            case 1 -> "\u00a79\u00a7l\ud83c\udf16\u00a7r ";
            case 2 -> "\u00a79\u00a7l\ud83c\udf17\u00a7r ";
            case 3 -> "\u00a79\u00a7l\ud83c\udf18\u00a7r ";
            case 4 -> "\u00a79\u00a7l\ud83c\udf11\u00a7r ";
            case 5 -> "\u00a79\u00a7l\ud83c\udf12\u00a7r ";
            case 6 -> "\u00a79\u00a7l\ud83c\udf13\u00a7r ";
            case 7 -> "\u00a79\u00a7l\ud83c\udf14\u00a7r ";
            default -> throw new IllegalStateException("Unexpected value: " + phase + " from cozyhome");
        };
    }

    private String getMoonPhaseFact(int phase) {
        return switch (phase) {
            case 0 -> TelescopeBlock.randomText(TelescopeBlock.getFullMoonFacts());
            case 1 -> TelescopeBlock.randomText(WANING_GIBBOUS_FACTS);
            case 2 -> TelescopeBlock.randomText(LAST_QUARTER_FACTS);
            case 3 -> TelescopeBlock.randomText(WANING_CRESCENT_FACTS);
            case 4 -> TelescopeBlock.randomText(NEW_MOON_FACTS);
            case 5 -> TelescopeBlock.randomText(WAXING_CRESCENT_FACTS);
            case 6 -> TelescopeBlock.randomText(FIRST_QUARTER_FACTS);
            case 7 -> TelescopeBlock.randomText(WAXING_GIBBOUS_FACTS);
            default -> TelescopeBlock.randomText(GENERAL_FACTS);
        };
    }

    private String getMoonPhaseName(int phase) {
        return switch (phase) {
            case 0 -> "message.cozyhome.telescope.full_moon";
            case 1 -> "message.cozyhome.telescope.waning_gibbous";
            case 2 -> "message.cozyhome.telescope.last_quarter";
            case 3 -> "message.cozyhome.telescope.waning_crescent";
            case 4 -> "message.cozyhome.telescope.new_moon";
            case 5 -> "message.cozyhome.telescope.waxing_crescent";
            case 6 -> "message.cozyhome.telescope.first_quarter";
            case 7 -> "message.cozyhome.telescope.waxing_gibbous";
            default -> throw new IllegalStateException("Unexpected value: " + phase);
        };
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add(class_5244.field_39003);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_hand_at_night").method_27692(class_124.field_1080));
        tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.lunar_tips")));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public float getSeatRotation(class_2680 state, class_1937 world, class_2338 pos) {
        return ModProperties.setSeatRotationFromFacing(state) + 180.0f;
    }

    @Override
    public float getSeatHeight(class_2680 state) {
        return 0.2f;
    }

    public static boolean isFacingMoon(class_1937 world, class_2680 state, class_2338 pos, float rawYaw, float pitch) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TelescopeBlockEntity) {
            TelescopeBlockEntity telescopeBlockEntity = (TelescopeBlockEntity)class_25862;
            float yaw360 = (rawYaw % 360.0f + 360.0f) % 360.0f;
            long timeOfDay = world.method_8532();
            float moonYawNeeded = timeOfDay < 18000L ? 270.0f : 90.0f;
            float moonPitchBasedOnTime = TelescopeBlock.getMoonPitchFromTime(timeOfDay);
            boolean isYawCorrect = moonPitchBasedOnTime >= 85.0f || yaw360 >= moonYawNeeded - 5.0f && yaw360 <= moonYawNeeded + 5.0f;
            boolean isPitchCorrect = pitch >= moonPitchBasedOnTime - 5.0f && pitch <= moonPitchBasedOnTime + 5.0f;
            System.out.println((isYawCorrect && isPitchCorrect) + ", Yaw: " + yaw360 + ", Pitch: " + pitch + ", Moon Yaw Needed: " + moonYawNeeded + ", Moon Pitch Needed: " + moonPitchBasedOnTime);
            return isYawCorrect && isPitchCorrect;
        }
        return false;
    }

    public static float getMoonYawFromTime(long timeOfDay) {
        float yaw = (float)(timeOfDay %= 24000L) / 24000.0f * 360.0f;
        return yaw;
    }

    public static float getMoonPitchFromTime(long timeOfDay) {
        if ((timeOfDay %= 24000L) < 12775L || timeOfDay > 23225L) {
            return Float.NaN;
        }
        if (timeOfDay <= 18000L) {
            float t = ((float)timeOfDay - 12775.0f) / 5225.0f;
            return t * 90.0f;
        }
        float t = ((float)timeOfDay - 18000.0f) / 5225.0f;
        return (1.0f - t) * 90.0f;
    }
}

