/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.sofas;

import com.google.common.collect.Maps;
import java.util.Map;
import net.luckystudio.cozyhome.block.custom.sofas.SofaBlock;
import net.luckystudio.cozyhome.block.custom.sofas.SofaBlockEntity;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.client.ModEntityModelLayers;
import net.luckystudio.cozyhome.item.ModItems;
import net.luckystudio.cozyhome.util.ModColorHandler;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_9282;

public class SofaBlockEntityRenderer
implements class_827<SofaBlockEntity> {
    private final class_630 sofa;
    private final class_630 cushion;
    private static final Map<SofaBlock.SofaType, class_2960> SOFA_TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(SofaBlock.Type.OAK, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/oak_sofa.png"));
        map.put(SofaBlock.Type.SPRUCE, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/spruce_sofa.png"));
        map.put(SofaBlock.Type.BIRCH, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/birch_sofa.png"));
        map.put(SofaBlock.Type.JUNGLE, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/jungle_sofa.png"));
        map.put(SofaBlock.Type.ACACIA, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/acacia_sofa.png"));
        map.put(SofaBlock.Type.DARK_OAK, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/dark_oak_sofa.png"));
        map.put(SofaBlock.Type.MANGROVE, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/mangrove_sofa.png"));
        map.put(SofaBlock.Type.CHERRY, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/cherry_sofa.png"));
        map.put(SofaBlock.Type.BAMBOO, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/bamboo_sofa.png"));
        map.put(SofaBlock.Type.CRIMSON, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/crimson_sofa.png"));
        map.put(SofaBlock.Type.WARPED, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/warped_sofa.png"));
        map.put(SofaBlock.Type.PRINCESS, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/princess_sofa.png"));
        map.put(SofaBlock.Type.IRON, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/iron_sofa.png"));
        map.put(SofaBlock.Type.GLASS, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/glass_sofa.png"));
        map.put(SofaBlock.Type.UNDEAD, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/undead_sofa.png"));
        map.put(SofaBlock.Type.OMINOUS, class_2960.method_60655((String)"cozyhome", (String)"textures/block/sofa/ominous_sofa_inactive.png"));
    });
    private static final Map<class_1792, class_2960> CUSHION_TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(ModItems.CUSHION, class_2960.method_60655((String)"cozyhome", (String)"textures/block/cushion/cushion.png"));
        map.put(ModItems.HAY_CUSHION, class_2960.method_60655((String)"cozyhome", (String)"textures/block/cushion/hay_cushion.png"));
        map.put(ModItems.TRADER_CUSHION, class_2960.method_60655((String)"cozyhome", (String)"textures/block/cushion/trader_cushion.png"));
    });

    public int method_33893() {
        return 64;
    }

    public SofaBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.sofa = ctx.method_32140(ModEntityModelLayers.SOFA);
        this.cushion = ctx.method_32140(ModEntityModelLayers.SOFA_CUSHION);
    }

    public void render(SofaBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        int color = ModColorHandler.getBlockColor(entity, -17170434);
        matrices.method_22904(0.5, 1.5, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(ModProperties.setSeatRotationFromRotation(entity.method_11010())));
        class_2680 blockState = entity.method_11010();
        SofaBlock.SofaType sofaType = ((SofaBlock)blockState.method_26204()).getSofaType();
        class_1921 sofaRenderLayer = SofaBlockEntityRenderer.getSofaRenderLayer(sofaType);
        class_4588 frameVertexConsumer = vertexConsumers.getBuffer(sofaRenderLayer);
        this.sofa.method_32086("frame").method_22698(matrices, frameVertexConsumer, light, overlay);
        class_4588 dyeableVertexConsumer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)SOFA_TEXTURES.get(sofaType)));
        this.sofa.method_32086("dyeable").method_22699(matrices, dyeableVertexConsumer, light, overlay, color);
        if (!entity.method_5442()) {
            class_1792 item = entity.method_54079().method_7909();
            int colorItem = class_9282.method_57470((class_1799)entity.method_54079(), (int)-17170434);
            class_1921 cushionRenderLayer = SofaBlockEntityRenderer.getCushionRenderLayer(item);
            class_4588 cushionVertexConsumer = vertexConsumers.getBuffer(cushionRenderLayer);
            this.cushion.method_22699(matrices, cushionVertexConsumer, light, overlay, colorItem);
        }
        matrices.method_22909();
    }

    public static class_1921 getSofaRenderLayer(SofaBlock.SofaType type) {
        class_2960 identifier = SOFA_TEXTURES.get(type);
        return class_1921.method_28116((class_2960)identifier);
    }

    public static class_1921 getCushionRenderLayer(class_1792 item) {
        class_2960 identifier = CUSHION_TEXTURES.get(item);
        return class_1921.method_28116((class_2960)identifier);
    }
}

