/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.sofas;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import net.luckystudio.cozyhome.block.custom.AbstractSeatBlock;
import net.luckystudio.cozyhome.block.custom.sofas.SofaBlockEntity;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.item.ModItems;
import net.luckystudio.cozyhome.item.custom.CushionItem;
import net.luckystudio.cozyhome.util.ModColorHandler;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5253;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7718;
import net.minecraft.class_9062;
import net.minecraft.class_9282;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SofaBlock
extends AbstractSeatBlock {
    public static final MapCodec<SofaBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SofaType.CODEC.fieldOf("kind").forGetter(SofaBlock::getSofaType), (App)SofaBlock.method_54096()).apply((Applicative)instance, SofaBlock::new));
    public static final class_2758 ROTATION = class_2741.field_12532;
    private static final class_265 BASE_SHAPE = SofaBlock.method_9541((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final SofaType type;

    public SofaBlock(SofaType SofaType2, class_4970.class_2251 settings) {
        super(settings);
        this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0));
        this.type = SofaType2;
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SofaBlockEntity(pos, state);
    }

    protected MapCodec<? extends AbstractSeatBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ROTATION});
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        boolean isSneaking = ctx.method_8036().method_5715();
        int rotationOffset = isSneaking ? 180 : 0;
        return (class_2680)super.method_9605(ctx).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(class_7718.method_45479((float)(ctx.method_8044() + (float)rotationOffset))));
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BASE_SHAPE;
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof SofaBlockEntity) {
            SofaBlockEntity sofaBlockEntity = (SofaBlockEntity)class_25862;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1769) {
                int newColor;
                class_1769 dyeItem = (class_1769)class_17922;
                int itemColor = dyeItem.method_7802().method_7787();
                int blockColor = ModColorHandler.getBlockColor(sofaBlockEntity, -17170434);
                if (blockColor == (newColor = class_5253.class_5254.method_60676((int)blockColor, (int)itemColor))) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.cozyhome.same_color"), true);
                    return class_9062.field_47728;
                }
                class_9323 components = class_9323.method_57827().method_57840(class_9334.field_49644, (Object)new class_9282(newColor, false)).method_57838();
                sofaBlockEntity.method_58684(components);
                stack.method_57008(1, (class_1309)player);
                sofaBlockEntity.method_5431();
                world.method_8413(pos, state, state, 0);
                return class_9062.field_47728;
            }
            class_1799 storedItem = sofaBlockEntity.method_54079();
            if (stack.method_7909() instanceof CushionItem && !stack.method_7960() && storedItem.method_7960()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                class_1799 itemStack2 = stack.method_60504(1, (class_1309)player);
                if (sofaBlockEntity.method_5442()) {
                    sofaBlockEntity.method_54077(itemStack2);
                }
                if (sofaBlockEntity.method_54079() == ModItems.HAY_CUSHION.method_7854()) {
                    world.method_8396(player, pos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                } else {
                    world.method_8396(player, pos, class_3417.field_15226, class_3419.field_15245, 1.0f, 1.0f);
                }
                sofaBlockEntity.method_5431();
                world.method_8413(pos, state, state, 3);
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                return class_9062.field_47728;
            }
            if (!sofaBlockEntity.method_5442() && stack.method_7909() == class_1802.field_8868) {
                class_1799 storedStack = sofaBlockEntity.method_54079();
                class_1799 itemToGive = storedStack.method_7972();
                if (player.method_31548().method_7394(itemToGive)) {
                    storedStack.method_7934(1);
                    if (storedStack.method_7960()) {
                        sofaBlockEntity.method_54077(class_1799.field_8037);
                    }
                    world.method_8396(player, pos, class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
                    sofaBlockEntity.method_5431();
                    world.method_8413(pos, state, state, 3);
                    world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                    return class_9062.field_47728;
                }
            } else {
                return super.method_55765(stack, state, world, pos, player, hand, hit);
            }
        }
        return class_9062.field_47732;
    }

    public SofaType getSofaType() {
        return this.type;
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        if (entity.method_21750()) {
            super.method_9502(world, entity);
        } else {
            this.bounceEntity(entity);
        }
    }

    private void bounceEntity(class_1297 entity) {
        class_243 vec3d = entity.method_18798();
        if (vec3d.field_1351 < 0.0) {
            double d = entity instanceof class_1309 ? 1.0 : 0.8;
            entity.method_18800(vec3d.field_1352, -vec3d.field_1351 * (double)0.66f * d, vec3d.field_1350);
        }
    }

    @Override
    public float getSeatRotation(class_2680 state, class_1937 world, class_2338 pos) {
        return ModProperties.setSeatRotationFromRotation(state);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.dyeable").method_27692(class_124.field_1080));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation.method_10502(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirror.method_10344(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public static interface SofaType
    extends class_3542 {
        public static final Map<String, SofaType> TYPES = new Object2ObjectArrayMap();
        public static final Codec<SofaType> CODEC = Codec.stringResolver(class_3542::method_15434, TYPES::get);
    }

    public static enum Type implements SofaType
    {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        MANGROVE("mangrove"),
        CHERRY("cherry"),
        BAMBOO("bamboo"),
        CRIMSON("crimson"),
        WARPED("warped"),
        PRINCESS("princess"),
        IRON("iron"),
        GLASS("iron"),
        UNDEAD("undead"),
        OMINOUS("ominous");

        private final String id;

        private Type(String id) {
            this.id = id;
            TYPES.put(id, this);
        }

        public String method_15434() {
            return this.id;
        }
    }
}

