/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class BattleStates {
    private static Map<UUID, BattleState> STATES = new HashMap<UUID, BattleState>();

    public static BattleState get(PokemonBattle battle) {
        if (!battle.getEnded()) {
            return STATES.computeIfAbsent(battle.getBattleId(), k -> new BattleState());
        }
        return new BattleState();
    }

    public static void notifyPokemonFainted(PokemonBattle battle, BattlePokemon pkmn) {
        if (STATES.containsKey(battle.getBattleId())) {
            BattleStates.get(battle).getActorState(pkmn.actor).removeResponse(pkmn.actor.getActivePokemon().stream().filter(ap -> ap.getBattlePokemon() == pkmn).findFirst().get());
        }
    }

    public static void notifyBattleEnded(PokemonBattle battle) {
        STATES.remove(battle.getBattleId());
    }

    private BattleStates() {
    }

    public static class BattleState {
        private Map<BattlePokemon, PokemonState> pokemonStates = new HashMap<BattlePokemon, PokemonState>();
        private Map<BattleActor, ActorState> actorStates = new HashMap<BattleActor, ActorState>();

        private BattleState() {
        }

        public PokemonState getPokemonState(BattlePokemon pkmn) {
            return this.pokemonStates.computeIfAbsent(pkmn, k -> new PokemonState());
        }

        public ActorState getActorState(BattleActor actor) {
            return this.actorStates.computeIfAbsent(actor, k -> new ActorState());
        }
    }

    public static class ActorState {
        private final Set<ActiveBattlePokemon> responses = new HashSet<ActiveBattlePokemon>();
        private final Set<String> gimmicks = new HashSet<String>();
        private int turn;

        public void addGimmick(String showdownId) {
            this.gimmicks.add(showdownId);
        }

        public boolean hasGimmick(String showdownId) {
            return this.gimmicks.contains(showdownId);
        }

        public void addResponse(ActiveBattlePokemon pkmn) {
            this.responses.add(pkmn);
        }

        public void removeResponse(ActiveBattlePokemon pkmn) {
            this.responses.remove(pkmn);
        }

        public boolean hasResponse(ActiveBattlePokemon pkmn) {
            return this.responses.contains(pkmn);
        }

        public void nextTurn() {
            this.responses.clear();
            ++this.turn;
        }

        public int getTurn() {
            return this.turn;
        }
    }

    public static class PokemonState {
        private static final int[] ZERO = new int[]{0};
        private Map<BattleEffects.Custom, int[]> turnEffectCounters = new HashMap<BattleEffects.Custom, int[]>();
        private long effects;

        private PokemonState() {
        }

        public void nextTurn() {
            if (!this.has(BattleEffects.Custom.TURN)) {
                this.add(BattleEffects.Custom.TURN);
            }
            Iterator<Map.Entry<BattleEffects.Custom, int[]>> it = this.turnEffectCounters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<BattleEffects.Custom, int[]> e = it.next();
                int[] nArray = e.getValue();
                int n = nArray[0];
                nArray[0] = n - 1;
                if (n > 0) continue;
                this.effects ^= e.getKey().mask();
                it.remove();
            }
        }

        public boolean has(BattleEffects.Custom e) {
            return (e.mask() & this.effects) != 0L;
        }

        public int age(BattleEffects.Custom e) {
            return this.has(e) ? e.expires() - this.turnEffectCounters.getOrDefault((Object)e, ZERO)[0] : 0;
        }

        public void add(BattleEffects.Custom e) {
            if (e.expires() >= 0) {
                this.turnEffectCounters.put(e, new int[]{e.expires()});
            }
            this.effects |= e.mask();
        }
    }
}

