/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.config;

import com.gitlab.srcmc.rctapi.api.ai.RCTBattleAI;
import com.gitlab.srcmc.rctapi.api.util.JTO;

public record RCTBattleAIConfig(Double moveBias, Double statusMoveBias, Double switchBias, Double itemBias, Double maxSelectMargin) {
    private static final double DEFAULT_MOVE_BIAS = 1.0;
    private static final double DEFAULT_STATUS_MOVE_BIAS = 0.85;
    private static final double DEFAULT_SWITCH_BIAS = 0.85;
    private static final double DEFAULT_ITEM_BIAS = 0.85;
    private static final double DEFAULT_MAX_SELECT_MARGIN = 0.25;

    public RCTBattleAIConfig() {
        this(1.0, 0.85, 0.85, 0.85, 0.25);
    }

    public RCTBattleAIConfig {
        if (moveBias == null) {
            moveBias = 1.0;
        }
        if (statusMoveBias == null) {
            statusMoveBias = 0.85;
        }
        if (switchBias == null) {
            switchBias = 0.85;
        }
        if (itemBias == null) {
            itemBias = 0.85;
        }
        if (maxSelectMargin == null) {
            maxSelectMargin = 0.25;
        }
    }

    public static void register() {
        JTO.registerParser("rct", RCTBattleAI::new, RCTBattleAIConfig::new, RCTBattleAIConfig.class);
    }

    public static class Builder {
        private double moveBias = 1.0;
        private double statusMoveBias = 0.85;
        private double switchBias = 0.85;
        private double itemBias = 0.85;
        private double maxSelectMargin = 0.25;

        public Builder withMoveBias(double moveBias) {
            this.moveBias = moveBias;
            return this;
        }

        public Builder withStatusMoveBias(double statusMoveBias) {
            this.statusMoveBias = statusMoveBias;
            return this;
        }

        public Builder withSwitchBias(double switchBias) {
            this.switchBias = switchBias;
            return this;
        }

        public Builder withItemBias(double itemBias) {
            this.itemBias = itemBias;
            return this;
        }

        public Builder withMaxSelectMargin(double maxSelectMargin) {
            this.maxSelectMargin = maxSelectMargin;
            return this;
        }

        public RCTBattleAIConfig build() {
            return new RCTBattleAIConfig(this.moveBias, this.statusMoveBias, this.switchBias, this.itemBias, this.maxSelectMargin);
        }
    }
}

