/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.util;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class NBTUtil {
    public static boolean compareNbt(@Nullable class_2520 tagA, @Nullable class_2520 tagB, boolean fuzzy, boolean compareLists) {
        if (tagA == tagB) {
            return true;
        }
        if (tagA == null) {
            return true;
        }
        if (tagB == null) {
            return false;
        }
        if (!tagA.method_23258().equals((Object)tagB.method_23258())) {
            return false;
        }
        if (tagA instanceof class_2487) {
            class_2487 compoundA = (class_2487)tagA;
            if (tagB instanceof class_2487) {
                class_2487 compoundB = (class_2487)tagB;
                Set keysA = compoundA.method_10541();
                Set keysB = compoundB.method_10541();
                if (!(fuzzy || keysA.size() == keysB.size() && Sets.intersection((Set)keysA, (Set)keysB).size() == keysA.size())) {
                    return false;
                }
                return keysA.stream().allMatch(key -> NBTUtil.compareNbt(compoundA.method_10580(key), compoundB.method_10580(key), fuzzy, compareLists));
            }
        }
        if (compareLists && tagA instanceof class_2499) {
            class_2499 listA = (class_2499)tagA;
            if (tagB instanceof class_2499) {
                class_2499 listB = (class_2499)tagB;
                if (listA.isEmpty()) {
                    return listB.isEmpty();
                }
                if (listA.size() != listB.size()) {
                    return false;
                }
                return IntStream.range(0, listA.size()).allMatch(i -> NBTUtil.compareNbt(listA.method_10534(i), listB.method_10534(i), fuzzy, true));
            }
        }
        return tagA.equals((Object)tagB);
    }
}

