/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.client.Textures;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractCompoundFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.FTBFilterSystemClient;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.SelectionPanel;
import dev.ftb.mods.ftbfiltersystem.network.SyncFilterMessage;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_768;
import net.minecraft.class_7843;
import net.minecraft.class_8021;
import net.minecraft.class_8666;
import net.minecraft.class_8667;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class FilterScreen
extends AbstractFilterScreen {
    private static SelectionPanel selectionPanel = null;
    private final SmartFilter filter;
    private final String origFilterStr;
    private final class_1268 interactionHand;
    private int leftPos;
    private int topPos;
    private int guiWidth;
    private int guiHeight;
    private FilterList filterList;
    private class_4185 addFilterBtn;
    private class_4185 deleteFilterBtn;
    private class_4185 configFilterBtn;
    private class_4185 titleEditBtn;
    private class_342 titleEditBox;
    private SmartFilter newSelection = null;
    private class_2561 newTitle = null;
    private boolean showingTitleEdit = false;

    public FilterScreen(class_2561 component, SmartFilter filter, class_1268 interactionHand) {
        super(component);
        this.interactionHand = interactionHand;
        selectionPanel = null;
        this.filter = filter;
        this.origFilterStr = filter.toString();
    }

    protected void method_25426() {
        super.method_25426();
        this.setupGuiDimensions();
        this.getSelectionPanel().visitWidgets(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.filterList = new FilterList(this.field_22787, this.topPos + 20, this.getListWidth(), this.getListHeight());
        this.filterList.method_46421(this.leftPos + 8);
        this.method_25429((class_364)this.filterList);
        this.titleEditBtn = (class_4185)this.method_37063((class_364)new class_344(this.leftPos, this.topPos + 3, 16, 16, new class_8666(Textures.EDIT_BUTTON, Textures.EDIT_BUTTON_HI), b -> {
            this.showingTitleEdit = true;
        }));
        int n = this.getListWidth();
        Objects.requireNonNull(this.field_22793);
        this.titleEditBox = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.leftPos + 5, this.topPos + 4, n, 9 + 4, (class_2561)class_2561.method_43473()));
        this.titleEditBox.field_22764 = false;
        this.titleEditBox.method_1852(this.field_22785.getString());
        int buttonWidth = this.guiWidth - this.getListWidth() - 25;
        class_8667 buttonPanel = new class_8667(this.leftPos + this.getListWidth() + 15, this.topPos + 20, class_8667.class_8668.field_45404).method_52735(2);
        this.addFilterBtn = (class_4185)buttonPanel.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ftbfiltersystem.gui.add"), b -> this.getSelectionPanel().setVisible(true)).method_46432(buttonWidth).method_46431());
        this.deleteFilterBtn = (class_4185)buttonPanel.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ftbfiltersystem.gui.delete"), b -> this.deleteSelectedFilter(true)).method_46432(buttonWidth).method_46431());
        this.configFilterBtn = (class_4185)buttonPanel.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ftbfiltersystem.gui.configure"), b -> this.configureSelectedFilter(false)).method_46432(buttonWidth).method_46431());
        buttonPanel.method_48222();
        buttonPanel.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        class_8667 bottomPanel = new class_8667(this.leftPos, this.topPos + this.guiHeight - 25, class_8667.class_8668.field_45403);
        ((class_7843)bottomPanel.method_52736((class_8021)new class_7843(this.guiWidth / 2, 20))).method_46441((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.applyChanges()).method_46437(80, 20).method_46431());
        ((class_7843)bottomPanel.method_52736((class_8021)new class_7843(this.guiWidth / 2, 20))).method_46441((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, b -> this.closeWithConfirmation()).method_46437(80, 20).method_46431());
        bottomPanel.method_48222();
        bottomPanel.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        if (this.filterList.method_25334() == null) {
            this.findAndSelect(this.filter);
        } else {
            this.setupButtons();
        }
    }

    private void applyNewTitle() {
        this.newTitle = class_2561.method_43470((String)this.titleEditBox.method_1882());
        if (this.newTitle.getString().equals(this.field_22785.getString())) {
            this.newTitle = null;
        }
        this.showingTitleEdit = false;
    }

    private SelectionPanel getSelectionPanel() {
        if (selectionPanel == null) {
            selectionPanel = new SelectionPanel(this.field_22793, this::createNewFilter, this.field_22790 - (this.topPos + 20) - 5);
        }
        return selectionPanel;
    }

    private void setupButtons() {
        FilterList.FilterEntry selected = (FilterList.FilterEntry)this.filterList.method_25334();
        this.addFilterBtn.field_22763 = selected != null && this.canAddMoreFilters(selected.dumpedFilter.filter());
        this.deleteFilterBtn.field_22763 = selected != null && selected.dumpedFilter.filter().getParent() != null;
        this.configFilterBtn.field_22763 = selected != null && selected.dumpedFilter.filter().isConfigurable();
    }

    private boolean canAddMoreFilters(SmartFilter filter) {
        SmartFilter.Compound compound;
        if (filter instanceof AbstractCompoundFilter) {
            AbstractCompoundFilter acf = (AbstractCompoundFilter)filter;
            compound = acf;
        } else {
            compound = filter.getParent();
        }
        SmartFilter.Compound parent = compound;
        return parent != null && parent.getChildren().size() < parent.maxChildren();
    }

    private void applyChanges() {
        NetworkManager.sendToServer((class_8710)new SyncFilterMessage(this.filter.toString(), this.newTitle == null ? Optional.empty() : Optional.of(this.newTitle.getString()), this.interactionHand));
        this.method_25419();
        if (this.changesHaveBeenMade()) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"ftbfiltersystem.message.changes_saved").method_27692(class_124.field_1060), true);
        }
    }

    private boolean changesHaveBeenMade() {
        return !this.filter.toString().equals(this.origFilterStr) || this.newTitle != null;
    }

    private void createNewFilter(class_2960 filterId) {
        this.getSelectionPanel().setVisible(false);
        if (this.filterList.method_25334() != null) {
            SmartFilter.Compound parent;
            SmartFilter selectedFilter = ((FilterList.FilterEntry)this.filterList.method_25334()).dumpedFilter.filter();
            if (selectedFilter instanceof AbstractCompoundFilter) {
                AbstractCompoundFilter acf = (AbstractCompoundFilter)selectedFilter;
                v0 = acf;
            } else {
                v0 = parent = selectedFilter.getParent();
            }
            if (parent != null) {
                FTBFilterSystemAPI.api().createDefaultFilter(parent, filterId).ifPresent(newFilter -> {
                    parent.getChildren().add((SmartFilter)newFilter);
                    this.filterList.addChildren();
                    this.filterList.findAndSelect((SmartFilter)newFilter);
                    this.configureSelectedFilter(true);
                });
            }
        }
    }

    @Override
    public void deleteSelectedFilter(boolean rebuildList) {
        SmartFilter subFilter;
        SmartFilter.Compound parent;
        if (this.filterList.method_25334() != null && (parent = (subFilter = ((FilterList.FilterEntry)this.filterList.method_25334()).dumpedFilter.filter()).getParent()) instanceof SmartFilter.Compound) {
            SmartFilter.Compound compound = parent;
            List<SmartFilter> l = compound.getChildren().stream().filter(f -> f != subFilter).toList();
            compound.getChildren().clear();
            compound.getChildren().addAll(l);
            if (rebuildList) {
                this.filterList.addChildren();
                this.filterList.findAndSelect(parent);
            }
        }
    }

    private void configureSelectedFilter(boolean deleteOnCancel) {
        FilterList.FilterEntry selected = (FilterList.FilterEntry)this.filterList.method_25334();
        if (selected != null) {
            FTBFilterSystemClient.INSTANCE.openFilterConfigScreen(selected.dumpedFilter.filter(), this, deleteOnCancel);
        }
    }

    @Override
    public <T extends SmartFilter> void replaceFilter(T filter, T newFilter) {
        List<SmartFilter> children;
        int idx;
        if (filter.getParent() != null && (idx = (children = filter.getParent().getChildren()).indexOf(filter)) >= 0) {
            children.set(idx, newFilter);
            this.newSelection = newFilter;
        }
    }

    public void method_25393() {
        if (!(this.field_22787.field_1724.method_5998(this.interactionHand).method_7909() instanceof SmartFilterItem)) {
            this.method_25419();
        } else if (this.showingTitleEdit && !this.titleEditBox.method_1885()) {
            this.titleEditBox.field_22764 = true;
            this.titleEditBtn.field_22764 = false;
            if (class_437.method_25442()) {
                this.titleEditBox.method_1872(false);
                this.titleEditBox.method_1884(0);
            }
            this.method_25395((class_364)this.titleEditBox);
        } else if (!this.showingTitleEdit && this.titleEditBox.method_1885()) {
            this.titleEditBox.field_22764 = false;
            this.titleEditBtn.field_22764 = true;
            this.method_25395((class_364)this.filterList);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.guiHeight > 0) {
            GuiUtil.drawPanel(guiGraphics, new class_768(this.leftPos + 7, this.topPos + 19, this.getListWidth() + 2, this.getListHeight() + 1), -6250336, -6250336, GuiUtil.BorderStyle.INSET, 1);
            this.filterList.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            class_2561 displayTitle = this.newTitle == null ? this.field_22785 : this.newTitle;
            guiGraphics.method_51439(this.field_22793, displayTitle, this.leftPos + 8, this.topPos + 7, 0x404040, false);
            this.titleEditBtn.method_46421(this.leftPos + this.field_22793.method_27525((class_5348)displayTitle) + 8);
        }
        if (this.getSelectionPanel().isVisible()) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + this.guiWidth, this.topPos + this.guiHeight, -1608507360);
            this.getSelectionPanel().positionAndRender(guiGraphics, this.addFilterBtn.method_46427(), this.addFilterBtn.method_46426() - 10, mouseX, mouseY, partialTick);
            guiGraphics.method_51448().method_22909();
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_52706(Textures.BACKGROUND, this.leftPos, this.topPos, this.guiWidth, this.guiHeight);
    }

    public void method_25419() {
        this.getSelectionPanel().setVisible(false);
        super.method_25419();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256 || this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            if (this.getSelectionPanel().isVisible()) {
                this.getSelectionPanel().setVisible(false);
                return true;
            }
            if (this.titleEditBox.method_20315()) {
                if (keyCode == 256) {
                    this.titleEditBox.method_1852(this.newTitle == null ? this.field_22785.getString() : this.newTitle.getString());
                    this.showingTitleEdit = false;
                } else {
                    this.titleEditBox.method_25404(keyCode, scanCode, modifier);
                }
                return true;
            }
            this.closeWithConfirmation();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.titleEditBox.method_20315()) {
                this.applyNewTitle();
                return true;
            }
            if (class_437.method_25442()) {
                this.applyChanges();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifier);
    }

    private void closeWithConfirmation() {
        if (this.changesHaveBeenMade()) {
            this.newSelection = this.filterList.getSelectedFilter();
            this.field_22787.method_1507((class_437)new class_410(this::exitCallback, (class_2561)class_2561.method_43471((String)"ftbfiltersystem.gui.changes_made"), (class_2561)class_2561.method_43471((String)"ftbfiltersystem.gui.changes_made.question")));
        } else {
            this.method_25419();
        }
    }

    private void exitCallback(boolean confirmed) {
        if (confirmed) {
            this.method_25419();
        } else {
            this.field_22787.method_1507((class_437)this);
            this.findAndSelect(this.newSelection);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.getSelectionPanel().isVisible() && !this.getSelectionPanel().isMouseOver(mouseX, mouseY)) {
            this.getSelectionPanel().setVisible(false);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private int getListWidth() {
        return this.guiWidth - 100;
    }

    private int getListHeight() {
        return this.guiHeight - 50;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.field_22789 = width;
        this.field_22790 = height;
        this.setupGuiDimensions();
        SmartFilter selected = this.filterList.method_25334() == null ? null : ((FilterList.FilterEntry)this.filterList.method_25334()).dumpedFilter.filter();
        this.method_48640();
        this.getSelectionPanel().resize(height - (this.topPos + 20) - 5);
        this.findAndSelect(selected);
    }

    private void setupGuiDimensions() {
        this.guiWidth = this.field_22789 * 2 / 3;
        this.guiHeight = this.field_22790 * 3 / 4;
        this.leftPos = (this.field_22789 - this.guiWidth) / 2;
        this.topPos = (this.field_22790 - this.guiHeight) / 2;
    }

    @Override
    public void findAndSelect(@Nullable SmartFilter filter) {
        if (filter != null) {
            this.filterList.findAndSelect(filter);
        }
    }

    private class FilterList
    extends class_4280<FilterEntry> {
        private static final int ELEMENT_HEIGHT = 12;
        private FilterEntry dragging;
        private SmartFilter.Compound dragTarget;

        public FilterList(class_310 minecraft, int y, int width, int height) {
            super(minecraft, width, height, y, 12);
            this.dragging = null;
            this.dragTarget = null;
            this.addChildren();
        }

        protected void method_57715(class_332 guiGraphics) {
        }

        private void addChildren() {
            ArrayList entries = new ArrayList();
            List<DumpedFilter> dumped = FTBFilterSystemAPI.api().dump(FilterScreen.this.filter);
            dumped.forEach(entry -> entries.add(new FilterEntry((DumpedFilter)entry)));
            this.method_25396().clear();
            this.method_25396().addAll(entries);
            if (FilterScreen.this.newSelection != null) {
                this.findAndSelect(FilterScreen.this.newSelection);
                FilterScreen.this.newSelection = null;
            }
        }

        private SmartFilter getSelectedFilter() {
            return this.method_25334() == null ? null : ((FilterEntry)this.method_25334()).dumpedFilter.filter();
        }

        public int method_25322() {
            return FilterScreen.this.getListWidth();
        }

        protected int method_25329() {
            return FilterScreen.this.leftPos + this.field_22758 + 8;
        }

        public void method_47399(class_6382 narrationElementOutput) {
        }

        public void setSelected(@Nullable FilterEntry entry) {
            super.method_25313((class_350.class_351)entry);
            FilterScreen.this.setupButtons();
        }

        public boolean method_25406(double mouseX, double mouseY, int btn) {
            if (this.dragging != null && this.dragTarget != null) {
                FilterParser.parseFilterList(this.dragTarget, this.dragging.dumpedFilter.filter().toString()).stream().findFirst().ifPresent(newFilter -> {
                    this.dragTarget.getChildren().add((SmartFilter)newFilter);
                    FilterScreen.this.deleteSelectedFilter(false);
                    this.addChildren();
                    this.findAndSelect((SmartFilter)newFilter);
                });
            }
            this.dragging = null;
            this.dragTarget = null;
            return super.method_25406(mouseX, mouseY, btn);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
            SmartFilter smartFilter;
            if (this.dragging == null) return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
            FilterEntry entry = (FilterEntry)this.method_25308(pMouseX, pMouseY);
            if (entry != null && (smartFilter = entry.dumpedFilter.filter()) instanceof SmartFilter.Compound) {
                SmartFilter.Compound compound = (SmartFilter.Compound)smartFilter;
                if (!(this.dragging.dumpedFilter.filter() instanceof SmartFilter.Compound && entry.dumpedFilter.indent() > this.dragging.dumpedFilter.indent() || compound == this.dragging.dumpedFilter.filter() || compound == this.dragging.dumpedFilter.filter().getParent() || compound.getChildren().size() >= compound.maxChildren())) {
                    this.dragTarget = compound;
                    return true;
                }
            }
            this.dragTarget = null;
            return true;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 32 || keyCode == 257) {
                FilterScreen.this.configureSelectedFilter(false);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        protected void method_25320(class_332 guiGraphics, int pMouseX, int pMouseY) {
            FilterEntry entry;
            if (this.dragging != null && (entry = (FilterEntry)this.method_25308(pMouseX, pMouseY)) != null && entry.dumpedFilter.filter() != this.dragging.dumpedFilter.filter()) {
                int w = FilterScreen.this.field_22793.method_27525((class_5348)this.dragging.dumpedFilter.filter().getDisplayName());
                guiGraphics.method_25294(pMouseX, pMouseY - 6 + 1, pMouseX + w + 10, pMouseY + 6, -1058934275);
                guiGraphics.method_49601(pMouseX, pMouseY - 6 + 1, w + 10, 12, -1069531072);
                guiGraphics.method_51439(FilterScreen.this.field_22793, this.dragging.dumpedFilter.filter().getDisplayName(), pMouseX + 5, pMouseY - 6 + 3, -1069531072, false);
            }
        }

        protected void method_44398(class_332 guiGraphics, int pTop, int pWidth, int pHeight, int pOuterColor, int pInnerColor) {
            int minX = this.method_46426() + (this.field_22758 - pWidth) / 2;
            int maxX = this.method_46426() + (this.field_22758 + pWidth) / 2;
            int col = this.method_25370() ? -1969667 : -5851964;
            GuiUtil.drawPanel(guiGraphics, new class_768(minX + 1, pTop - 2, maxX - minX - 2, pHeight + 3), col, -12164180, GuiUtil.BorderStyle.PLAIN, 1);
        }

        protected void method_57713(class_332 guiGraphics) {
        }

        private void findAndSelect(SmartFilter filter) {
            this.method_25396().stream().filter(entry -> entry.dumpedFilter.filter() == filter).findFirst().ifPresent(this::setSelected);
        }

        private class FilterEntry
        extends class_4280.class_4281<FilterEntry> {
            private final DumpedFilter dumpedFilter;
            private long lastClickTime;

            public FilterEntry(DumpedFilter dumpedFilter) {
                this.dumpedFilter = dumpedFilter;
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                int labelLeft = left + this.dumpedFilter.indent() * 10;
                int yBase = top + height / 2;
                if (this.dumpedFilter.filter() == FilterList.this.dragTarget && FilterList.this.dragging.dumpedFilter.filter() != FilterList.this.dragTarget) {
                    int n = labelLeft + FilterScreen.this.field_22793.method_27525((class_5348)this.getLabel()) + 2;
                    Objects.requireNonNull(FilterScreen.this.field_22793);
                    guiGraphics.method_25294(labelLeft - 2, top - 3, n, top + 9, -3479106);
                    int n2 = FilterScreen.this.field_22793.method_27525((class_5348)this.getLabel()) + 4;
                    Objects.requireNonNull(FilterScreen.this.field_22793);
                    guiGraphics.method_49601(labelLeft - 2, top - 3, n2, 9 + 4, -13604796);
                }
                guiGraphics.method_51439(FilterScreen.this.field_22793, this.getLabel(), labelLeft, top, 0x404040, false);
                if (index > 0) {
                    guiGraphics.method_25292(labelLeft - 8, labelLeft - 2, yBase, -11513728);
                    int yOff = this.calcYoffset(index);
                    guiGraphics.method_25301(labelLeft - 8, yBase, yBase - yOff, -11513728);
                }
            }

            private int calcYoffset(int index) {
                int res = 0;
                for (int i = index - 1; i >= 0; --i) {
                    res += FilterList.this.field_22741;
                    if (((FilterEntry)((Object)FilterList.this.method_25396().get((int)i))).dumpedFilter.indent() < this.dumpedFilter.indent()) break;
                }
                return res - 4;
            }

            public boolean method_25402(double x, double y, int button) {
                FilterList.this.setSelected(this);
                if (this.dumpedFilter.filter().getParent() != null) {
                    FilterList.this.dragging = this;
                }
                if (class_156.method_658() - this.lastClickTime < 250L) {
                    FilterScreen.this.configureSelectedFilter(false);
                } else {
                    this.lastClickTime = class_156.method_658();
                }
                return true;
            }

            private class_2561 getLabel() {
                class_2561 disp = this.dumpedFilter.filter().getDisplayName();
                if (this.dumpedFilter.filter() instanceof SmartFilter.Compound) {
                    return disp;
                }
                class_2561 text = this.dumpedFilter.filter().getDisplayArg();
                return disp.method_27661().method_27693(" ").method_10852((class_2561)text.method_27661().method_27692(class_124.field_1058));
            }

            public class_2561 method_37006() {
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.getLabel()});
            }
        }
    }
}

