/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IProxy;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.PlatformItemHandler;
import com.tom.storagemod.util.IValidInfo;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class NetworkInventory {
    private PlatformInventoryAccess.BlockInventoryAccess block = new PlatformInventoryAccess.BlockInventoryAccess();
    private WeakReference<IInventoryConnector> networkAccess;
    private long lastUpdate;

    public void onLoad(class_1937 level, class_2338 worldPosition, class_2350 side, IValidInfo v) {
        this.block.onLoad(level, worldPosition, side, v);
    }

    public void scanNetwork(class_1937 level, class_2338 worldPosition) {
        this.networkAccess = null;
        Collection<class_2338> netBlocks = InventoryCableNetwork.getNetwork(level).getNetworkNodes(worldPosition);
        for (class_2338 p : netBlocks) {
            IInventoryConnector te;
            class_2586 be;
            if (!level.method_8477(p) || !((be = level.method_8321(p)) instanceof IInventoryConnector) || !(te = (IInventoryConnector)be).hasConnectedInventories()) continue;
            this.networkAccess = new WeakReference<IInventoryConnector>(te);
            break;
        }
    }

    public IInventoryAccess getAccess(class_1937 level, class_2338 worldPosition) {
        IInventoryConnector net;
        if (this.block.exists()) {
            Storage<ItemVariant> storage = this.block.get();
            if (storage instanceof PlatformItemHandler) {
                PlatformItemHandler h = (PlatformItemHandler)storage;
                Set<IProxy> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
                return h.getRootHandler(dejaVu);
            }
            return this.block;
        }
        if (level.method_8510() - this.lastUpdate > 10L) {
            this.scanNetwork(level, worldPosition);
            this.lastUpdate = level.method_8510();
        }
        if (this.networkAccess != null && (net = (IInventoryConnector)this.networkAccess.get()) != null && net.hasConnectedInventories()) {
            return net.getMergedHandler();
        }
        return this.block;
    }

    public boolean isNetwork() {
        return !this.block.exists() && this.networkAccess != null;
    }

    public boolean isValid() {
        return this.block.exists() || this.networkAccess != null;
    }
}

