/*
 * Decompiled with CFR 0.152.
 */
package dev.darcosse.chimeras.fabric.handler;

import dev.darcosse.chimeras.fabric.ChimerasPortalBlock;
import dev.darcosse.chimeras.fabric.entity.WormholeEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class VoidFallHandler {
    public static final class_5321<class_1937> CHIMERAS_DIMENSION = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"cobblemon_ultrabeast", (String)"chimeras_dimension"));
    private static final Set<UUID> processedPlayers = new HashSet<UUID>();

    public static void initialize() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                VoidFallHandler.checkPlayerVoidFall(player);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> processedPlayers.remove(handler.field_14140.method_5667()));
    }

    private static void checkPlayerVoidFall(class_3222 player) {
        if (!player.method_37908().method_27983().equals(CHIMERAS_DIMENSION)) {
            return;
        }
        double playerY = player.method_23318();
        UUID playerId = player.method_5667();
        if (playerY <= -20.0 && !processedPlayers.contains(playerId)) {
            processedPlayers.add(playerId);
            VoidFallHandler.onPlayerReachVoidLimit(player);
        }
        if (playerY > -10.0 && processedPlayers.contains(playerId)) {
            processedPlayers.remove(playerId);
        }
    }

    private static void onPlayerReachVoidLimit(class_3222 player) {
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318(), player.method_23321(), 50, 1.0, 1.0, 1.0, 0.1);
        VoidFallHandler.handleChimeraVoidFall(player);
    }

    private static void handleChimeraVoidFall(class_3222 player) {
        ChimerasPortalBlock.killAllPokemonsOfWorld((class_3218)player.method_37908());
        ChimerasPortalBlock.checkAndPlaceChimerasCore((class_3218)player.method_37908());
        VoidFallHandler.teleportBackToOverworld(player);
    }

    private static void teleportBackToOverworld(class_3222 player) {
        class_2338 savedPos = WormholeEntity.savedPositions.get(player.method_5667());
        class_3218 overworldWorld = player.method_5682().method_30002();
        player.method_6092(new class_1293(class_1294.field_5907, 100, 254, false, false, true));
        player.method_5783(class_3417.field_14879, 1.5f, 1.0f);
        overworldWorld.method_8503().execute(() -> {
            if (savedPos != null) {
                player.method_14251(overworldWorld, (double)savedPos.method_10263() + 0.5, (double)savedPos.method_10264(), (double)savedPos.method_10260() + 0.5, 0.0f, 0.0f);
                overworldWorld.method_14199((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 30, 0.5, 1.0, 0.5, 0.1);
                WormholeEntity.savedPositions.remove(player.method_5667());
            } else {
                class_2338 worldSpawn = overworldWorld.method_43126();
                player.method_14251(overworldWorld, (double)worldSpawn.method_10263() + 0.5, (double)worldSpawn.method_10264(), (double)worldSpawn.method_10260() + 0.5, 0.0f, 0.0f);
            }
        });
    }
}

