/*
 * Decompiled with CFR 0.152.
 */
package dev.darcosse.chimeras.fabric.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import dev.darcosse.chimeras.fabric.Chimeras;
import dev.darcosse.chimeras.fabric.config.ConfigManager;
import dev.darcosse.chimeras.fabric.entity.ModEntities;
import dev.darcosse.chimeras.fabric.registry.ModSounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_8779;

public class WormholeEntity
extends class_1297 {
    private static WormholeEntity activeWormhole = null;
    private static long wormholePlacementTime = 0L;
    private static final int LIFESPAN_TICKS = 1200;
    private static final int PARTICLE_INTERVAL = 20;
    public static final Map<UUID, class_2338> savedPositions = new HashMap<UUID, class_2338>();
    private int particleTimer = 0;
    private static final int AMBIENT_SOUND_LENGTH_TICKS = 520;
    private int ambientSoundTimer = 0;

    public WormholeEntity(class_1299<? extends WormholeEntity> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
        this.method_5684(true);
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            class_3218 world = (class_3218)this.method_37908();
            long currentTime = world.method_8510();
            long elapsed = currentTime - wormholePlacementTime;
            if (elapsed >= 1200L) {
                this.method_31472();
                WormholeEntity.clearActiveWormhole();
                return;
            }
            ++this.ambientSoundTimer;
            if (this.ambientSoundTimer >= 520 || this.ambientSoundTimer == 1) {
                world.method_8396(null, this.method_24515(), ModSounds.PORTAL_AMBIENT, class_3419.field_15251, 1.0f, 0.5f);
                this.ambientSoundTimer = 0;
            }
            ++this.particleTimer;
            if (this.particleTimer >= 20) {
                this.spawnParticles();
                this.particleTimer = 0;
            }
        }
    }

    public static void tryRandomSpawn(class_3218 world, Random random) {
        if (!world.method_27983().equals(class_1937.field_25179)) {
            return;
        }
        if (WormholeEntity.hasActiveWormhole(world)) {
            return;
        }
        if (random.nextInt(ConfigManager.getWormholeSpawnChance()) != 0) {
            return;
        }
        class_2338 spawnPos = WormholeEntity.findValidSpawnLocation(world, random);
        if (spawnPos != null) {
            WormholeEntity.spawnWormhole(world, spawnPos);
        }
    }

    public static boolean hasActiveWormhole(class_3218 world) {
        return activeWormhole != null && !activeWormhole.method_31481() && activeWormhole.method_37908() == world;
    }

    private static class_2338 findValidSpawnLocation(class_3218 world, Random random) {
        if (world.method_18456().isEmpty()) {
            return null;
        }
        List players = world.method_18456();
        class_3222 randomPlayer = (class_3222)players.get(random.nextInt(players.size()));
        class_2338 playerPos = randomPlayer.method_24515();
        int searchRadius = 20;
        int attempts = 30;
        int minHeightAboveGround = 6;
        for (int i = 0; i < attempts; ++i) {
            int x = playerPos.method_10263() + random.nextInt(searchRadius * 2) - searchRadius;
            int z = playerPos.method_10260() + random.nextInt(searchRadius * 2) - searchRadius;
            class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, new class_2338(x, world.method_31600(), z));
            class_2338 spawnPos = surfacePos.method_10086(minHeightAboveGround);
            if (!WormholeEntity.isValidAirSpawnLocation(world, spawnPos, minHeightAboveGround)) continue;
            return spawnPos;
        }
        return null;
    }

    private static boolean isValidAirSpawnLocation(class_3218 world, class_2338 pos, int airBlocksBelow) {
        class_2338 checkPos;
        int i;
        for (i = 1; i <= airBlocksBelow; ++i) {
            checkPos = pos.method_10087(i);
            if (world.method_8320(checkPos).method_26215()) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            checkPos = pos.method_10086(i);
            if (world.method_8320(checkPos).method_26215()) continue;
            return false;
        }
        return true;
    }

    private static void spawnWormhole(class_3218 world, class_2338 pos) {
        WormholeEntity wormhole = new WormholeEntity(ModEntities.WORMHOLE, (class_1937)world);
        wormhole.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        world.method_8649((class_1297)wormhole);
        world.method_8396(null, pos, class_3417.field_14703, class_3419.field_15251, 3.0f, 0.8f);
        activeWormhole = wormhole;
        wormholePlacementTime = world.method_8510();
        class_3222 nearestPlayer = (class_3222)world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 64.0, false);
        if (nearestPlayer != null) {
            nearestPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.cobblemon_chimeras.portal_spawn"), false);
        }
    }

    private static void clearActiveWormhole() {
        activeWormhole = null;
        wormholePlacementTime = 0L;
    }

    private void spawnParticles() {
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.teleportToChimerasDimension(serverPlayer);
            this.method_5783(class_3417.field_14879, 1.0f, 1.0f);
            this.method_31472();
            WormholeEntity.clearActiveWormhole();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_5694(class_1657 player) {
        if (!this.method_37908().field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f);
            this.teleportToChimerasDimension(serverPlayer);
            this.method_31472();
            WormholeEntity.clearActiveWormhole();
        }
        super.method_5694(player);
    }

    private void teleportToChimerasDimension(class_3222 player) {
        class_3218 chimerasWorld = player.method_5682().method_3847(Chimeras.CHIMERAS_DIMENSION);
        if (chimerasWorld != null) {
            if (player.method_37908().method_27983().equals(class_1937.field_25179)) {
                savedPositions.put(player.method_5667(), player.method_24515());
            }
            WormholeEntity.checkAndPlaceChimerasCore(chimerasWorld);
            WormholeEntity.killAllPokemonsOfWorld(chimerasWorld);
            this.grantChimerasAdvancement(player);
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14879, class_3419.field_15248, 1.5f, 1.0f);
            player.method_14251(chimerasWorld, 0.5, 83.0, -19.5, player.method_36454(), player.method_36455());
            player.method_7353((class_2561)class_2561.method_43471((String)"dimension.travel.chimeras"), false);
        }
    }

    public static void checkAndPlaceChimerasCore(class_3218 world) {
        class_2338 centerPos = new class_2338(0, 84, 0);
        boolean coreExists = false;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 checkPos = centerPos.method_10069(x, 0, z);
                if (!world.method_8320(checkPos).method_27852(Chimeras.CHIMERAS_CORE_BLOCK)) continue;
                coreExists = true;
                break;
            }
            if (coreExists) break;
        }
        if (!coreExists) {
            world.method_8501(centerPos, Chimeras.CHIMERAS_CORE_BLOCK.method_9564());
        }
    }

    public static void killAllPokemonsOfWorld(class_3218 chimerasWorld) {
        if (chimerasWorld != null) {
            chimerasWorld.method_18198((class_5575)CobblemonEntities.POKEMON, pokemonEntity -> {
                pokemonEntity.method_31472();
                return false;
            });
        }
    }

    private void grantChimerasAdvancement(class_3222 player) {
        class_167 progress;
        class_2960 advancementId = class_2960.method_60655((String)"cobblemon_ultrabeast", (String)"enter_chimeras_dimension");
        class_8779 advancement = player.method_5682().method_3851().method_12896(advancementId);
        if (advancement != null && !(progress = player.method_14236().method_12882(advancement)).method_740()) {
            for (String criterion : progress.method_731()) {
                player.method_14236().method_12878(advancement, criterion);
            }
        }
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("PlacementTime")) {
            wormholePlacementTime = nbt.method_10537("PlacementTime");
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10544("PlacementTime", wormholePlacementTime);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (this == activeWormhole) {
            activeWormhole = null;
            wormholePlacementTime = 0L;
        }
    }
}

