/*
 * Decompiled with CFR 0.152.
 */
package dev.darcosse.chimeras.fabric.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.darcosse.chimeras.fabric.config.ChimerasConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final String CONFIG_FILE = "cobblemon_ultrabeasts_config.json";
    private static ChimerasConfig config;
    private static final Gson GSON;

    public static void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE);
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (ChimerasConfig)GSON.fromJson((Reader)reader, ChimerasConfig.class);
            }
            catch (IOException e) {
                config = new ChimerasConfig();
            }
        } else {
            config = new ChimerasConfig();
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getWormholeSpawnChance() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return ConfigManager.config.WORMHOLE_SPAWN_CHANCE;
    }

    public static int getTrySpawnInterval() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return ConfigManager.config.TRY_SPAWN_INTERVAL;
    }

    public static void reloadConfig() {
        config = null;
        ConfigManager.loadConfig();
    }

    public static int getCurrentWormholeSpawnChance() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return ConfigManager.config.WORMHOLE_SPAWN_CHANCE;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

