/*
 * Decompiled with CFR 0.152.
 */
package dev.darcosse.chimeras.fabric;

import com.cobblemon.mod.common.CobblemonEntities;
import dev.darcosse.chimeras.fabric.Chimeras;
import dev.darcosse.chimeras.fabric.registry.ModSounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_7134;
import net.minecraft.class_8779;

public class ChimerasPortalBlock
extends class_2248 {
    private static final class_265 SHAPE = ChimerasPortalBlock.createShape();
    private static class_2338 activePortalPos = null;
    private static class_3218 activePortalWorld = null;
    private static long portalPlacementTime = 0L;
    private static final int LIFESPAN_TICKS = 1200;
    private static final int SOUND_INTERVAL = 200;
    public static final Map<UUID, class_2338> savedPositions = new HashMap<UUID, class_2338>();

    public ChimerasPortalBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public static boolean hasActivePortal(class_3218 world) {
        if (activePortalPos == null || activePortalWorld != world) {
            return false;
        }
        class_2680 state = world.method_8320(activePortalPos);
        if (!(state.method_26204() instanceof ChimerasPortalBlock)) {
            ChimerasPortalBlock.clearActivePortal();
            return false;
        }
        return true;
    }

    private static class_2338 findValidSpawnLocation(class_3218 world, Random random) {
        if (world.method_18456().isEmpty()) {
            return null;
        }
        List players = world.method_18456();
        class_3222 randomPlayer = (class_3222)players.get(random.nextInt(players.size()));
        class_2338 playerPos = randomPlayer.method_24515();
        int searchRadius = 20;
        int attempts = 30;
        int minHeightAboveGround = 6;
        for (int i = 0; i < attempts; ++i) {
            int x = playerPos.method_10263() + random.nextInt(searchRadius * 2) - searchRadius;
            int z = playerPos.method_10260() + random.nextInt(searchRadius * 2) - searchRadius;
            class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, new class_2338(x, world.method_31600(), z));
            class_2338 spawnPos = surfacePos.method_10086(minHeightAboveGround);
            if (!ChimerasPortalBlock.isValidAirSpawnLocation(world, spawnPos, minHeightAboveGround)) continue;
            return spawnPos;
        }
        return null;
    }

    private static boolean isValidAirSpawnLocation(class_3218 world, class_2338 pos, int airBlocksBelow) {
        class_2338 checkPos;
        int i;
        for (i = 1; i <= airBlocksBelow; ++i) {
            checkPos = pos.method_10087(i);
            if (world.method_8320(checkPos).method_26215()) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            checkPos = pos.method_10086(i);
            if (world.method_8320(checkPos).method_26215()) continue;
            return false;
        }
        return true;
    }

    private static void clearActivePortal() {
        activePortalPos = null;
        activePortalWorld = null;
        portalPlacementTime = 0L;
    }

    private static class_265 createShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)2.5, (double)1.0, (double)6.0, (double)10.5, (double)5.5, (double)10.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)4.0, (double)1.5, (double)6.5, (double)13.0, (double)13.5, (double)9.5));
        shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)6.0, (double)10.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)1.0, (double)7.0, (double)7.0, (double)5.0, (double)16.0, (double)8.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)10.0, (double)3.0, (double)7.0, (double)15.0, (double)8.0, (double)8.5));
        return shape;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            class_3218 serverWorld = (class_3218)world;
            if (!world.method_40134().method_40225(class_7134.field_37666)) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
                return;
            }
            if (ChimerasPortalBlock.hasActivePortal(serverWorld) && !pos.equals((Object)activePortalPos)) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
                return;
            }
            activePortalPos = pos;
            activePortalWorld = serverWorld;
            portalPlacementTime = world.method_8510();
            world.method_39279(pos, (class_2248)this, 200);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!world.field_9236 && pos.equals((Object)activePortalPos)) {
            ChimerasPortalBlock.clearActivePortal();
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!pos.equals((Object)activePortalPos)) {
            return;
        }
        long currentTime = world.method_8510();
        long elapsed = currentTime - portalPlacementTime;
        if (elapsed >= 1200L) {
            world.method_8396(null, pos, ModSounds.PORTAL_AMBIENT, class_3419.field_15245, 3.0f, 0.8f);
            world.method_8501(pos, class_2246.field_10124.method_9564());
            ChimerasPortalBlock.clearActivePortal();
            return;
        }
        world.method_8396(null, pos, ModSounds.PORTAL_AMBIENT, class_3419.field_15245, 3.0f, 1.0f);
        world.method_39279(pos, (class_2248)this, 200);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.teleportToChimerasDimension(serverPlayer);
            world.method_8501(pos, class_2246.field_10124.method_9564());
            world.method_8396(null, pos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!world.field_9236 && entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            this.teleportToChimerasDimension(serverPlayer);
        }
    }

    private void teleportToChimerasDimension(class_3222 player) {
        class_3218 chimerasWorld = player.method_5682().method_3847(Chimeras.CHIMERAS_DIMENSION);
        if (chimerasWorld != null) {
            if (player.method_37908().method_27983().equals(class_1937.field_25179)) {
                savedPositions.put(player.method_5667(), player.method_24515());
            }
            ChimerasPortalBlock.checkAndPlaceChimerasCore(chimerasWorld);
            ChimerasPortalBlock.killAllPokemonsOfWorld(chimerasWorld);
            this.grantChimerasAdvancement(player);
            player.method_14251(chimerasWorld, 0.5, 83.0, -19.5, player.method_36454(), player.method_36455());
            player.method_7353((class_2561)class_2561.method_43471((String)"dimension.travel.chimeras"), false);
        }
    }

    public static void checkAndPlaceChimerasCore(class_3218 world) {
        class_2338 centerPos = new class_2338(0, 84, 0);
        boolean coreExists = false;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 checkPos = centerPos.method_10069(x, 0, z);
                if (!world.method_8320(checkPos).method_27852(Chimeras.CHIMERAS_CORE_BLOCK)) continue;
                coreExists = true;
                break;
            }
            if (coreExists) break;
        }
        if (!coreExists) {
            world.method_8501(centerPos, Chimeras.CHIMERAS_CORE_BLOCK.method_9564());
        }
    }

    public static void killAllPokemonsOfWorld(class_3218 chimerasWorld) {
        if (chimerasWorld != null) {
            chimerasWorld.method_18198((class_5575)CobblemonEntities.POKEMON, pokemonEntity -> {
                pokemonEntity.method_31472();
                return false;
            });
        }
    }

    private void grantChimerasAdvancement(class_3222 player) {
        class_167 progress;
        class_2960 advancementId = class_2960.method_60655((String)"cobblemon_ultrabeast", (String)"enter_chimeras_dimension");
        class_8779 advancement = player.method_5682().method_3851().method_12896(advancementId);
        if (advancement != null && !(progress = player.method_14236().method_12882(advancement)).method_740()) {
            for (String criterion : progress.method_731()) {
                player.method_14236().method_12878(advancement, criterion);
            }
        }
    }
}

