/*
 * Decompiled with CFR 0.152.
 */
package dev.darcosse.chimeras.fabric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.darcosse.chimeras.fabric.Chimeras;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5542;
import net.minecraft.class_6748;
import net.minecraft.class_7138;
import net.minecraft.class_7924;

public class ChimerasChunkGenerator
extends class_2794 {
    public static final MapCodec<ChimerasChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098)).apply((Applicative)instance, ChimerasChunkGenerator::new));
    public static final class_5321<class_1959> CHIMERAS_BIOME_KEY = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"cobblemon_ultrabeast", (String)"chimeras_biome"));

    public ChimerasChunkGenerator(class_1966 biomeSource) {
        super(biomeSource);
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 region, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return 384;
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.supplyAsync(() -> this.generateIsland(chunk));
    }

    public int method_16398() {
        return 0;
    }

    public int method_33730() {
        return -64;
    }

    private class_2791 generateIsland(class_2791 chunk) {
        int z;
        int x;
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int islandRadius = 32;
        int centerY = 80;
        int maxThickness = 20;
        int flatTopY = 82;
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (int y = this.method_33730(); y < 90; ++y) {
                    chunk.method_12010(new class_2338(x, y, z), class_2246.field_10124.method_9564(), false);
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                int worldX = chunkX * 16 + x;
                int worldZ = chunkZ * 16 + z;
                double distanceFromCenter = Math.sqrt(worldX * worldX + worldZ * worldZ);
                if (distanceFromCenter <= (double)islandRadius) {
                    class_2338 groundPos;
                    double edgeFactor = 1.0 - distanceFromCenter / (double)islandRadius;
                    int thickness = (int)((double)maxThickness * edgeFactor);
                    int calculatedTopY = centerY + thickness / 2;
                    int topY = Math.min(calculatedTopY, flatTopY);
                    int bottomY = centerY - thickness / 2;
                    int pointDepth = (int)((double)thickness * 0.8 * edgeFactor);
                    for (int y = bottomY -= pointDepth; y <= topY; ++y) {
                        class_2680 blockState = y >= topY ? class_2246.field_23873.method_9564() : (y >= bottomY + thickness / 4 ? class_2246.field_23875.method_9564() : class_2246.field_23869.method_9564());
                        chunk.method_12010(new class_2338(x, y, z), blockState, false);
                    }
                    if (this.shouldGenerateCrystal(worldX, worldZ, distanceFromCenter, islandRadius) && !chunk.method_8320(groundPos = new class_2338(x, flatTopY, z)).method_26215()) {
                        int crystalHeight = 2 + (int)(Math.random() * 3.0);
                        for (int i = 1; i <= crystalHeight; ++i) {
                            class_2338 crystalPos = new class_2338(x, flatTopY + i, z);
                            if (i == crystalHeight) {
                                chunk.method_12010(crystalPos, (class_2680)class_2246.field_27161.method_9564().method_11657((class_2769)class_5542.field_27087, (Comparable)class_2350.field_11036), false);
                                continue;
                            }
                            chunk.method_12010(crystalPos, class_2246.field_27160.method_9564(), false);
                        }
                    }
                    if (worldX == 0 && worldZ == 0) {
                        class_2338 pillar = new class_2338(x, flatTopY + 1, z);
                        chunk.method_12010(pillar, class_2246.field_23261.method_9564(), false);
                        class_2338 chimerasCore = new class_2338(x, flatTopY + 2, z);
                        chunk.method_12010(chimerasCore, Chimeras.CHIMERAS_CORE_BLOCK.method_9564(), false);
                    }
                }
                if (!(distanceFromCenter > (double)(islandRadius + 10)) || !(distanceFromCenter < (double)(islandRadius + 25)) || !(Math.random() < 0.002)) continue;
                int smallIslandSize = 2 + (int)(Math.random() * 3.0);
                int floatingY = centerY + 10 + (int)(Math.random() * 20.0);
                for (int dx = -smallIslandSize; dx <= smallIslandSize; ++dx) {
                    for (int dz = -smallIslandSize; dz <= smallIslandSize; ++dz) {
                        for (int dy = 0; dy <= smallIslandSize; ++dy) {
                            double smallDist;
                            if (x + dx < 0 || x + dx >= 16 || z + dz < 0 || z + dz >= 16 || !((smallDist = Math.sqrt(dx * dx + dz * dz + dy * dy)) <= (double)smallIslandSize)) continue;
                            chunk.method_12010(new class_2338(x + dx, floatingY - dy, z + dz), class_2246.field_10471.method_9564(), false);
                        }
                    }
                }
            }
        }
        return chunk;
    }

    private boolean shouldGenerateCrystal(int worldX, int worldZ, double distanceFromCenter, int islandRadius) {
        double spawnX = 0.0;
        double spawnZ = -22.0;
        double spawnExclusionRadius = 12.0;
        double distanceFromSpawn = Math.sqrt(Math.pow((double)worldX - spawnX, 2.0) + Math.pow((double)worldZ - spawnZ, 2.0));
        if (distanceFromSpawn <= spawnExclusionRadius) {
            return false;
        }
        double distanceFromIslandCenter = Math.sqrt(worldX * worldX + worldZ * worldZ);
        if (distanceFromIslandCenter <= 8.0) {
            return false;
        }
        double innerBoundary = (double)islandRadius * 0.65;
        double outerBoundary = (double)islandRadius * 0.9;
        if (distanceFromCenter < innerBoundary || distanceFromCenter > outerBoundary) {
            return false;
        }
        return Math.random() < 0.06;
    }

    private void addSideBudsCorrect(class_2791 chunk, int x, int baseY, int z, int crystalHeight) {
        class_2350[] horizontalDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
        int budCount = 1 + (int)(Math.random() * 2.0);
        for (int i = 0; i < budCount; ++i) {
            class_2350 direction = horizontalDirections[(int)(Math.random() * (double)horizontalDirections.length)];
            int budHeight = Math.max(2, Math.min(crystalHeight, 2 + (int)(Math.random() * (double)(crystalHeight - 1))));
            class_2338 budBasePos = new class_2338(x, baseY + budHeight, z);
            class_2338 budPos = budBasePos.method_10093(direction);
            if (budPos.method_10263() < 0 || budPos.method_10263() >= 16 || budPos.method_10260() < 0 || budPos.method_10260() >= 16 || !chunk.method_8320(budPos).method_26215() || chunk.method_8320(budBasePos).method_26215()) continue;
            double rand = Math.random();
            class_2248 budBlock = rand < 0.3 ? class_2246.field_27162 : (rand < 0.7 ? class_2246.field_27163 : class_2246.field_27164);
            class_2350 budFacing = direction.method_10153();
            chunk.method_12010(budPos, (class_2680)budBlock.method_9564().method_11657((class_2769)class_5542.field_27087, (Comparable)budFacing), false);
        }
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        double distanceFromCenter = Math.sqrt(x * x + z * z);
        if (distanceFromCenter <= 32.0) {
            double edgeFactor = 1.0 - distanceFromCenter / 32.0;
            edgeFactor = Math.pow(edgeFactor, 0.5);
            int thickness = (int)(4.0 * edgeFactor);
            return 82 + thickness / 2;
        }
        return this.method_33730();
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        int height = this.method_16397(x, z, class_2902.class_2903.field_13194, world, noiseConfig);
        int sampleHeight = Math.max(0, height - this.method_33730() + 1);
        class_2680[] states = new class_2680[sampleHeight];
        for (int i = 0; i < sampleHeight; ++i) {
            states[i] = class_2246.field_10471.method_9564();
        }
        return new class_4966(this.method_33730(), states);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
        text.add("ChimerasDimension Generator");
        text.add("Island Radius: 64 blocks");
    }
}

