/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.blay09.mods.balm.api.config.LenientEnumCodecs;
import net.blay09.mods.balm.api.config.schema.builder.BooleanConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.DoubleConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.FloatConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.IntConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.LongConfigProperty;
import net.minecraft.class_2960;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class PrimitiveConfigCodecs {
    public static <T> Codec<T> codec(Class<T> type) {
        if (type == String.class) {
            return Codec.STRING;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return IntConfigProperty.CODEC;
        }
        if (type == Long.class || type == Long.TYPE) {
            return LongConfigProperty.CODEC;
        }
        if (type == Float.class || type == Float.TYPE) {
            return FloatConfigProperty.CODEC;
        }
        if (type == Double.class || type == Double.TYPE) {
            return DoubleConfigProperty.CODEC;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BooleanConfigProperty.CODEC;
        }
        if (type == class_2960.class) {
            return class_2960.field_25139;
        }
        if (type.isEnum()) {
            return PrimitiveConfigCodecs.enumCodec(type);
        }
        throw new IllegalArgumentException("Unsupported nested type: " + type.getName());
    }

    private static <T extends Enum<T>> Codec<T> enumCodec(Class<T> type) {
        return LenientEnumCodecs.fromValues(type::getEnumConstants);
    }

    public static <T> class_9139<ByteBuf, T> streamCodec(Class<T> type) {
        if (type == String.class) {
            return class_9135.field_48554;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return class_9135.field_49675;
        }
        if (type == Long.class || type == Long.TYPE) {
            return class_9135.field_48551;
        }
        if (type == Float.class || type == Float.TYPE) {
            return class_9135.field_48552;
        }
        if (type == Double.class || type == Double.TYPE) {
            return class_9135.field_48553;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return class_9135.field_48547;
        }
        if (type == class_2960.class) {
            return class_2960.field_48267;
        }
        if (type.isEnum()) {
            return PrimitiveConfigCodecs.enumStreamCodec(type);
        }
        throw new IllegalArgumentException("Unsupported nested type: " + type.getName());
    }

    private static <T extends Enum<T>> class_9139<ByteBuf, T> enumStreamCodec(Class<T> type) {
        IntFunction byIdMapper = class_7995.method_47914(Enum::ordinal, (Object[])((Enum[])type.getEnumConstants()), (class_7995.class_7996)class_7995.class_7996.field_41664);
        return class_9135.method_56375((IntFunction)byIdMapper, Enum::ordinal);
    }
}

