/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.mixin;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_9267;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xerca.xercapaint.Mod;
import xerca.xercapaint.PaletteUtil;

@Mixin(value={class_9267.class})
public class ItemStackComponentizationFixMixin {
    @Inject(at={@At(value="TAIL")}, method={"fixItemStack(Lnet/minecraft/util/datafix/fixes/ItemStackComponentizationFix$ItemStackData;Lcom/mojang/serialization/Dynamic;)V"})
    private static void fixItemStackMixin(class_9267.class_9268 itemStackData, Dynamic<?> tag, CallbackInfo info) {
        if (itemStackData.method_57270("xercapaint:item_canvas") || itemStackData.method_57270("xercapaint:item_canvas_large") || itemStackData.method_57270("xercapaint:item_canvas_long") || itemStackData.method_57270("xercapaint:item_canvas_tall")) {
            Mod.LOGGER.debug("Found a canvas, porting it to the component format");
            itemStackData.method_57266("name", "xercapaint:canvas_id");
            itemStackData.method_57266("v", "xercapaint:canvas_version");
            itemStackData.method_57266("pixels", "xercapaint:canvas_pixels");
            itemStackData.method_57266("generation", "xercapaint:canvas_generation");
            itemStackData.method_57266("title", "xercapaint:canvas_title");
            itemStackData.method_57266("author", "xercapaint:canvas_author");
        }
        if (itemStackData.method_57270("xercapaint:item_palette")) {
            Mod.LOGGER.debug("Found a palette, porting it to the component format");
            itemStackData.method_57266("basic", "xercapaint:palette_basic_colors");
            OptionalDynamic rDynamic = itemStackData.method_57262("r");
            OptionalDynamic gDynamic = itemStackData.method_57262("g");
            OptionalDynamic bDynamic = itemStackData.method_57262("b");
            OptionalDynamic mDynamic = itemStackData.method_57262("m");
            OptionalDynamic nDynamic = itemStackData.method_57262("n");
            Optional<int[]> rArrayOpt = rDynamic.asIntStreamOpt().result().map(IntStream::toArray);
            Optional<int[]> gArrayOpt = gDynamic.asIntStreamOpt().result().map(IntStream::toArray);
            Optional<int[]> bArrayOpt = bDynamic.asIntStreamOpt().result().map(IntStream::toArray);
            Optional<int[]> mArrayOpt = mDynamic.asIntStreamOpt().result().map(IntStream::toArray);
            Optional<int[]> nArrayOpt = nDynamic.asIntStreamOpt().result().map(IntStream::toArray);
            if (rArrayOpt.isPresent() && gArrayOpt.isPresent() && bArrayOpt.isPresent() && mArrayOpt.isPresent() && nArrayOpt.isPresent()) {
                int[] rArray = rArrayOpt.get();
                int[] gArray = gArrayOpt.get();
                int[] bArray = bArrayOpt.get();
                int[] mArray = mArrayOpt.get();
                int[] nArray = nArrayOpt.get();
                PaletteUtil.CustomColor[] customColors = new PaletteUtil.CustomColor[12];
                for (int i = 0; i < 12; ++i) {
                    int totalRed = rArray[i];
                    int totalGreen = gArray[i];
                    int totalBlue = bArray[i];
                    int totalMaximum = mArray[i];
                    int numberOfColors = nArray[i];
                    customColors[i] = new PaletteUtil.CustomColor(totalRed, totalGreen, totalBlue, totalMaximum, numberOfColors);
                }
                IntStream intStream = Arrays.stream(customColors).flatMapToInt(cc -> Arrays.stream(new int[]{cc.totalRed, cc.totalGreen, cc.totalBlue, cc.totalMaximum, cc.numberOfColors}));
                itemStackData.method_57263("xercapaint:palette_custom_colors", tag.createIntList(intStream));
            }
        }
    }
}

