/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.item.crafting;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.item.Items;

@ParametersAreNonnullByDefault
@class_6328
public class RecipeCraftPalette
extends class_1852 {
    private static final class_2960 plank = class_2960.method_60655((String)"minecraft", (String)"planks");

    public RecipeCraftPalette(class_7710 craftingBookCategory) {
        super(craftingBookCategory);
    }

    private boolean isPlank(class_1799 stack) {
        return stack.method_40133().anyMatch(p -> p.comp_327().equals((Object)plank));
    }

    private boolean isDye(class_1799 stack) {
        return stack.method_7909() instanceof class_1769;
    }

    private boolean isPlankRow(class_9694 inv, int row) {
        int plankCount = 0;
        for (int j = 0; j < inv.method_59991(); ++j) {
            int id = row * inv.method_59991() + j;
            class_1799 stack = inv.method_59984(id);
            if (!this.isPlank(stack)) continue;
            ++plankCount;
        }
        return plankCount == 3;
    }

    private int findPlankRow(class_9694 inv) {
        for (int i = 0; i < inv.method_59992(); ++i) {
            if (!this.isPlankRow(inv, i)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<class_1799> findDyes(class_9694 inv, int plankRow) {
        ArrayList<class_1799> dyes = new ArrayList<class_1799>();
        for (int i = 0; i < inv.method_59992(); ++i) {
            if (i == plankRow) continue;
            for (int j = 0; j < inv.method_59991(); ++j) {
                int id = i * inv.method_59991() + j;
                class_1799 stack = inv.method_59984(id);
                if (this.isDye(stack)) {
                    dyes.add(stack);
                    continue;
                }
                if (stack.method_7960()) continue;
                return null;
            }
        }
        return dyes;
    }

    public boolean matches(class_9694 inv, class_1937 worldIn) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return false;
        }
        ArrayList<class_1799> dyes = this.findDyes(inv, plankRow);
        return dyes != null && !dyes.isEmpty();
    }

    public class_1799 assemble(class_9694 inv, @NotNull class_7225.class_7874 provider) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return class_1799.field_8037;
        }
        ArrayList<class_1799> dyes = this.findDyes(inv, plankRow);
        if (dyes == null || dyes.isEmpty()) {
            return class_1799.field_8037;
        }
        byte[] basicColors = new byte[16];
        for (class_1799 dye : dyes) {
            class_1767 color = ((class_1769)dye.method_7909()).method_7802();
            basicColors[15 - color.method_7789()] = 1;
        }
        class_1799 result = new class_1799((class_1935)Items.ITEM_PALETTE);
        result.method_57379(Items.PALETTE_BASIC_COLORS, (Object)basicColors);
        return result;
    }

    public class_2371<class_1799> getRemainingItems(class_9694 inv) {
        return class_2371.method_10213((int)inv.method_59983(), (Object)class_1799.field_8037);
    }

    public class_1865<?> method_8119() {
        return Items.CRAFTING_SPECIAL_PALETTE_CRAFTING;
    }

    public boolean method_8113(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

