/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.DataComponentManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.IdSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.StringSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagIdSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.mixin.fields.DecoratedPotPatternsFields;
import com.mt1006.nbt_ac.mixin.fields.FontManagerFields;
import com.mt1006.nbt_ac.mixin.fields.KeyMappingFields;
import com.mt1006.nbt_ac.mixin.fields.MinecraftFields;
import com.mt1006.nbt_ac.mixin.fields.TextColorFields;
import com.mt1006.nbt_ac.utils.Fields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1132;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1893;
import net.minecraft.class_21;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_378;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7446;
import net.minecraft.class_7924;
import net.minecraft.class_8055;
import net.minecraft.class_8057;
import net.minecraft.class_9796;
import org.jetbrains.annotations.Nullable;

public enum NbtSuggestionSubtype {
    NONE,
    ENUM,
    DESCRIBED_ENUM,
    BLOCK_STATE_ENUM,
    ORDERED_ENUM,
    REQUIRED_ID,
    TAG,
    TAG_WITH_ID,
    BLOCK_STATE_TAG,
    SPAWN_EGG,
    REGISTRY_ID,
    REGISTRY_KEY,
    ITEM_COMPONENTS,
    RECIPE,
    LOOT_TABLE,
    BANNER_PATTERN,
    MAP_DECORATION_TYPE,
    FONT,
    RANDOM_UUID,
    LONG_SEED,
    INVENTORY_SLOT,
    TRANSLATION_KEY,
    KEYBIND,
    JSON_TEXT,
    JSON_TEXT_COMPOUND,
    JSON_TEXT_COLOR,
    JSON_STYLE_COMPOUND,
    ENTITY_SELECTOR,
    HOVER_EVENT_CONTENTS,
    DYE_COLOR,
    EMPTY_COMPOUND,
    ENCHANTMENTS,
    MAP_DECORATIONS,
    POT_DECORATION,
    TRIM_PATTERN,
    TRIM_MATERIAL,
    JUKEBOX_SONG;

    private static final List<String> JSON_TEXT_TYPE_SPECIFIC;
    private static final List<String> JSON_TEXT_TYPE_HAS_SEPARATOR;
    private static final Random rng;

    public String getName() {
        return this.name().toLowerCase();
    }

    public static NbtSuggestionSubtype fromName(String name) {
        try {
            return NbtSuggestionSubtype.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return NONE;
        }
    }

    public <T> boolean getSubtypeSuggestions(NbtSuggestion suggestion, SuggestionList suggestionList, @Nullable String data, CustomTagParser.Type parserType) {
        switch (this.ordinal()) {
            case 1: {
                if (data == null) break;
                suggestionList.clear();
                for (String substring : data.split(";")) {
                    suggestionList.add(CustomSuggestion.fromType(substring, null, suggestion.type, parserType, 0));
                }
                return true;
            }
            case 2: {
                if (data == null) break;
                suggestionList.clear();
                String suggestionText = null;
                for (String substring : data.split(";")) {
                    if (suggestionText == null) {
                        suggestionText = substring;
                        continue;
                    }
                    suggestionList.add(CustomSuggestion.fromType(suggestionText, String.format("<%s>", substring), suggestion.type, parserType, 0));
                    suggestionText = null;
                }
                return true;
            }
            case 3: {
                if (data == null) break;
                suggestionList.clear();
                char quote = ModConfig.getDefaultQuotationMark(false);
                for (String substring : data.split(";")) {
                    suggestionList.addRaw(String.format("%c%s%c", Character.valueOf(quote), substring, Character.valueOf(quote)), null);
                }
                return true;
            }
            case 4: {
                if (data == null) break;
                suggestionList.clear();
                int priority = 99;
                for (String substring : data.split(";")) {
                    suggestionList.add(CustomSuggestion.fromType(substring, null, suggestion.type, parserType, priority--));
                }
                return true;
            }
            case 5: {
                if (data == null) break;
                suggestionList.clear();
                suggestionList.add(new IdSuggestion(class_2960.method_60654((String)data), "#[required_id]", parserType));
                return true;
            }
            case 10: 
            case 11: {
                if (data == null) break;
                try {
                    class_2960 registryLocation = class_2960.method_60654((String)data);
                    class_2378 registry = (class_2378)RegistryUtils.REGISTRY.method_10223(registryLocation);
                    if (registry == null) break;
                    suggestionList.clear();
                    if (this == REGISTRY_ID) {
                        for (Object object : registry) {
                            suggestionList.addRaw(Integer.toString(registry.method_10206(object)), "\"" + String.valueOf(registry.method_10221(object)) + "\" [#" + registryLocation.method_12832() + "]");
                        }
                    } else {
                        for (Object object : registry) {
                            suggestionList.add(new IdSuggestion(registry.method_10221(object), "[#" + registryLocation.method_12832() + "]", parserType));
                        }
                    }
                }
                catch (Exception registryLocation) {
                    // empty catch block
                }
                return true;
            }
            case 13: {
                class_638 recipeLevel = class_310.method_1551().field_1687;
                if (recipeLevel == null) break;
                suggestionList.clear();
                for (class_2960 id : (class_2960[])recipeLevel.method_8433().method_8127().toArray(class_2960[]::new)) {
                    suggestionList.add(new IdSuggestion(id, null, parserType));
                }
                return true;
            }
            case 14: {
                class_1132 singlePlayerServer = class_310.method_1551().method_1576();
                if (singlePlayerServer == null) break;
                suggestionList.clear();
                for (class_2960 id : singlePlayerServer.method_58576().method_58290(class_7924.field_50079)) {
                    suggestionList.add(new IdSuggestion(id, null, parserType));
                }
                return true;
            }
            case 15: {
                suggestionList.clear();
                List<class_5321> bannerPatterns = Fields.getStaticFields(class_7446.class, class_5321.class);
                bannerPatterns.forEach(key -> suggestionList.add(new IdSuggestion(key.method_29177(), "[#banner_pattern]", parserType)));
                return true;
            }
            case 16: {
                suggestionList.clear();
                List<class_6880> decorationTypes = Fields.getStaticFields(class_21.class, class_6880.class);
                for (class_6880 holder : decorationTypes) {
                    class_5321 key2 = holder.method_40230().orElse(null);
                    StringSuggestion customSuggestion = key2 != null ? new IdSuggestion(key2.method_29177(), "[#banner_pattern]", parserType) : new StringSuggestion("_error", null, parserType, 9999);
                    suggestionList.add(customSuggestion);
                }
                return true;
            }
            case 17: {
                suggestionList.clear();
                class_378 fontManager = ((MinecraftFields)class_310.method_1551()).getField_1708();
                for (class_2960 id : ((FontManagerFields)fontManager).getField_2259().keySet()) {
                    suggestionList.add(new IdSuggestion(id, "[#font]", parserType));
                }
                return true;
            }
            case 23: {
                suggestionList.clear();
                NbtSuggestionSubtype.getJsonTextPrefixSuggestions(suggestionList, true);
                return true;
            }
            case 25: {
                suggestionList.clear();
                suggestionList.addRaw("\"#", "[#json_color]", 1);
                Map<String, class_5251> colorMap = TextColorFields.getField_24363();
                if (colorMap == null) {
                    return true;
                }
                for (Map.Entry<String, class_5251> entry : colorMap.entrySet()) {
                    String subtext = String.format("(#%06X) [#json_color]", entry.getValue().method_27716());
                    suggestionList.add(new StringSuggestion(entry.getKey(), subtext, parserType));
                }
                return true;
            }
            case 18: {
                suggestionList.clear();
                UUID randomUUID = UUID.randomUUID();
                int uuidInt0 = (int)randomUUID.getLeastSignificantBits();
                int uuidInt1 = (int)(randomUUID.getLeastSignificantBits() >>> 32);
                int uuidInt2 = (int)randomUUID.getMostSignificantBits();
                int uuidInt3 = (int)(randomUUID.getMostSignificantBits() >>> 32);
                String uuidString = String.format("[I;%d, %d, %d, %d]", uuidInt3, uuidInt2, uuidInt1, uuidInt0);
                suggestionList.addRaw(uuidString, "[#random_uuid]");
                return true;
            }
            case 19: {
                suggestionList.clear();
                long random = rng.nextLong();
                if (random == 0L) {
                    random = 123L;
                }
                suggestionList.addRaw("0", "(random) [#seed]", 1);
                suggestionList.addRaw(random + "l", "(constant) [#seed]");
                return true;
            }
            case 20: {
                int i;
                suggestionList.clear();
                NbtSuggestion.Type type = suggestion.type;
                for (i = 0; i < 9; ++i) {
                    String subtext = String.format("(Hotbar %d) [#inventory_slot]", i + 1);
                    suggestionList.addRaw(String.format("%d%s", i, type.suffix), subtext);
                }
                for (i = 9; i < 35; ++i) {
                    int row = (i - 9) / 9 + 1;
                    int column = (i - 9) % 9 + 1;
                    String subtext = String.format("(Storage %d:%d) [#inventory_slot]", row, column);
                    suggestionList.addRaw(String.format("%d%s", i, type.suffix), subtext);
                }
                suggestionList.addRaw("100" + type.suffix, "(Feet) [#inventory_slot]");
                suggestionList.addRaw("101" + type.suffix, "(Legs) [#inventory_slot]");
                suggestionList.addRaw("102" + type.suffix, "(Chest) [#inventory_slot]");
                suggestionList.addRaw("103" + type.suffix, "(Head) [#inventory_slot]");
                suggestionList.addRaw("-106" + type.suffix, "(Off-hand) [#inventory_slot]");
                return true;
            }
            case 21: {
                return false;
            }
            case 22: {
                suggestionList.clear();
                Map<String, class_304> keyMap = KeyMappingFields.getField_1657();
                if (keyMap == null) break;
                for (String str : keyMap.keySet()) {
                    String subtext = "\"" + class_2561.method_43471((String)str).getString() + "\" [#keybind]";
                    suggestionList.add(new StringSuggestion(str, subtext, parserType));
                }
                return true;
            }
            case 27: {
                suggestionList.clear();
                suggestionList.add(new StringSuggestion("@p", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@a", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@r", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@s", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@e", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@n", "[#entity_selector]", parserType));
                return true;
            }
            case 29: {
                suggestionList.clear();
                for (class_1767 color : class_1767.values()) {
                    suggestionList.add(new StringSuggestion(color.method_7792(), "[#dye_color]", parserType));
                }
                return true;
            }
            case 30: {
                suggestionList.clear();
                suggestionList.addRaw("{}", "[#empty_compound]");
                return true;
            }
            case 33: {
                suggestionList.clear();
                suggestionList.add(new IdSuggestion(RegistryUtils.ITEM.getKey(class_1802.field_8621), "[#pot_decoration]", parserType, 1));
                Map<class_1792, class_5321<String>> itemToPotTexture = DecoratedPotPatternsFields.getField_42798();
                if (itemToPotTexture == null) {
                    return true;
                }
                for (class_1792 item : itemToPotTexture.keySet()) {
                    suggestionList.add(new IdSuggestion(RegistryUtils.ITEM.getKey(item), "[#pot_decoration]", parserType));
                }
                return true;
            }
            case 34: {
                suggestionList.clear();
                List<class_5321> trimPatterns = Fields.getStaticFields(class_8057.class, class_5321.class);
                trimPatterns.forEach(key -> suggestionList.add(new IdSuggestion(key.method_29177(), "[#trim_pattern]", parserType)));
                return true;
            }
            case 35: {
                suggestionList.clear();
                List<class_5321> trimMaterial = Fields.getStaticFields(class_8055.class, class_5321.class);
                trimMaterial.forEach(key -> suggestionList.add(new IdSuggestion(key.method_29177(), "[#trim_material]", parserType)));
                return true;
            }
            case 36: {
                suggestionList.clear();
                List<class_5321> jukeboxSong = Fields.getStaticFields(class_9796.class, class_5321.class);
                jukeboxSong.forEach(key -> suggestionList.add(new IdSuggestion(key.method_29177(), "[#jukebox_song]", parserType)));
                return true;
            }
        }
        return false;
    }

    public <T extends Comparable<T>> void getSubtypeTagSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, @Nullable String data, CustomTagParser.Type parserType) {
        switch (this.ordinal()) {
            case 6: 
            case 7: {
                int dataSlashPos;
                if (data == null) break;
                data = data.replace("block/item/", "block/");
                data = data.replace("entity/item/", "entity/");
                NbtSuggestions tagSuggestions = NbtSuggestionManager.get(data);
                suggestionList.addAll(tagSuggestions, data, parserType);
                if (this != TAG_WITH_ID || (dataSlashPos = data.indexOf(47)) == -1) break;
                NbtSuggestion tempSuggestion = new NbtSuggestion("id", NbtSuggestion.Type.STRING);
                tempSuggestion.subtype = REQUIRED_ID;
                tempSuggestion.subtypeData = data.substring(dataSlashPos + 1);
                suggestionList.add(new TagSuggestion(tempSuggestion, parserType, 100));
                break;
            }
            case 8: {
                try {
                    if (data == null) break;
                    if (data.startsWith("block/")) {
                        data = data.substring(6);
                    } else if (data.startsWith("item/")) {
                        data = data.substring(5);
                    }
                    class_1792 blockItem = RegistryUtils.ITEM.get(class_2960.method_60654((String)data));
                    if (!(blockItem instanceof class_1747)) break;
                    for (class_2769 property : ((class_1747)blockItem).method_7711().method_9564().method_28501()) {
                        NbtSuggestion nbtSuggestion = new NbtSuggestion(property.method_11899(), NbtSuggestion.Type.STRING);
                        nbtSuggestion.subtype = BLOCK_STATE_ENUM;
                        StringBuilder enumStringBuilder = new StringBuilder();
                        for (Comparable possibleValue : property.method_11898()) {
                            enumStringBuilder.append(property.method_11901(possibleValue)).append(";");
                        }
                        nbtSuggestion.subtypeData = enumStringBuilder.toString();
                        suggestionList.add(new TagSuggestion(nbtSuggestion, parserType));
                    }
                    break;
                }
                catch (Exception blockItem) {
                    break;
                }
            }
            case 9: {
                try {
                    class_1792 item;
                    if (data == null) break;
                    if (data.startsWith("item/")) {
                        data = data.substring(5);
                    }
                    if (!((item = RegistryUtils.ITEM.get(class_2960.method_60654((String)data))) instanceof class_1826)) break;
                    String key = RegistryUtils.ENTITY_TYPE.getKey(((class_1826)item).method_8015(null)).toString();
                    NbtSuggestions spawnEggSuggestions = NbtSuggestionManager.get("entity/" + key);
                    suggestionList.addAll(spawnEggSuggestions, data, parserType);
                }
                catch (Exception item) {}
                break;
            }
            case 12: {
                if (data == null) break;
                DataComponentManager.loadSuggestions(suggestionList, "", Set.of(), RegistryUtils.ITEM.get(data), parserType, false);
                break;
            }
            case 24: {
                NbtSuggestionSubtype.getJsonCompoundSuggestions(suggestionList, parentInfo, parserType);
                break;
            }
            case 26: {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/style"), parserType);
                break;
            }
            case 28: {
                NbtSuggestionSubtype.getHoverEventContentsSuggestions(suggestionList, parentInfo, data, parserType);
                break;
            }
            case 31: {
                suggestionList.clear();
                List<class_5321> enchantments = Fields.getStaticFields(class_1893.class, class_5321.class);
                for (class_5321 resourceKey : enchantments) {
                    class_2960 id = resourceKey.method_29177();
                    NbtSuggestion tempSuggestion = new NbtSuggestion(id.toString(), NbtSuggestion.Type.INT);
                    suggestionList.add(new TagIdSuggestion(tempSuggestion, id, parserType, true));
                }
                break;
            }
            case 32: {
                String decorationId = Long.toString(Math.abs(rng.nextInt()), Math.min(36, 36));
                NbtSuggestion tempSuggestion = new NbtSuggestion(decorationId, NbtSuggestion.Type.COMPOUND);
                tempSuggestion.subtype = TAG;
                tempSuggestion.subtypeData = "compound/nbt_ac:map_decoration";
                suggestionList.add(new TagSuggestion(tempSuggestion, parserType));
                if (parentInfo.tagMap == null) break;
                for (String tag : parentInfo.tagMap.keySet()) {
                    NbtSuggestion tempOldSuggestion = new NbtSuggestion(tag, NbtSuggestion.Type.COMPOUND);
                    tempOldSuggestion.subtype = TAG;
                    tempOldSuggestion.subtypeData = "compound/nbt_ac:map_decoration";
                    suggestionList.add(new TagSuggestion(tempOldSuggestion, parserType));
                }
                break;
            }
        }
    }

    public static void getJsonTextPrefixSuggestions(SuggestionList suggestionList, boolean inner) {
        String jsonSuggestion;
        String string = jsonSuggestion = inner ? ModConfig.getJsonStringSuggestion() : "\"";
        if (jsonSuggestion != null) {
            suggestionList.addRaw(jsonSuggestion, "(simple string) [#json_text]", 3);
        }
        suggestionList.addRaw(inner ? "'{" : "{", "(json structure) [#json_text]", 2);
        suggestionList.addRaw(inner ? "'[" : "[", "(json list) [#json_text]", 1);
    }

    private static void getJsonCompoundSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, CustomTagParser.Type parserType) {
        suggestionList.addAll(NbtSuggestionManager.get("json_text/common"), parserType);
        suggestionList.addAll(NbtSuggestionManager.get("json_text/style"), parserType);
        String contentType = NbtSuggestionSubtype.jsonTextInit(suggestionList, parentInfo, parserType);
        for (String str : JSON_TEXT_TYPE_SPECIFIC) {
            int priority = contentType != null && !str.equals(contentType) ? -1 : 0;
            suggestionList.addAll(NbtSuggestionManager.get("json_text/type_specific/" + str), parserType, priority);
        }
        int priority = contentType != null && !JSON_TEXT_TYPE_HAS_SEPARATOR.contains(contentType) ? -1 : 0;
        suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/separator"), parserType, priority);
    }

    @Nullable
    private static String jsonTextInit(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, CustomTagParser.Type parserType) {
        Map<Object, Object> tagMap;
        NbtSuggestions initialContent = NbtSuggestionManager.get("json_text/initial_content");
        if (initialContent == null) {
            return null;
        }
        Map<Object, Object> map = tagMap = parentInfo.tagMap != null ? parentInfo.tagMap : Map.of();
        if (tagMap.containsKey("type")) {
            String valueType = (String)tagMap.get("type");
            NbtSuggestion typeSuggestion = initialContent.get("type");
            NbtSuggestion valueSuggestion = initialContent.get(valueType);
            if (typeSuggestion != null) {
                suggestionList.add(new TagSuggestion(typeSuggestion, parserType, 100));
            }
            if (valueSuggestion != null) {
                suggestionList.add(new TagSuggestion(valueSuggestion, parserType, 100));
            }
            for (NbtSuggestion suggestion : initialContent.getAll()) {
                if (suggestion == typeSuggestion || suggestion == valueSuggestion) continue;
                suggestionList.add(new TagSuggestion(suggestion, parserType, -1));
            }
            return valueType;
        }
        for (NbtSuggestion suggestion : initialContent.getAll()) {
            if (!tagMap.containsKey(suggestion.tag)) continue;
            suggestionList.addAll(initialContent, parserType, -1);
            return NbtSuggestionSubtype.jsonTextTypeFromTag(suggestion.tag);
        }
        suggestionList.addAll(initialContent, parserType, 100);
        return null;
    }

    private static String jsonTextTypeFromTag(String tag) {
        return tag.equals("translate") ? "translatable" : tag;
    }

    private static void getHoverEventContentsSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, @Nullable String data, CustomTagParser.Type parserType) {
        String hoverEvent;
        if (parentInfo.parentTagMap == null || !parentInfo.parentTagMap.containsKey("action")) {
            return;
        }
        switch (hoverEvent = parentInfo.parentTagMap.get("action")) {
            case "show_text": {
                JSON_TEXT_COMPOUND.getSubtypeTagSuggestions(suggestionList, parentInfo, data, parserType);
                break;
            }
            case "show_item": {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/hover_event_show_item"), parserType);
                break;
            }
            case "show_entity": {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/hover_event_show_entity"), parserType);
            }
        }
    }

    static {
        JSON_TEXT_TYPE_SPECIFIC = List.of("nbt", "translatable");
        JSON_TEXT_TYPE_HAS_SEPARATOR = List.of("nbt", "selector");
        rng = new Random();
    }
}

