/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.typeloader;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.Disassembly;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import com.mt1006.nbt_ac.utils.Utils;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2669;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class TypeLoader {
    @Nullable
    public static volatile Thread objectCatcher = null;
    public static Object lastObject = null;

    public static void loadEntityTypes() {
        objectCatcher = Thread.currentThread();
        for (class_1299<?> entityType : RegistryUtils.ENTITY_TYPE) {
            Class clazz;
            lastObject = null;
            class_2960 resourceName = class_1299.method_5890(entityType);
            if (resourceName.toString().equals("minecraft:player")) {
                clazz = class_3222.class;
            } else {
                block8: {
                    try {
                        entityType.method_5883(null);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof Error)) break block8;
                        NBTac.LOGGER.error("Entity \"{}\" constructor thrown error: {}", (Object)resourceName, (Object)throwable);
                    }
                }
                Class<Object> clazz2 = clazz = lastObject != null ? lastObject.getClass() : null;
            }
            if (clazz != null) {
                try {
                    NbtSuggestions suggestions = new NbtSuggestions(true);
                    Disassembly.disassemblyEntity(clazz, suggestions);
                    NbtSuggestionManager.add("entity/" + String.valueOf(resourceName), suggestions);
                }
                catch (Exception exception) {
                    NBTac.LOGGER.error("Failed to load entity \"{}\": {}", (Object)resourceName, (Object)exception);
                    Loader.printStackTrace(exception);
                }
                continue;
            }
            NBTac.LOGGER.error("Unable to get entity class for \"{}\"", (Object)resourceName);
        }
        objectCatcher = null;
    }

    public static void loadBlockEntityTypes() {
        objectCatcher = Thread.currentThread();
        boolean pistonCrashFix = NBTac.loaderInterface.isFabric() && Utils.isModPresent("moreculling") && Utils.isModPresent("modernfix") && Utils.isModPresent("lithium");
        for (class_2591<?> blockEntityType : RegistryUtils.BLOCK_ENTITY_TYPE) {
            Class clazz;
            lastObject = null;
            class_2960 resourceName = class_2591.method_11033(blockEntityType);
            if (pistonCrashFix && blockEntityType == class_2591.field_11897) {
                clazz = class_2669.class;
            } else {
                block8: {
                    try {
                        blockEntityType.method_11032(class_2338.field_10980, null);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof Error)) break block8;
                        NBTac.LOGGER.error("Block entity \"{}\" constructor thrown error: {}", (Object)resourceName, (Object)throwable);
                    }
                }
                Class<Object> clazz2 = clazz = lastObject != null ? lastObject.getClass() : null;
            }
            if (clazz != null) {
                try {
                    NbtSuggestions suggestions = new NbtSuggestions(true);
                    Disassembly.disassemblyBlockEntity(clazz, suggestions);
                    NbtSuggestionManager.add("block/" + String.valueOf(resourceName), suggestions);
                }
                catch (Exception exception) {
                    NBTac.LOGGER.error("Failed to load block entity \"{}\": {}", (Object)resourceName, (Object)exception);
                    Loader.printStackTrace(exception);
                }
                continue;
            }
            NBTac.LOGGER.error("Unable to get block entity class for \"{}\"", (Object)resourceName);
        }
        objectCatcher = null;
    }

    @Nullable
    public static class_2586 blockEntityFromBlock(class_2248 block) {
        block6: {
            if (!((Boolean)ModConfig.allowBlockEntityExtraction.val).booleanValue()) {
                return null;
            }
            class_2960 resLoc = RegistryUtils.BLOCK.getKey(block);
            if (resLoc == null) {
                return null;
            }
            class_2591<?> blockEntityType = RegistryUtils.BLOCK_ENTITY_TYPE.get(resLoc);
            if (blockEntityType == null) {
                return null;
            }
            if (objectCatcher == Loader.getLoaderThread()) {
                return null;
            }
            objectCatcher = Thread.currentThread();
            lastObject = null;
            try {
                blockEntityType.method_11032(class_2338.field_10980, null);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof Error)) break block6;
                NBTac.LOGGER.error("Block entity \"{}\" constructor thrown error: {}", (Object)resLoc, (Object)throwable);
            }
        }
        objectCatcher = null;
        return lastObject instanceof class_2586 ? (class_2586)lastObject : null;
    }
}

