/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block.v2;

import java.util.function.ToIntFunction;
import net.minecraft.class_4970;
import net.pitan76.mcpitanlib.api.block.CompatibleMaterial;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.sound.CompatBlockSoundGroup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.color.CompatDyeColor;
import net.pitan76.mcpitanlib.api.util.color.CompatMapColor;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;

public class BlockSettingsBuilder {
    public CompatIdentifier id;
    public float hardness = -1.0f;
    public float resistance = -1.0f;
    public CompatBlockSoundGroup blockSoundGroup;
    public CompatibleMaterial material;
    public CompatMapColor mapColor;
    public CompatDyeColor dyeColor;
    public boolean requiresTool;
    public boolean dropsNothing;
    public ToIntFunction<BlockState> luminance;
    protected BlockWrapper copyFromBlock = null;

    public BlockSettingsBuilder(CompatIdentifier id) {
        this.id = id;
    }

    public BlockSettingsBuilder() {
    }

    public BlockSettingsBuilder hardness(float hardness) {
        this.hardness = hardness;
        return this;
    }

    public BlockSettingsBuilder resistance(float resistance) {
        this.resistance = resistance;
        return this;
    }

    public BlockSettingsBuilder strength(float hardness, float resistance) {
        this.hardness = hardness;
        this.resistance = resistance;
        return this;
    }

    public BlockSettingsBuilder sounds(CompatBlockSoundGroup blockSoundGroup) {
        this.blockSoundGroup = blockSoundGroup;
        return this;
    }

    public BlockSettingsBuilder material(CompatibleMaterial material) {
        this.material = material;
        return this;
    }

    public BlockSettingsBuilder mapColor(CompatMapColor mapColor) {
        this.mapColor = mapColor;
        return this;
    }

    public BlockSettingsBuilder dyeColor(CompatDyeColor dyeColor) {
        this.dyeColor = dyeColor;
        return this;
    }

    public BlockSettingsBuilder requiresTool() {
        this.requiresTool = true;
        return this;
    }

    public BlockSettingsBuilder dropsNothing() {
        this.dropsNothing = true;
        return this;
    }

    public BlockSettingsBuilder luminance(ToIntFunction<BlockState> luminance) {
        this.luminance = luminance;
        return this;
    }

    public CompatibleBlockSettings build() {
        return this.build(this.id);
    }

    public class_4970.class_2251 _build() {
        return this.build().build();
    }

    public CompatibleBlockSettings build(CompatIdentifier id) {
        CompatibleBlockSettings settings = this.copyFromBlock != null ? CompatibleBlockSettings.copy(id, (class_4970)this.copyFromBlock.get()) : CompatibleBlockSettings.of(id);
        if (this.material != null) {
            settings = CompatibleBlockSettings.of(id, this.material);
        }
        if (this.mapColor != null) {
            settings = settings.mapColor(this.mapColor.getColor());
        } else if (this.dyeColor != null) {
            settings = settings.mapColor(this.dyeColor.getColor().method_7794());
        }
        if (this.requiresTool) {
            settings.requiresTool();
        }
        if (this.dropsNothing) {
            settings.dropsNothing();
        }
        if (this.luminance != null) {
            settings.luminance(state -> this.luminance.applyAsInt(BlockState.of(state)));
        }
        if (this.hardness != -1.0f && this.resistance != -1.0f) {
            settings.strength(this.hardness, this.resistance);
        } else if (this.hardness != -1.0f) {
            settings.strength(this.hardness);
        }
        if (this.blockSoundGroup != null) {
            settings.sounds(this.blockSoundGroup);
        }
        return settings;
    }

    public class_4970.class_2251 _build(CompatIdentifier id) {
        return this.build(id).build();
    }

    public BlockSettingsBuilder copy(CompatIdentifier id) {
        BlockSettingsBuilder builder = new BlockSettingsBuilder();
        builder.copyFromBlock = this.copyFromBlock;
        builder.id = id;
        builder.hardness = this.hardness;
        builder.resistance = this.resistance;
        builder.blockSoundGroup = this.blockSoundGroup;
        builder.material = this.material;
        builder.mapColor = this.mapColor;
        builder.dyeColor = this.dyeColor;
        builder.requiresTool = this.requiresTool;
        builder.dropsNothing = this.dropsNothing;
        builder.luminance = this.luminance;
        return builder;
    }

    public BlockSettingsBuilder copy() {
        return this.copy(this.id);
    }

    public static BlockSettingsBuilder of(CompatIdentifier id) {
        return new BlockSettingsBuilder(id);
    }

    public static BlockSettingsBuilder of() {
        return new BlockSettingsBuilder();
    }

    public static BlockSettingsBuilder copyBlock(BlockWrapper block) {
        BlockSettingsBuilder builder = new BlockSettingsBuilder(block.getId());
        builder.copyFromBlock = block;
        return builder;
    }

    public static BlockSettingsBuilder copyBlock(CompatIdentifier id) {
        return BlockSettingsBuilder.copyBlock(BlockWrapper.of(id));
    }
}

