/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.view;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.screen.view.BookViewAccess;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookViewScreen
extends SpreadBookScreen {
    protected BookViewAccess bookAccess;
    protected Pair<List<class_5481>, List<class_5481>> cachedPageComponents;
    protected int cachedSpread;

    public SpreadBookViewScreen(BookViewAccess bookAccess, int bookColor) {
        super(bookColor);
        this.bookAccess = bookAccess;
        this.cachedPageComponents = Pair.of(Collections.emptyList(), Collections.emptyList());
        this.cachedSpread = -1;
    }

    public BookViewAccess getBookAccess() {
        return this.bookAccess;
    }

    public void setBookAccess(BookViewAccess bookViewAccess) {
        this.bookAccess = bookViewAccess;
        this.currentSpread = class_3532.method_15340((int)this.currentSpread, (int)0, (int)this.getSpreadCount());
        this.cachedSpread = -1;
    }

    @Override
    public int getPageCount() {
        return this.getBookAccess().getPageCount();
    }

    public boolean setPage(int pageIndex) {
        int spreadIndex = (int)((float)(pageIndex = class_3532.method_15340((int)pageIndex, (int)0, (int)(this.getBookAccess().getPageCount() - 1))) / 2.0f);
        if (spreadIndex != this.currentSpread) {
            this.currentSpread = spreadIndex;
            this.cachedSpread = -1;
            return true;
        }
        return false;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtonVisibility();
        this.method_52752(guiGraphics);
        this.renderBook(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageNumbers(guiGraphics, mouseX, mouseY, partialTick, this.currentSpread);
        this.renderTools(guiGraphics, mouseX, mouseY, partialTick);
        this.updateAndCacheContentsIfNeeded();
        this.renderPageContents(guiGraphics, (List)this.cachedPageComponents.getFirst(), this.leftPos + 22, this.topPos + 21);
        this.renderPageContents(guiGraphics, (List)this.cachedPageComponents.getSecond(), this.leftPos + 159, this.topPos + 21);
        class_2583 style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            guiGraphics.method_51441(this.field_22793, style, mouseX, mouseY);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void updateAndCacheContentsIfNeeded() {
        if (this.cachedSpread != this.currentSpread) {
            class_5348 leftFormattedText = this.getBookAccess().getPage(this.currentSpread * 2);
            class_5348 rightFormattedText = this.getBookAccess().getPageCount() > this.currentSpread * 2 + 1 ? this.getBookAccess().getPage(this.currentSpread * 2 + 1) : class_5348.field_25310;
            this.cachedPageComponents = Pair.of((Object)this.field_22793.method_1728(leftFormattedText, 114), (Object)this.field_22793.method_1728(rightFormattedText, 114));
            this.cachedSpread = this.currentSpread;
        }
    }

    protected void renderPageContents(class_332 guiGraphics, List<class_5481> lines, int x, int y) {
        Objects.requireNonNull(this.field_22793);
        int maxLines = Math.min(128 / 9, lines.size());
        for (int i = 0; i < maxLines; ++i) {
            class_5481 text = lines.get(i);
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51430(this.field_22793, text, x, y + i * 9, this.textColor, false);
        }
    }

    public boolean method_25402(double x, double y, int button) {
        class_2583 style;
        if (button == 0 && (style = this.getClickedComponentStyleAt(x, y)) != null && this.method_25430(style)) {
            return true;
        }
        return super.method_25402(x, y, button);
    }

    public boolean method_25430(class_2583 style) {
        if (style == null) {
            return false;
        }
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            String pageNumber = clickEvent.method_10844();
            try {
                int pageIndex = Integer.parseInt(pageNumber) - 1;
                boolean pageChanged = this.setPage(pageIndex);
                if (pageChanged) {
                    this.playPageTurnSound();
                }
                return pageChanged;
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean handled = super.method_25430(style);
        if (handled && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return handled;
    }

    @Nullable
    public class_2583 getClickedComponentStyleAt(double mouseX, double mouseY) {
        List pageContents;
        boolean isOverRightPage;
        if (mouseY < (double)(this.topPos + 21) || mouseY >= (double)(this.topPos + 21 + 128)) {
            return null;
        }
        if (mouseX >= (double)(this.leftPos + 159) && mouseX < (double)(this.leftPos + 159 + 114)) {
            isOverRightPage = true;
        } else if (mouseX >= (double)(this.leftPos + 22) && mouseX < (double)(this.leftPos + 22 + 114)) {
            isOverRightPage = false;
        } else {
            return null;
        }
        List list = pageContents = isOverRightPage ? (List)this.cachedPageComponents.getSecond() : (List)this.cachedPageComponents.getFirst();
        if (pageContents.isEmpty()) {
            return null;
        }
        int x = (int)mouseX - (this.leftPos + (isOverRightPage ? 159 : 22));
        int y = (int)mouseY - (this.topPos + 21);
        Objects.requireNonNull(this.field_22793);
        int linesCount = Math.min(128 / 9, pageContents.size());
        Objects.requireNonNull(this.field_22793);
        if (y < 9 * linesCount + linesCount) {
            Objects.requireNonNull(this.field_22793);
            int clickedLine = y / 9;
            if (clickedLine >= 0 && clickedLine < pageContents.size()) {
                class_5481 text = (class_5481)pageContents.get(clickedLine);
                return this.field_22793.method_27527().method_30876(text, x);
            }
            return null;
        }
        return null;
    }
}

