/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.view;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.class_1799;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public interface BookViewAccess {
    public static final BookViewAccess EMPTY = new BookViewAccess(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public class_5348 getPageRaw(int i) {
            return class_5348.field_25310;
        }
    };

    public int getPageCount();

    public class_5348 getPageRaw(int var1);

    default public class_5348 getPage(int pageIndex) {
        return pageIndex >= 0 && pageIndex < this.getPageCount() ? this.getPageRaw(pageIndex) : class_5348.field_25310;
    }

    public static BookViewAccess fromItem(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof class_1843) {
            return new WrittenBookAccess(itemStack);
        }
        if (itemStack.method_7909() instanceof class_1840) {
            return new WritableBookAccess(itemStack);
        }
        return EMPTY;
    }

    public static List<String> loadPages(class_2487 compoundTag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        BookViewAccess.loadPages(compoundTag, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void loadPages(class_2487 compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        class_2499 listTag = compoundTag.method_10554("pages", 8).method_10612();
        if (class_310.method_1551().method_33883() && compoundTag.method_10573("filtered_pages", 10)) {
            class_2487 compoundTag2 = compoundTag.method_10562("filtered_pages");
            intFunction = ix -> {
                String string = String.valueOf(ix);
                return compoundTag2.method_10545(string) ? compoundTag2.method_10558(string) : listTag.method_10608(ix);
            };
        } else {
            Objects.requireNonNull(listTag);
            intFunction = arg_0 -> ((class_2499)listTag).method_10608(arg_0);
        }
        for (int i = 0; i < listTag.size(); ++i) {
            consumer.accept(intFunction.apply(i));
        }
    }

    public static class WrittenBookAccess
    implements BookViewAccess {
        private final List<class_2561> pages;

        public WrittenBookAccess(class_1799 itemStack) {
            this.pages = WrittenBookAccess.readPages(itemStack);
        }

        private static List<class_2561> readPages(class_1799 itemStack) {
            class_9302 content = (class_9302)itemStack.method_57825(class_9334.field_49606, (Object)class_9302.field_49829);
            return content.method_57525(class_310.method_1551().method_33883());
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        @NotNull
        public class_5348 getPageRaw(int i) {
            return (class_5348)this.pages.get(i);
        }
    }

    public static class WritableBookAccess
    implements BookViewAccess {
        private final List<String> pages;

        public WritableBookAccess(class_1799 itemStack) {
            this.pages = WritableBookAccess.readPages(itemStack);
        }

        private static List<String> readPages(class_1799 itemStack) {
            class_9301 content = (class_9301)itemStack.method_57825(class_9334.field_49653, (Object)class_9301.field_49369);
            return content.method_57517(class_310.method_1551().method_33883()).toList();
        }

        @Override
        public int getPageCount() {
            return 100;
        }

        @Override
        public class_5348 getPageRaw(int i) {
            return i >= this.pages.size() ? class_5348.field_25310 : class_5348.method_29430((String)this.pages.get(i));
        }
    }
}

