/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.melody.resources.audio;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.melody.resources.audio.MelodyAudioException;
import de.keksuccino.melody.resources.audio.openal.ALAudioBuffer;
import de.keksuccino.melody.resources.audio.openal.ALAudioClip;
import de.keksuccino.melody.resources.audio.openal.ALUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4228;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleAudioFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConsumingSupplier<String, Boolean> BASIC_URL_TEXT_VALIDATOR = consumes -> {
        if (consumes != null && !consumes.replace(" ", "").isEmpty() && (consumes.startsWith("http://") || consumes.startsWith("https://")) && consumes.contains(".")) {
            return true;
        }
        return false;
    };

    @NotNull
    public static CompletableFuture<ALAudioClip> ogg(@NotNull String audioSource, @NotNull SourceType sourceType) throws MelodyAudioException {
        Objects.requireNonNull(audioSource);
        Objects.requireNonNull(sourceType);
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            throw new MelodyAudioException("Failed to create OGG audio clip! OpenAL not ready! Audio source: " + audioSource);
        }
        ALAudioClip clip = ALAudioClip.create();
        if (clip == null) {
            throw new MelodyAudioException("Failed to create OGG audio clip! Clip was NULL for: " + audioSource);
        }
        if (sourceType == SourceType.RESOURCE_LOCATION) {
            class_2960 location = class_2960.method_12829((String)audioSource);
            if (location == null) {
                clip.closeQuietly();
                throw new MelodyAudioException("Failed to create OGG audio clip! ResourceLocation parsing failed: " + audioSource);
            }
            Optional resource = class_310.method_1551().method_1478().method_14486(location);
            if (resource.isPresent()) {
                try {
                    InputStream in = ((class_3298)resource.get()).method_14482();
                    CompletableFuture<ALAudioClip> completableFuture = new CompletableFuture<ALAudioClip>();
                    new Thread(() -> {
                        Exception ex = SimpleAudioFactory.tryCreateAndSetOggStaticBuffer(clip, in);
                        if (ex != null) {
                            completableFuture.completeExceptionally(ex);
                            clip.closeQuietly();
                        } else {
                            completableFuture.complete(clip);
                        }
                    }).start();
                    return completableFuture;
                }
                catch (Exception ex) {
                    clip.closeQuietly();
                    throw (MelodyAudioException)new MelodyAudioException("Failed to create OGG audio clip! Failed to open ResourceLocation input stream: " + audioSource).initCause(ex);
                }
            }
            clip.closeQuietly();
            throw new MelodyAudioException("Failed to create OGG audio clip! Resource for ResourceLocation not found: " + audioSource);
        }
        if (sourceType == SourceType.LOCAL_FILE) {
            File file = new File(audioSource);
            if (!file.isFile()) {
                clip.closeQuietly();
                throw new MelodyAudioException("Failed to create OGG audio clip! File not found: " + audioSource);
            }
            try {
                FileInputStream in = new FileInputStream(file);
                CompletableFuture<ALAudioClip> completableFuture = new CompletableFuture<ALAudioClip>();
                new Thread(() -> {
                    Exception ex = SimpleAudioFactory.tryCreateAndSetOggStaticBuffer(clip, in);
                    if (ex != null) {
                        completableFuture.completeExceptionally(ex);
                        clip.closeQuietly();
                    } else {
                        completableFuture.complete(clip);
                    }
                }).start();
                return completableFuture;
            }
            catch (Exception ex) {
                clip.closeQuietly();
                throw (MelodyAudioException)new MelodyAudioException("Failed to create OGG audio clip! Failed to open File input stream: " + audioSource).initCause(ex);
            }
        }
        if (!BASIC_URL_TEXT_VALIDATOR.get(audioSource).booleanValue()) {
            clip.closeQuietly();
            throw new MelodyAudioException("Failed to create OGG audio clip! Invalid URL: " + audioSource);
        }
        try {
            InputStream webIn = SimpleAudioFactory.openWebResourceStream(audioSource);
            CompletableFuture<ALAudioClip> completableFuture = new CompletableFuture<ALAudioClip>();
            new Thread(() -> {
                ByteArrayInputStream in = null;
                Exception streamReadException = null;
                try {
                    in = new ByteArrayInputStream(webIn.readAllBytes());
                }
                catch (Exception ex) {
                    streamReadException = ex;
                }
                IOUtils.closeQuietly((InputStream)webIn);
                if (in == null) {
                    completableFuture.completeExceptionally(streamReadException);
                    clip.closeQuietly();
                } else {
                    ex = SimpleAudioFactory.tryCreateAndSetOggStaticBuffer(clip, in);
                    if (ex != null) {
                        completableFuture.completeExceptionally(ex);
                        clip.closeQuietly();
                    } else {
                        completableFuture.complete(clip);
                    }
                }
            }).start();
            return completableFuture;
        }
        catch (Exception ex) {
            clip.closeQuietly();
            throw (MelodyAudioException)new MelodyAudioException("Failed to create OGG audio clip! Failed to open web input stream: " + audioSource).initCause(ex);
        }
    }

    @NotNull
    public static CompletableFuture<ALAudioClip> wav(@NotNull String audioSource, @NotNull SourceType sourceType) throws MelodyAudioException {
        Objects.requireNonNull(audioSource);
        Objects.requireNonNull(sourceType);
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            throw new MelodyAudioException("Failed to create WAV audio clip! OpenAL not ready! Audio source: " + audioSource);
        }
        ALAudioClip clip = ALAudioClip.create();
        if (clip == null) {
            throw new MelodyAudioException("Failed to create WAV audio clip! Clip was NULL for: " + audioSource);
        }
        if (sourceType == SourceType.RESOURCE_LOCATION) {
            class_2960 location = class_2960.method_12829((String)audioSource);
            if (location == null) {
                clip.closeQuietly();
                throw new MelodyAudioException("Failed to create WAV audio clip! ResourceLocation parsing failed: " + audioSource);
            }
            Optional resource = class_310.method_1551().method_1478().method_14486(location);
            if (resource.isPresent()) {
                try {
                    InputStream in = ((class_3298)resource.get()).method_14482();
                    CompletableFuture<ALAudioClip> completableFuture = new CompletableFuture<ALAudioClip>();
                    new Thread(() -> {
                        Exception ex = SimpleAudioFactory.tryCreateAndSetWavStaticBuffer(clip, in);
                        if (ex != null) {
                            completableFuture.completeExceptionally(ex);
                            clip.closeQuietly();
                        } else {
                            completableFuture.complete(clip);
                        }
                    }).start();
                    return completableFuture;
                }
                catch (Exception ex) {
                    clip.closeQuietly();
                    throw (MelodyAudioException)new MelodyAudioException("Failed to create WAV audio clip! Failed to open ResourceLocation input stream: " + audioSource).initCause(ex);
                }
            }
            clip.closeQuietly();
            throw new MelodyAudioException("Failed to create WAV audio clip! Resource for ResourceLocation not found: " + audioSource);
        }
        if (sourceType == SourceType.LOCAL_FILE) {
            File file = new File(audioSource);
            if (!file.isFile()) {
                clip.closeQuietly();
                throw new MelodyAudioException("Failed to create WAV audio clip! File not found: " + audioSource);
            }
            try {
                FileInputStream in = new FileInputStream(file);
                CompletableFuture<ALAudioClip> completableFuture = new CompletableFuture<ALAudioClip>();
                new Thread(() -> {
                    Exception ex = SimpleAudioFactory.tryCreateAndSetWavStaticBuffer(clip, in);
                    if (ex != null) {
                        completableFuture.completeExceptionally(ex);
                        clip.closeQuietly();
                    } else {
                        completableFuture.complete(clip);
                    }
                }).start();
                return completableFuture;
            }
            catch (Exception ex) {
                clip.closeQuietly();
                throw (MelodyAudioException)new MelodyAudioException("Failed to create WAV audio clip! Failed to open File input stream: " + audioSource).initCause(ex);
            }
        }
        if (!BASIC_URL_TEXT_VALIDATOR.get(audioSource).booleanValue()) {
            clip.closeQuietly();
            throw new MelodyAudioException("Failed to create WAV audio clip! Invalid URL: " + audioSource);
        }
        try {
            InputStream webIn = SimpleAudioFactory.openWebResourceStream(audioSource);
            CompletableFuture<ALAudioClip> completableFuture = new CompletableFuture<ALAudioClip>();
            new Thread(() -> {
                Exception ex = SimpleAudioFactory.tryCreateAndSetWavStaticBuffer(clip, webIn);
                if (ex != null) {
                    completableFuture.completeExceptionally(ex);
                    clip.closeQuietly();
                } else {
                    completableFuture.complete(clip);
                }
            }).start();
            return completableFuture;
        }
        catch (Exception ex) {
            clip.closeQuietly();
            throw (MelodyAudioException)new MelodyAudioException("Failed to create WAV audio clip! Failed to open web input stream: " + audioSource).initCause(ex);
        }
    }

    @Nullable
    private static Exception tryCreateAndSetOggStaticBuffer(@NotNull ALAudioClip setTo, @NotNull InputStream in) {
        class_4228 stream = null;
        Exception exception = null;
        try {
            stream = new class_4228(in);
            ByteBuffer byteBuffer = stream.method_59757();
            ALAudioBuffer audioBuffer = new ALAudioBuffer(byteBuffer, stream.method_19719());
            setTo.setStaticBuffer(audioBuffer);
        }
        catch (Exception ex) {
            exception = ex;
        }
        IOUtils.closeQuietly((Closeable)stream);
        IOUtils.closeQuietly((InputStream)in);
        return exception;
    }

    @Nullable
    private static Exception tryCreateAndSetWavStaticBuffer(@NotNull ALAudioClip setTo, @NotNull InputStream in) {
        AudioInputStream stream = null;
        ByteArrayInputStream byteIn = null;
        Exception exception = null;
        try {
            byteIn = new ByteArrayInputStream(in.readAllBytes());
            stream = AudioSystem.getAudioInputStream(byteIn);
            ByteBuffer byteBuffer = ALUtils.readStreamIntoBuffer(stream);
            ALAudioBuffer audioBuffer = new ALAudioBuffer(byteBuffer, stream.getFormat());
            setTo.setStaticBuffer(audioBuffer);
        }
        catch (Exception ex) {
            exception = ex;
        }
        IOUtils.closeQuietly(stream);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)byteIn);
        return exception;
    }

    @NotNull
    private static InputStream openWebResourceStream(@NotNull String resourceURL) throws IOException {
        URL actualURL = new URL(resourceURL);
        HttpURLConnection connection = (HttpURLConnection)actualURL.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/4.0");
        return connection.getInputStream();
    }

    public static enum SourceType {
        RESOURCE_LOCATION,
        LOCAL_FILE,
        WEB_FILE;

    }

    @FunctionalInterface
    private static interface ConsumingSupplier<C, R> {
        public R get(C var1);
    }
}

