/*
 * Decompiled with CFR 0.152.
 */
package artemis.better_climbing.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    private int climbDownTicks = 0;
    private int climbUpTicks = 0;
    private boolean climbingUpThisTick = false;

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean method_6101();

    @Redirect(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(DDD)D"))
    private double better_climbing_modifyHorizontalMovementWhenClimbing(double speed, double vanillaSpeedMin, double vanillaSpeedMax) {
        if (!this.method_37908().method_8608()) {
            return class_3532.method_15350((double)speed, (double)vanillaSpeedMin, (double)vanillaSpeedMax);
        }
        if (!this.method_24828() && this.method_18276()) {
            return class_3532.method_15350((double)speed, (double)vanillaSpeedMin, (double)vanillaSpeedMax);
        }
        return speed;
    }

    @Redirect(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(DD)D"))
    private double better_climbing_modifyVerticalMovementWhenClimbing(double currentYSpeed, double vanillaDownSpeed) {
        if (!this.method_37908().method_8608()) {
            return Math.max(currentYSpeed, vanillaDownSpeed);
        }
        double maxDownSpeed = class_3532.method_32854((double)this.method_36455(), (double)20.0, (double)90.0, (double)vanillaDownSpeed, (double)-0.4);
        if (maxDownSpeed < -0.15) {
            maxDownSpeed = class_3532.method_32854((double)this.climbDownTicks, (double)0.0, (double)60.0, (double)maxDownSpeed, (double)(maxDownSpeed * 1.5));
        }
        return Math.max(currentYSpeed, maxDownSpeed);
    }

    @Inject(method={"handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void better_climbing_incrementClimbTimer(CallbackInfoReturnable<class_243> cir) {
        if (!this.method_37908().method_8608()) {
            return;
        }
        class_243 movement = (class_243)cir.getReturnValue();
        this.climbDownTicks = this.method_6101() && movement.field_1351 < 0.0 && this.method_36455() > 20.0f ? ++this.climbDownTicks : 0;
        if (this.climbingUpThisTick) {
            ++this.climbUpTicks;
            this.climbingUpThisTick = false;
        } else {
            this.climbUpTicks = 0;
        }
        cir.setReturnValue((Object)movement);
    }

    @ModifyArg(method={"handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"), index=1)
    private double better_climbing_allowJumpingInLadderAndSpeedUpClimbing(double vanillaClimbSpeed) {
        if (!this.method_37908().method_8608()) {
            return vanillaClimbSpeed;
        }
        this.climbingUpThisTick = true;
        double increasedVanillaClimbSpeed = vanillaClimbSpeed * 1.25;
        double climbYSpeed = class_3532.method_32854((double)this.climbUpTicks, (double)0.0, (double)60.0, (double)increasedVanillaClimbSpeed, (double)(increasedVanillaClimbSpeed * 2.0));
        return Math.max(this.method_18798().field_1351, climbYSpeed);
    }

    @Redirect(method={"handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;horizontalCollision:Z", opcode=180))
    private boolean better_climbing_cancelNonDeliberateCollission(class_1309 livingEntity) {
        if (this.method_37908().method_8608() && livingEntity instanceof class_746) {
            class_746 player = (class_746)livingEntity;
            return livingEntity.field_5976 && player.field_3913.method_3128().method_35584() > 0.0f;
        }
        return livingEntity.field_5976;
    }
}

