/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.CobblemonWorldSpawnerManager;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.config.CobblemonConfig;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.mixins.SpawningConditionMixin;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.KeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import kotlin.Pair;
import kotlin.Unit;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class ForceSpawningUtils {
    public static class_1271<class_1799> forceSpawnv1(class_1937 world, class_1657 playerEntity, class_1268 hand, String keyItemIdentifierPath) {
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        class_1799 itemStack = playerEntity.method_5998(hand);
        playerEntity.method_7357().method_7906(itemStack.method_7909(), Modconfig.force_spawn_item_cooldown);
        if (!Modconfig.enable_force_spawning) {
            return class_1271.method_22431((Object)itemStack);
        }
        PlayerDataUtils.checkPlayerInventory(playerEntity);
        if (!world.field_9236) {
            PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.method_5667());
            SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> Modconfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
            if (spawner != null) {
                SpawnCause cause;
                SpawningArea area;
                if (spawn_bucket == null ? (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (class_1297)spawner.getCauseEntity()))) == null : (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawn_bucket, (class_1297)spawner.getCauseEntity()))) == null) {
                    // empty if block
                }
                CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
                WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (class_3218)playerEntity.method_37908(), (int)Math.ceil(playerEntity.method_23317() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.method_23318() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.method_23321() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
                List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                if (contexts.isEmpty()) {
                    // empty if block
                }
                contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selection -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selection.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                    SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                    ForceSpawningUtils.handleSpawnAction2(spawnAction);
                });
            }
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    public static boolean forceSpawnv1command(class_1657 playerEntity, String keyItemIdentifierPath) {
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        if (!Modconfig.enable_force_spawning) {
            return false;
        }
        PlayerDataUtils.checkPlayerInventory(playerEntity);
        PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.method_5667());
        SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> Modconfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
        if (spawner != null) {
            SpawnCause cause;
            SpawningArea area;
            if (spawn_bucket == null ? (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (class_1297)spawner.getCauseEntity()))) == null : (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawn_bucket, (class_1297)spawner.getCauseEntity()))) == null) {
                return false;
            }
            CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
            WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (class_3218)playerEntity.method_37908(), (int)Math.ceil(playerEntity.method_23317() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.method_23318() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.method_23321() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
            List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
            if (contexts.isEmpty()) {
                return false;
            }
            contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selection -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selection.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                ForceSpawningUtils.handleSpawnAction2(spawnAction);
            });
            return true;
        }
        return false;
    }

    public static boolean forceSpawnv1SO(class_1937 world, class_1657 playerEntity, class_1268 hand, String keyItemIdentifierPath) {
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        class_1799 itemStack = playerEntity.method_5998(hand);
        playerEntity.method_7357().method_7906(itemStack.method_7909(), Modconfig.force_spawn_item_cooldown);
        if (!Modconfig.enable_force_spawning) {
            return false;
        }
        PlayerDataUtils.checkPlayerInventory(playerEntity);
        if (!world.field_9236) {
            PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.method_5667());
            SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> Modconfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
            if (spawner != null) {
                SpawnCause cause;
                SpawningArea area;
                if (spawn_bucket == null ? (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (class_1297)spawner.getCauseEntity()))) == null : (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawn_bucket, (class_1297)spawner.getCauseEntity()))) == null) {
                    // empty if block
                }
                CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
                WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (class_3218)playerEntity.method_37908(), (int)Math.ceil(playerEntity.method_23317() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.method_23318() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.method_23321() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
                List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                if (contexts.isEmpty()) {
                    // empty if block
                }
                contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selection -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selection.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                    SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                    ForceSpawningUtils.handleSpawnAction2(spawnAction);
                });
            }
        }
        return true;
    }

    public static class_1271<class_1799> forceSpawnv2(class_1937 world, class_1657 playerEntity, class_1268 hand, String keyItemIdentifierPath) {
        class_1799 itemStack = playerEntity.method_5998(hand);
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        playerEntity.method_7357().method_7906(itemStack.method_7909(), Modconfig.force_spawn_item_cooldown);
        if (!world.field_9236) {
            PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.method_5667());
            SpawnBucket ultra_rare_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> "ultra-rare".equalsIgnoreCase(b.name)).findFirst().orElse(null);
            if (spawner != null) {
                SpawnCause cause;
                SpawningArea area;
                if (ultra_rare_bucket == null ? (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (class_1297)spawner.getCauseEntity()))) == null : (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, ultra_rare_bucket, (class_1297)spawner.getCauseEntity()))) == null) {
                    // empty if block
                }
                CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
                WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (class_3218)playerEntity.method_37908(), (int)Math.ceil(playerEntity.method_23317() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.method_23318() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.method_23321() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
                List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                if (contexts.isEmpty()) {
                    // empty if block
                }
                for (AreaSpawningContext context : contexts) {
                    Pair selected = spawner.getSpawningSelector().select((Spawner)spawner, List.of(context));
                    if (selected == null || !ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selected.getSecond(), keyItemIdentifierPath)) continue;
                    SingleEntitySpawnAction spawnAction = (SingleEntitySpawnAction)((SpawnDetail)selected.getSecond()).doSpawn((SpawningContext)selected.getFirst());
                    class_1297 entityToSpawn = Objects.requireNonNull(spawnAction.createEntity());
                    CobblemonEvents.ENTITY_SPAWN.postThen((Cancelable)new SpawnEvent(entityToSpawn, (SpawningContext)selected.getFirst()), event -> Unit.INSTANCE, ifSucceeded -> {
                        ((SpawningContext)selected.getFirst()).getWorld().method_8649(entityToSpawn);
                        return Unit.INSTANCE;
                    });
                    if (playerEntity.method_31549().field_7477) break;
                    itemStack.method_7934(1);
                    break;
                }
            }
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    private static boolean isSpawnDetailForKeyItem(SpawnDetail detail, String keyItemIdentifierPath) {
        for (SpawningCondition condition : detail.getConditions()) {
            if (!(condition instanceof SpawningConditionMixin)) continue;
            SpawningConditionMixin conditionMixin = (SpawningConditionMixin)condition;
            List<AppendageCondition> appendages = conditionMixin.getAppendages();
            for (AppendageCondition appendage : appendages) {
                if (!(appendage instanceof KeyItemCondition)) continue;
                KeyItemCondition keyItemCondition = (KeyItemCondition)appendage;
                if (keyItemCondition.getItemCondtionIdentifier() != null) {
                    return keyItemCondition.getItemCondtionIdentifier().method_12832().equals(keyItemIdentifierPath);
                }
                return false;
            }
        }
        return false;
    }

    public static void handleSpawnAction(SpawnAction<?> spawnAction) {
        ((CompletableFuture)((CompletableFuture)spawnAction.getFuture().thenAccept(result -> {
            if (result instanceof EntitySpawnResult) {
                EntitySpawnResult entitySpawnResult = (EntitySpawnResult)result;
            }
        })).exceptionally(throwable -> null)).thenRun(() -> spawnAction.complete());
    }

    public static void handleSpawnAction2(SpawnAction<?> spawnAction) {
        spawnAction.complete();
        ((CompletableFuture)spawnAction.getFuture().thenAccept(result -> {
            if (result instanceof EntitySpawnResult) {
                EntitySpawnResult entitySpawnResult = (EntitySpawnResult)result;
            }
        })).exceptionally(throwable -> null);
    }
}

