/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.configs;

import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.moandjiezana.toml.Toml;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;

public class ConfigManager {
    public static final String MOD_CONFIG_DIRECTORY_NAME = "MythsAndLegends";
    private final File configFile;
    private ModConfigs config;

    public ConfigManager() {
        Path configDirectoryPath = Platform.getConfigFolder().resolve(MOD_CONFIG_DIRECTORY_NAME);
        File configDirectory = configDirectoryPath.toFile();
        if (!configDirectory.exists() && !configDirectory.mkdirs()) {
            throw new RuntimeException("Failed to create configuration directory: " + String.valueOf(configDirectory));
        }
        this.configFile = configDirectoryPath.resolve("config.toml").toFile();
        this.loadConfig(this.configFile);
    }

    private void loadConfig(File configFile) {
        if (configFile.exists()) {
            try {
                Toml toml = new Toml().read(configFile);
                this.config = (ModConfigs)toml.to(ModConfigs.class);
            }
            catch (Exception e) {
                Logger.getLogger(ConfigManager.class.getName()).severe("Failed to load configuration file: " + e.getMessage());
                this.config = new ModConfigs();
            }
        } else {
            this.config = new ModConfigs();
        }
        this.saveConfigWithGeneralDescriptions(configFile);
    }

    public void saveConfig() {
        this.saveConfigWithGeneralDescriptions(this.configFile);
    }

    private void saveConfigWithGeneralDescriptions(File configFile) {
        StringBuilder tomlContent = new StringBuilder();
        tomlContent.append("# Interval in Minecraft ticks for checking player inventories. Possible values: any integer. Default: 3600 (2 minutes and 30 seconds).\n");
        tomlContent.append("inventory_check_interval = ").append(this.config.inventory_check_interval).append("\n\n");
        tomlContent.append("# Determines if items are consumed on successful spawns. Possible values: true, false. Default: false.\n");
        tomlContent.append("consume_items_on_successful_spawn = ").append(this.config.consume_items_on_successful_spawn).append("\n\n");
        tomlContent.append("# If true, and both a key item and item condition are set, only items are consumed. Possible values: true, false. Default: true.\n");
        tomlContent.append("ignore_key_items = ").append(this.config.ignore_key_items).append("\n\n");
        tomlContent.append("# List of items to be checked in the inventory at each interval.\n");
        tomlContent.append("inventory_check_item_list = ").append(this.listToString(this.config.inventory_check_item_list)).append("\n");
        tomlContent.append("# Determines if broadcasting features are enabled. This includes all types of notifications specified in 'broadcast_settings'. Enables or disables the entire broadcasting system. Possible values: true, false. Default: false\n");
        tomlContent.append("isBroadcastEnabled = ").append(this.config.isBroadcastEnabled).append("\n\n");
        tomlContent.append("# Configures specific broadcast messages for Pokemon spawns. Each option enables or disables broadcasts for different categories of Pokemon (Legendary, Mythical, Ultra Beast), or provides additional information (Shiny status, level). Adjust these settings to customize what details are broadcasted when Pokemon spawn.\n");
        tomlContent.append("broadcast_settings = [\n");
        tomlContent.append("  { settingName = \"BroadcastToAll\", settingValue = ").append(this.config.broadcast_settings.get((int)0).settingValue).append(" }, # When true, messages are broadcasted to all players. Possible values: true, false. Default: true.\n");
        tomlContent.append("  { settingName = \"DisplayName\", settingValue = ").append(this.config.broadcast_settings.get((int)1).settingValue).append(" },  # If enabled, displays the name of the Pokemon in the broadcast message. Possible values: true, false. Default: true.\n");
        tomlContent.append("  { settingName = \"Legendarys\", settingValue = ").append(this.config.broadcast_settings.get((int)2).settingValue).append(" }, # If enabled, broadcasts a message when a legendary Pokemon spawns.  Possible values: true, false. Default: true.\n");
        tomlContent.append("  { settingName = \"Mythicals\", settingValue = ").append(this.config.broadcast_settings.get((int)3).settingValue).append("} , # If enabled, broadcasts a message when a mythical Pokemon spawns.  Possible values: true, false. Default: true.\n");
        tomlContent.append("  { settingName = \"UltraBeasts\", settingValue = ").append(this.config.broadcast_settings.get((int)4).settingValue).append(" }, # If enabled, broadcasts a message when an Ultra Beast spawns.  Possible values: true, false. Default: false.\n");
        tomlContent.append("  { settingName = \"Location\", settingValue = ").append(this.config.broadcast_settings.get((int)5).settingValue).append(" }, # If true, includes the location in broadcast messages. Possible values: true, false. Default: true.\n");
        tomlContent.append("  { settingName = \"Shiny\", settingValue = ").append(this.config.broadcast_settings.get((int)6).settingValue).append(" }, # Enables broadcasts about Shiny Status of the Pokemon. Possible values: true, false. Default: false.\n");
        tomlContent.append("  { settingName = \"Level\", settingValue = ").append(this.config.broadcast_settings.get((int)7).settingValue).append(" } # When enabled, the level of Pokemon is included in the broadcast. Possible values: true, false. Default: true.\n");
        tomlContent.append("]\n\n");
        tomlContent.append("# Determines if the contents of shulker boxes should be scanned for items by the inventory_check.\n");
        tomlContent.append("# Possible values: true, false. Default: true.\n");
        tomlContent.append("inventory_check_shulker_boxes = ").append(this.config.inventory_check_shulker_boxes).append("\n\n");
        tomlContent.append("# Determines if the contents of bundles should be scanned for items by the inventory_check.\n");
        tomlContent.append("# Possible values: true, false. Default: true.\n");
        tomlContent.append("inventory_check_bundles = ").append(this.config.inventory_check_bundles).append("\n\n");
        tomlContent.append("# Determines if right-clicking key items forcefully spawns Pokemon that require the clicked key item as a spawning condition.\n");
        tomlContent.append("# Possible values: true, false. Default: false\n");
        tomlContent.append("enable_force_spawning = ").append(this.config.enable_force_spawning).append("\n\n");
        tomlContent.append("# Determines in which Spawn Pool the force spawning module should check.\n");
        tomlContent.append("# Note: Changing this setting does not affect the actual spawns, only the force spawning behavior.\n");
        tomlContent.append("# To change spawn rarity, modify the entire datapack.\n");
        tomlContent.append("# Possible values: common, uncommon, rare, ultra-rare. Default: ultra-rare\n");
        tomlContent.append("force_spawning_spawn_pool = \"").append(this.config.force_spawning_spawn_pool).append("\"\n\n");
        tomlContent.append("# Sets the cooldown period (in seconds) after a key item is used for force spawning before it can be used again.\n");
        tomlContent.append("# Possible values: any integer >= 1. Default: 20\n");
        tomlContent.append("force_spawn_item_cooldown = ").append(this.config.force_spawn_item_cooldown).append("\n\n");
        tomlContent.append("# Defines the width around the player within which the game checks for possible Pokemon spawns\n").append("# when force spawning. Increasing this value may cause lag but is more likely to find a spawn.\n").append("# Please adjust carefully.\n").append("# Possible values: any integer >= 1\n").append("# Default: 100\n").append("force_spawn_check_width = ").append(this.config.force_spawn_check_width).append("\n\n");
        tomlContent.append("# Defines the height around the player within which the game checks for possible Pokemon spawns\n").append("# when force spawning. Increasing this value may cause lag but is more likely to find a spawn.\n").append("# Please adjust carefully.\n").append("# Possible values: any integer >= 1\n").append("# Default: 50\n").append("force_spawn_check_height = ").append(this.config.force_spawn_check_height).append("\n\n");
        tomlContent.append("# Should the mod run in Server only mode [So clients dont require the mod to be installed(THIS DOESNT WORK CURRENTLY)]. Possible values: true, false. Default: false\n");
        tomlContent.append("server_only_mode = ").append(this.config.server_only_mode).append("\n\n");
        tomlContent.append("# Enable/Disable Form Changes (DNA Splicer, Held Item Form Changes and so on). Possible values: true, false. Default: true\n");
        tomlContent.append("form_changes = ").append(this.config.form_changes).append("\n\n");
        tomlContent.append("# Enable/Disable DEBUG Mode | This should always be false only for devs :) LEAVE IT ALONE. Default: false\n");
        tomlContent.append("debug_mode = ").append(this.config.debug_mode).append("\n\n");
        tomlContent.append("# Set the delay (in ticks(20 ticks = 1 second) after a player joins before applying forms and aspects to Pok\u00e9mon. This ensures forms and aspects are properly initialized. Possible values: Any positive integer. Default: 100 ticks\n");
        tomlContent.append("join_form_aspect_delay = ").append(this.config.join_form_aspect_delay).append("\n\n");
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(tomlContent.toString());
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().info("Toml_Writer_Error: " + e.getMessage());
        }
    }

    private String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder("[\n");
        for (String item : list) {
            sb.append("  \"").append(item).append("\",\n");
        }
        if (!list.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("\n]");
        return sb.toString();
    }

    public ModConfigs getConfig() {
        return this.config;
    }
}

