/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.d0ctorleon.mythsandlegends.cobblemon.events.HeldItemUpdateEventListener;
import com.github.d0ctorleon.mythsandlegends.cobblemon.events.SpawnEventListener;
import com.github.d0ctorleon.mythsandlegends.cobblemon.pokemon.aspects.PersistentDataAspectProvider;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.commands.Commands;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigManager;
import com.github.d0ctorleon.mythsandlegends.events.InteractionEvents;
import com.github.d0ctorleon.mythsandlegends.events.PlayerEvents;
import com.github.d0ctorleon.mythsandlegends.events.TickEvents;
import com.github.d0ctorleon.mythsandlegends.items.CreativeTab;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.loot.LootTableModifier;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import kotlin.Unit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class MythsAndLegends {
    public static final String MOD_ID = "mythsandlegends";
    private static final Logger LOGGER = LogManager.getLogger((String)"mythsandlegends");
    private static ConfigManager configManager;

    public static void init() {
        MythsAndLegends.initializeManagers();
        MythsAndLegends.registerItemsAndGroups();
        MythsAndLegends.registerLootModifiers();
        MythsAndLegends.registerEvents();
        Commands.registerCommands();
        MythsAndLegendsConditions.register();
        MythsAndLegends.registerCobblemonEvents();
        MythsAndLegends.registerAspectProviders();
    }

    private static void registerItemsAndGroups() {
        Items.registerItems();
        CreativeTab.TABS.register();
    }

    private static void initializeManagers() {
        configManager = new ConfigManager();
        PlayerDataUtils.setModConfig(configManager.getConfig());
    }

    private static void registerLootModifiers() {
        LootTableModifier.loadLootTableConfig();
        LootTableModifier.registerLootModifications();
    }

    private static void registerEvents() {
        new TickEvents();
        new InteractionEvents();
        new PlayerEvents();
    }

    public static void registerCobblemonEvents() {
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.NORMAL, event -> {
            SpawnEventListener.onPokemonSpawn((SpawnEvent<PokemonEntity>)event);
            return Unit.INSTANCE;
        });
        CobblemonEvents.HELD_ITEM_PRE.subscribe(Priority.NORMAL, event -> {
            HeldItemUpdateEventListener.onHeldItemUpdate((HeldItemEvent)event);
            return Unit.INSTANCE;
        });
        CobblemonEvents.HELD_ITEM_POST.subscribe(Priority.NORMAL, event -> {
            HeldItemUpdateEventListener.onHeldItemPost((HeldItemEvent)event);
            return Unit.INSTANCE;
        });
    }

    public static void registerAspectProviders() {
        new PersistentDataAspectProvider().register();
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static Logger getLogger() {
        if (MythsAndLegends.configManager.getConfig().debug_mode) {
            Configurator.setLevel((String)MOD_ID, (Level)Level.DEBUG);
        } else {
            Configurator.setLevel((String)MOD_ID, (Level)Level.INFO);
        }
        return LOGGER;
    }
}

