/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.ActiveCameraSetSettingC2SP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.sound.Sound;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public record CameraSetting<T>(class_9331<T> component, T defaultValue, Optional<SoundEffect> sound) {
    public static final Codec<CameraSetting<?>> CODEC = class_2960.field_25139.xmap(CameraSettings::byId, CameraSettings::idOf);
    public static final class_9139<ByteBuf, CameraSetting<?>> STREAM_CODEC = class_9139.method_56434((class_9139)class_2960.field_48267, CameraSettings::idOf, CameraSettings::byId);

    public CameraSetting(class_9331<T> component, T defaultValue, SoundEffect sound) {
        this(component, defaultValue, Optional.ofNullable(sound));
    }

    public CameraSetting(class_9331<T> component, T defaultValue) {
        this(component, defaultValue, Optional.empty());
    }

    @Nullable
    public T get(class_1799 stack) {
        return (T)stack.method_57824(this.component);
    }

    public Optional<T> getOptional(class_1799 stack) {
        return Optional.ofNullable(this.get(stack));
    }

    public T getOrDefault(class_1799 stack) {
        return (T)stack.method_57825(this.component, this.defaultValue);
    }

    public T getOrElse(class_1799 stack, T defaultValue) {
        return (T)stack.method_57825(this.component, defaultValue);
    }

    @Nullable
    public T get(Camera camera) {
        return (T)camera.getItemStack().method_57824(this.component);
    }

    public Optional<T> getOptional(Camera camera) {
        return Optional.ofNullable(this.get(camera));
    }

    public T getOrDefault(Camera camera) {
        return (T)camera.getItemStack().method_57825(this.component, this.defaultValue);
    }

    public T getOrElse(Camera camera, T defaultValue) {
        return (T)camera.getItemStack().method_57825(this.component, defaultValue);
    }

    public boolean set(class_1799 stack, T value) {
        Boolean bool;
        if (stack.method_7960() || this.getOrDefault(stack).equals(value)) {
            return false;
        }
        if (value instanceof Boolean && !(bool = (Boolean)value).booleanValue()) {
            stack.method_57381(this.component);
        } else {
            stack.method_57379(this.component, value);
        }
        return true;
    }

    public boolean set(CameraHolder holder, class_1799 stack, T value) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CameraItem) {
            CameraItem cameraItem = (CameraItem)class_17922;
            if (this.set(stack, value)) {
                cameraItem.actionPerformed(stack, holder);
                this.sound.ifPresent(sound -> Sound.playSided(holder.asHolderEntity(), sound.sound().get(), class_3419.field_15248, sound.volume(), sound.pitch(), sound.pitchVariability()));
                return true;
            }
        }
        return false;
    }

    public boolean set(Camera camera, T value) {
        return camera.map((item, stack) -> this.set(camera.getHolder(), (class_1799)stack, value)).orElse(false);
    }

    public boolean setAndSync(Camera camera, T value) {
        return camera.map((item, stack) -> {
            if (this.set(camera.getHolder(), (class_1799)stack, value)) {
                byte[] bytes = this.encodeValue(camera.getHolder().asHolderEntity().method_56673(), value);
                Packets.sendToServer(new ActiveCameraSetSettingC2SP(this, bytes));
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean decodeAndSet(class_1799 stack, class_5455 registryAccess, byte[] bytes) {
        T value = this.decodeValue(registryAccess, bytes);
        return this.set(stack, value);
    }

    public boolean decodeAndSet(CameraHolder holder, class_1799 stack, class_5455 registryAccess, byte[] bytes) {
        T value = this.decodeValue(registryAccess, bytes);
        return this.set(holder, stack, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeValue(class_5455 registryAccess, T value) {
        class_9129 buffer = new class_9129(Unpooled.buffer(), registryAccess);
        try {
            this.component.method_57878().encode((Object)buffer, value);
            byte[] byArray = (byte[])buffer.array().clone();
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T decodeValue(class_5455 registryAccess, byte[] bytes) {
        class_9129 buffer = new class_9129(Unpooled.buffer(), registryAccess);
        try {
            buffer.method_52983(bytes);
            Object object = this.component.method_57878().decode((Object)buffer);
            return (T)object;
        }
        finally {
            buffer.release();
        }
    }
}

