/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.inventory.tooltip.PhotographTooltip;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure.world.photograph.PhotographType;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographItem
extends class_1792 {
    public PhotographItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public PhotographType getType(class_1799 stack) {
        return PhotographType.REGULAR;
    }

    public Frame getFrame(class_1799 stack) {
        return (Frame)stack.method_57825(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)Frame.EMPTY);
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        ExposureIdentifier identifier = this.getFrame(stack).identifier();
        return !identifier.isEmpty() ? Optional.of(new PhotographTooltip(List.of(new ItemAndStack(stack)))) : Optional.empty();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        Frame frame;
        @Nullable Integer generation = (Integer)stack.method_57824(Exposure.DataComponents.PHOTOGRAPH_GENERATION);
        if (generation != null && generation > 0) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)("item.exposure.photograph.generation." + generation)).method_27692(class_124.field_1080));
        }
        if ((frame = (Frame)stack.method_57824(Exposure.DataComponents.PHOTOGRAPH_FRAME)) == null) {
            return;
        }
        String photographerName = frame.photographer().name();
        if (((Boolean)Config.Client.PHOTOGRAPH_SHOW_PHOTOGRAPHER_IN_TOOLTIP.get()).booleanValue() && !photographerName.isEmpty()) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.photograph.photographer_tooltip", (Object[])new Object[]{class_2561.method_43470((String)photographerName).method_27692(class_124.field_1068)}).method_27692(class_124.field_1080));
        }
        if (((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            boolean jeiLoaded = PlatformHelper.isModLoaded("jei");
            if (!(generation != null && generation >= 2 || jeiLoaded)) {
                ClientGUI.addPhotographCopyingTooltip(stack, context, tooltipComponents, tooltipFlag);
            }
        }
        if (tooltipFlag.method_8035()) {
            String identifier = frame.identifier().map(id -> "Id: " + id, texture -> "Texture: " + String.valueOf(texture));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)identifier).method_27692(class_124.field_1063));
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        Frame frame = this.getFrame(itemInHand);
        if (frame == Frame.EMPTY || frame.identifier().isEmpty()) {
            return class_1271.method_22430((Object)itemInHand);
        }
        if (level.field_9236) {
            int slot = hand == class_1268.field_5810 ? 40 : player.method_31548().field_7545;
            ClientGUI.openPhotographsScreenFromItem(slot);
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
        }
        return class_1271.method_22427((Object)itemInHand);
    }

    public boolean method_31566(@NotNull class_1799 stack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        if (action != class_5536.field_27014) {
            return false;
        }
        if (other.method_7909() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            class_1799 stackedPhotographsStack = new class_1799((class_1935)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, stack);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, other);
            slot.method_7673(stackedPhotographsStack);
            access.method_32332(class_1799.field_8037);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }
}

