/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.inventory.ItemRenameMenu;
import io.github.mortuusars.exposure.world.item.SensitiveFilmItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import org.jetbrains.annotations.NotNull;

public class FilmRollItem
extends class_1792
implements SensitiveFilmItem {
    public static final int BAR_BLACK_AND_WHITE = class_3532.method_15353((float)0.8f, (float)0.8f, (float)0.9f);
    public static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    protected final ExposureType type;
    protected final int barColor;

    public FilmRollItem(ExposureType type, int barColor, class_1792.class_1793 properties) {
        super(properties);
        this.type = type;
        this.barColor = barColor;
    }

    @Override
    public ExposureType getType() {
        return this.type;
    }

    public boolean canAddFrame(class_1799 stack) {
        return this.getStoredFramesCount(stack) < this.getMaxFrameCount(stack);
    }

    public void addFrame(class_1799 stack, Frame frame) {
        Preconditions.checkState((this.getStoredFramesCount(stack) < this.getMaxFrameCount(stack) ? 1 : 0) != 0, (Object)("Cannot add more frames than film could fit. Size: " + this.getMaxFrameCount(stack)));
        ArrayList<Frame> frames = new ArrayList<Frame>((Collection)stack.method_57825(Exposure.DataComponents.FILM_FRAMES, Collections.emptyList()));
        frames.add(frame);
        stack.method_57379(Exposure.DataComponents.FILM_FRAMES, frames);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> list, class_1836 tooltipFlag) {
        int exposedFrames = this.getStoredFramesCount(stack);
        if (exposedFrames > 0) {
            int totalFrames = this.getMaxFrameCount(stack);
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.frame_count", (Object[])new Object[]{exposedFrames, totalFrames}).method_27692(class_124.field_1080));
        }
        this.addFrameSizeToTooltip(stack, list);
        if (tooltipFlag.method_8035()) {
            this.addPaletteToTooltip(stack, list);
            this.addStyleToTooltip(stack, list);
        }
        if (((Boolean)Config.Server.FILM_ROLL_EASY_RENAMING.get()).booleanValue()) {
            list.add((class_2561)class_2561.method_43471((String)"item.exposure.film_roll.tooltip.renaming"));
        }
        if (exposedFrames > 0 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            ClientGUI.addFilmRollDevelopingTooltip(stack, context, list, tooltipFlag);
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        if (!((Boolean)Config.Server.FILM_ROLL_EASY_RENAMING.get()).booleanValue() || !(player instanceof class_3222)) {
            return super.method_7836(level, player, usedHand);
        }
        class_3222 serverPlayer = (class_3222)player;
        final int slot = this.getMatchingSlotInInventory(player.method_31548(), player.method_5998(usedHand));
        class_3908 menuProvider = new class_3908(){

            @NotNull
            public class_2561 method_5476() {
                return class_2561.method_43471((String)"gui.exposure.item_rename.title");
            }

            @NotNull
            public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                return new ItemRenameMenu(containerId, playerInventory, slot);
            }
        };
        PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> buffer.method_53002(slot));
        return class_1271.method_22427((Object)player.method_5998(usedHand));
    }

    public int method_31571(@NotNull class_1799 stack) {
        return this.barColor;
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return this.hasFrames(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        return Math.min(1 + 12 * this.getStoredFramesCount(stack) / this.getMaxFrameCount(stack), 13);
    }

    protected int getMatchingSlotInInventory(class_1661 inventory, class_1799 stack) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).equals(stack)) continue;
            return i;
        }
        return -1;
    }
}

