/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.entity;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandSetRotationsS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandStopControllingS2CP;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.entity.CameraStandRedstoneControl;
import io.github.mortuusars.exposure.world.inventory.CameraOnStandAttachmentsMenu;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.sound.Sound;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraStandEntity
extends class_1297
implements CameraHolder {
    protected static final class_2940<Integer> DATA_ID_HURT = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DATA_ID_HURTDIR = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> DATA_ID_DAMAGE = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<class_1799> DATA_ID_CAMERA = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<Integer> DATA_ID_COOLDOWN_TIME = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DATA_ID_COOLDOWN = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DATA_ID_OPERATOR_ID = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> DATA_ID_MALFUNCTIONED = class_2945.method_12791(CameraStandEntity.class, (class_2941)class_2943.field_13323);
    protected static final Predicate<class_1297> RIDABLE_MINECARTS = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    protected CameraStandRedstoneControl redstoneControl = new CameraStandRedstoneControl(this);
    protected UUID ownerPlayerId = class_156.field_25140;

    public CameraStandEntity(class_1299<? extends CameraStandEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_ID_HURT, (Object)0);
        builder.method_56912(DATA_ID_HURTDIR, (Object)1);
        builder.method_56912(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        builder.method_56912(DATA_ID_CAMERA, (Object)class_1799.field_8037);
        builder.method_56912(DATA_ID_OPERATOR_ID, (Object)-1);
        builder.method_56912(DATA_ID_COOLDOWN_TIME, (Object)0);
        builder.method_56912(DATA_ID_COOLDOWN, (Object)0);
        builder.method_56912(DATA_ID_MALFUNCTIONED, (Object)false);
    }

    public void method_5674(class_2940<?> dataAccessor) {
        class_1799 camera;
        if (dataAccessor.equals(DATA_ID_CAMERA) && !(camera = this.getCamera()).method_7960()) {
            camera.method_27320((class_1297)this);
        }
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10569("CooldownTime", this.getCooldownTime());
        tag.method_10569("Cooldown", this.getCooldown());
        tag.method_10556("Malfunctioned", this.isMalfunctioned());
        if (!this.getCamera().method_7960()) {
            tag.method_10566("Camera", this.getCamera().method_57358((class_7225.class_7874)this.method_56673()));
        }
        this.redstoneControl.save(tag);
        if (!this.ownerPlayerId.equals(class_156.field_25140)) {
            tag.method_25927("Owner", this.ownerPlayerId);
        }
    }

    protected void method_5749(class_2487 tag) {
        this.setCooldownTime(tag.method_10550("CooldownTime"));
        this.setCooldown(tag.method_10550("Cooldown"));
        this.setMalfunctioned(tag.method_10577("Malfunctioned"));
        this.setCamera(class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)tag.method_10562("Camera")));
        this.redstoneControl.load(tag);
        if (tag.method_10573("Owner", 11)) {
            this.ownerPlayerId = tag.method_25926("Owner");
        }
    }

    public class_1799 getCamera() {
        return (class_1799)this.method_5841().method_12789(DATA_ID_CAMERA);
    }

    public void setCamera(class_1799 cameraStack) {
        if (!(this.isClientSide() || !cameraStack.method_7960() && CameraId.ofStack(this.getCamera()).matches(cameraStack))) {
            this.method_37908().method_18456().stream().filter(pl -> pl instanceof class_3222 && pl.field_7512 instanceof CameraOnStandAttachmentsMenu).forEach(pl -> ((class_3222)pl).method_7346());
        }
        this.method_5841().method_12778(DATA_ID_CAMERA, (Object)cameraStack);
    }

    public boolean isCameraActive() {
        CameraItem cameraItem;
        class_1792 class_17922 = this.getCamera().method_7909();
        return class_17922 instanceof CameraItem && (cameraItem = (CameraItem)class_17922).isActive(this.getCamera());
    }

    public Optional<class_1657> getOwnerPlayer() {
        return Optional.ofNullable(this.method_37908().method_18470(this.ownerPlayerId));
    }

    public UUID getOwnerPlayerId() {
        return this.ownerPlayerId;
    }

    public void setOwnerPlayer(class_1657 player) {
        this.ownerPlayerId = player.method_5667();
    }

    public Optional<? extends class_1657> getClosestPlayerInRange() {
        return this.method_37908().method_18456().stream().min(Comparator.comparingDouble(player -> player.method_5739((class_1297)this))).filter(this::isInRangeForPhoto);
    }

    public int getCooldownTime() {
        return (Integer)this.method_5841().method_12789(DATA_ID_COOLDOWN_TIME);
    }

    public void setCooldownTime(int cooldown) {
        this.method_5841().method_12778(DATA_ID_COOLDOWN_TIME, (Object)cooldown);
    }

    public int getCooldown() {
        return (Integer)this.method_5841().method_12789(DATA_ID_COOLDOWN);
    }

    public void setCooldown(int cooldown) {
        this.method_5841().method_12778(DATA_ID_COOLDOWN, (Object)cooldown);
    }

    public void startCooldown(int cooldown) {
        this.setCooldownTime(cooldown);
        this.setCooldown(cooldown);
    }

    public boolean isOnCooldown() {
        return this.getCooldown() > 0;
    }

    public float getCooldownPercent() {
        float cooldownTime = this.getCooldownTime();
        float cooldown = this.getCooldown();
        return class_3532.method_15363((float)(cooldown / cooldownTime), (float)0.0f, (float)1.0f);
    }

    public boolean isMalfunctioned() {
        return (Boolean)this.method_5841().method_12789(DATA_ID_MALFUNCTIONED);
    }

    public void setMalfunctioned(boolean malfunctioned) {
        this.method_5841().method_12778(DATA_ID_MALFUNCTIONED, (Object)malfunctioned);
    }

    public int getOperatorId() {
        return (Integer)this.method_5841().method_12789(DATA_ID_OPERATOR_ID);
    }

    @Nullable
    public CameraOperator operator() {
        CameraOperator operator;
        class_1297 class_12972;
        int id = this.getOperatorId();
        return id >= 0 && (class_12972 = this.method_37908().method_8469(id)) instanceof CameraOperator ? (operator = (CameraOperator)class_12972) : null;
    }

    public void setOperator(@Nullable CameraOperator operator) {
        this.method_5841().method_12778(DATA_ID_OPERATOR_ID, (Object)(operator != null ? operator.asOperatorEntity().method_5628() : -1));
    }

    public boolean isInRangeForPhoto(class_1657 player) {
        return player.method_5739((class_1297)this) < (float)((Integer)Config.Server.CAMERA_STAND_WORKING_RANGE.get()).intValue();
    }

    @Override
    public Optional<class_1657> getPlayerExecutingExposure() {
        if (((Boolean)Config.Server.CAMERA_STAND_FALLBACK_TO_OTHER_PLAYERS.get()).booleanValue()) {
            return this.getOwnerPlayer().filter(this::isInRangeForPhoto).or(this::getClosestPlayerInRange);
        }
        return this.getOwnerPlayer().filter(this::isInRangeForPhoto);
    }

    @Override
    public Optional<class_1657> getPlayerAwardedForExposure() {
        return this.getOwnerPlayer().or(this::getClosestPlayerInRange);
    }

    @Override
    @NotNull
    public class_1297 getExposureAuthorEntity() {
        return this.getOwnerPlayer().or(this::getClosestPlayerInRange).map(pl -> pl).orElse(this);
    }

    @Override
    public Optional<CameraOperator> getExposureCameraOperator() {
        return Optional.ofNullable(this.operator());
    }

    public boolean isInInteractionRange(class_1309 entity) {
        double range = entity.method_45325(class_5134.field_47759);
        return this.method_5829().method_49271(entity.method_33571()) < range * range;
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.canUse(player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"gui.exposure.camera_stand.error.in_use").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        if (this.isMalfunctioned()) {
            if (!this.isClientSide()) {
                this.setMalfunctioned(false);
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.exposure.camera_stand.malfunction_fixed"), true);
                this.method_5783(class_3417.field_22463, 0.9f, 1.3f);
                this.showRepairingParticles();
            }
            return class_1269.field_5812;
        }
        class_1799 handStack = player.method_5998(hand);
        class_1799 cameraStack = this.getCamera();
        if (handStack.method_31574(class_1802.field_8688) && !cameraStack.method_7960()) {
            this.malfunction();
            return class_1269.field_5812;
        }
        if (cameraStack.method_7960() && handStack.method_7909() instanceof CameraItem) {
            this.setCamera(handStack);
            player.method_6122(hand, class_1799.field_8037);
            if (!this.isClientSide()) {
                this.playCameraSetSound();
            }
            if (this.method_36454() == 0.0f && this.method_36455() == 0.0f) {
                this.method_36456(class_3532.method_15393((float)player.method_36454()));
                if (!this.isClientSide()) {
                    this.syncRotationToClients();
                }
            }
            return class_1269.field_5812;
        }
        if (cameraStack.method_7960()) {
            return class_1269.field_5811;
        }
        class_1792 class_17922 = cameraStack.method_7909();
        if (!(class_17922 instanceof CameraItem)) {
            return class_1269.field_5811;
        }
        CameraItem cameraItem = (CameraItem)class_17922;
        if (PlatformHelper.isCreateDeployer(player, hand)) {
            if (((Boolean)Config.Server.CREATE_DEPLOYER_STAND_HOTSWAP.get()).booleanValue()) {
                return this.handleSneakInteraction(player, hand, cameraItem, cameraStack, handStack);
            }
            return class_1269.field_21466;
        }
        if (player.method_21823()) {
            return this.handleSneakInteraction(player, hand, cameraItem, cameraStack, handStack);
        }
        this.startControlling(player, cameraItem);
        return class_1269.field_21466;
    }

    protected class_1269 handleSneakInteraction(class_1657 player, class_1268 hand, CameraItem cameraItem, class_1799 cameraStack, class_1799 handStack) {
        if (this.isOnCooldown()) {
            return class_1269.field_5814;
        }
        if (cameraItem.getShutter().isOpen(cameraStack)) {
            return class_1269.field_5814;
        }
        if (handStack.method_7960() && cameraItem.hasAttachmentsMenu()) {
            return this.openAttachmentsMenu(player, hand);
        }
        class_1269 result = cameraItem.handleStandSneakInteraction(this, player, hand, cameraStack);
        if (result == class_1269.field_5814) {
            return class_1269.field_5814;
        }
        if (result == class_1269.field_5811) {
            return cameraItem.hasAttachmentsMenu() ? this.openAttachmentsMenu(player, hand) : class_1269.field_5811;
        }
        cameraItem.getTimer().stop(cameraStack);
        this.forceUpdate();
        return result;
    }

    public boolean canUse(class_1657 player) {
        return (this.operator() == null || player.equals((Object)this.operator())) && this.method_37908().method_18456().stream().filter(pl -> !pl.equals((Object)player)).noneMatch(pl -> pl.field_7512 instanceof CameraOnStandAttachmentsMenu);
    }

    public class_1269 openAttachmentsMenu(class_1657 player, class_1268 hand) {
        class_1792 class_17922;
        if (!this.canUse(player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"gui.exposure.camera_stand.error.in_use").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        final class_1799 cameraStack = this.getCamera();
        if (cameraStack.method_7960() || !((class_17922 = cameraStack.method_7909()) instanceof CameraItem)) {
            return class_1269.field_5814;
        }
        CameraItem cameraItem = (CameraItem)class_17922;
        if (cameraItem.getShutter().isOpen(cameraStack)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.exposure.camera.camera_attachments.fail.shutter_open").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        cameraItem.getOrCreateId(cameraStack);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.setOperator((CameraOperator)serverPlayer);
            cameraItem.getTimer().stop(cameraStack);
            class_3908 menuProvider = new class_3908(){

                @NotNull
                public class_2561 method_5476() {
                    return cameraStack.method_57824(class_9334.field_49631) != null ? cameraStack.method_7964() : class_2561.method_43471((String)"container.exposure.camera");
                }

                @NotNull
                public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                    return new CameraOnStandAttachmentsMenu(containerId, playerInventory, CameraStandEntity.this);
                }
            };
            this.forceUpdate();
            PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> buffer.method_53002(this.method_5628()));
        }
        cameraItem.setDisassembled(cameraStack, true);
        Sound.play((class_1297)player, Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), class_3419.field_15248, 0.9f, 0.9f, 0.2f);
        return class_1269.field_5812;
    }

    public void startControlling(class_1657 player, CameraItem cameraItem) {
        cameraItem.activateOnStand(player, this.getCamera(), this);
        this.setOperator((CameraOperator)player);
        if (this.getOwnerPlayerId().equals(class_156.field_25140)) {
            this.setOwnerPlayer(player);
        }
        if (this.isClientSide()) {
            CameraClient.setCameraEntity(this);
            Minecrft.stopPlayerMovement();
        } else {
            this.forceUpdate();
        }
    }

    public void stopControlling() {
        CameraItem cameraItem;
        Object object = this.getCamera().method_7909();
        if (object instanceof CameraItem && (cameraItem = (CameraItem)((Object)object)).isActive(this.getCamera())) {
            cameraItem.deactivate(this, this.getCamera());
        }
        if (this.operator() != null) {
            if (this.isClientSide()) {
                CameraClient.resetCameraEntity();
            } else {
                object = this.operator();
                if (object instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)object;
                    Packets.sendToClient(new CameraStandStopControllingS2CP(this.method_5628()), serverPlayer);
                }
            }
        }
        this.setOperator(null);
        if (!this.isClientSide()) {
            this.forceUpdate();
        }
    }

    public void release() {
        class_1792 class_17922;
        if (!this.isMalfunctioned() && !this.isOnCooldown() && (class_17922 = this.getCamera().method_7909()) instanceof CameraItem) {
            CameraItem cameraItem = (CameraItem)class_17922;
            this.getPlayerExecutingExposure().ifPresentOrElse(player -> cameraItem.release(this, this.getCamera()), this::malfunction);
            this.forceUpdate();
        }
    }

    protected void malfunction() {
        if (this.getCamera().method_7960()) {
            return;
        }
        if (Config.Server.CAMERA_STAND_RANGE_MALFUNCTION.isFalse()) {
            return;
        }
        this.stopControlling();
        this.setMalfunctioned(true);
        this.method_43077(Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get());
    }

    public void method_5773() {
        block9: {
            block12: {
                CameraOperator operator;
                block11: {
                    block10: {
                        CameraItem cameraItem;
                        CameraItem cameraItem2;
                        class_1792 class_17922;
                        int cooldown;
                        super.method_5773();
                        this.travel();
                        this.checkForBoats();
                        this.checkForMinecarts();
                        this.pushEntities();
                        if (this.getHurtTime() > 0) {
                            this.setHurtTime(this.getHurtTime() - 1);
                        }
                        if (this.getDamage() > 0.0f) {
                            this.setDamage(this.getDamage() - 1.0f);
                        }
                        if ((cooldown = this.getCooldown()) > 0) {
                            this.setCooldown(cooldown - 1);
                        }
                        this.redstoneControl.tick();
                        if (!this.isClientSide() && (class_17922 = this.getCamera().method_7909()) instanceof CameraItem && (cameraItem2 = (CameraItem)class_17922).tick(this, this.getCamera())) {
                            this.forceUpdate();
                        }
                        if (this.isClientSide()) break block9;
                        operator = this.operator();
                        if (operator != null) break block10;
                        class_1792 class_17923 = this.getCamera().method_7909();
                        if (class_17923 instanceof CameraItem && (cameraItem = (CameraItem)class_17923).isActive(this.getCamera())) {
                            cameraItem.deactivate(this, this.getCamera());
                        }
                        break block9;
                    }
                    if (this.isInInteractionRange(operator.asOperatorEntity())) break block11;
                    this.stopControlling();
                    break block9;
                }
                if (this.isCameraActive()) break block9;
                if (!(operator instanceof class_1657)) break block12;
                class_1657 player = (class_1657)operator;
                if (player.field_7512 instanceof CameraOnStandAttachmentsMenu) break block9;
            }
            this.stopControlling();
        }
    }

    protected void travel() {
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.method_56990();
        if (this.method_5799() && this.method_5861(class_3486.field_15517) > (double)0.1f) {
            this.setUnderwaterMovement();
        } else if (this.method_5771() && this.method_5861(class_3486.field_15518) > (double)0.1f) {
            this.setUnderLavaMovement();
        }
        if (this.method_37908().field_9236) {
            this.field_5960 = false;
        } else {
            boolean bl = this.field_5960 = !this.method_37908().method_8587((class_1297)this, this.method_5829().method_1011(1.0E-7));
            if (this.field_5960) {
                this.method_5632(this.method_23317(), (this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0, this.method_23321());
            }
        }
        if (!this.method_24828() || this.method_18798().method_37268() > (double)1.0E-5f || (this.field_6012 + this.method_5628()) % 4 == 0) {
            this.method_5784(class_1313.field_6308, this.method_18798());
            float f = 0.98f;
            if (this.method_24828()) {
                f = this.method_37908().method_8320(this.method_23314()).method_26204().method_9499() * 0.98f;
            }
            this.method_18799(this.method_18798().method_18805((double)f, 0.98, (double)f));
            if (this.method_24828()) {
                class_243 vec32 = this.method_18798();
                if (vec32.field_1351 < 0.0) {
                    this.method_18799(vec32.method_18805(1.0, -0.5, 1.0));
                }
            }
        }
    }

    protected void setUnderwaterMovement() {
        class_243 vec3 = this.method_18798();
        this.method_18800(vec3.field_1352 * (double)0.9f, vec3.field_1351 * (double)0.23f, vec3.field_1350 * (double)0.9f);
    }

    protected void setUnderLavaMovement() {
        class_243 vec3 = this.method_18798();
        this.method_18800(vec3.field_1352 * 0.5, vec3.field_1351 * (double)0.1f, vec3.field_1350 * 0.5);
    }

    protected void checkForBoats() {
        if (!this.isClientSide() && !this.method_5765()) {
            List boats = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.4f, (double)0.2f, (double)0.4f), e -> e instanceof class_1690);
            for (class_1297 entity : boats) {
                class_1690 boat = (class_1690)entity;
                if (boat.method_5685().size() >= 2 || !boat.method_49182((class_1297)this)) continue;
                this.method_5804((class_1297)boat);
            }
        }
    }

    protected void checkForMinecarts() {
        if (!this.isClientSide() && !this.method_5765()) {
            List minecarts = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.4f, (double)0.2f, (double)0.4f), e -> {
                class_1688 cart;
                return e instanceof class_1688 && (cart = (class_1688)e).method_7518() == class_1688.class_1689.field_7674;
            });
            for (class_1297 entity : minecarts) {
                class_1688 minecart = (class_1688)entity;
                if (minecart.method_5782()) continue;
                this.method_5804((class_1297)minecart);
            }
        }
    }

    protected void pushEntities() {
        for (class_1297 entity : this.method_37908().method_8333((class_1297)this, this.method_5829(), RIDABLE_MINECARTS)) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_31481()) {
            return true;
        }
        if (this.method_5679(source)) {
            return false;
        }
        this.method_5785();
        if (!this.getCamera().method_7960()) {
            if (!this.isClientSide()) {
                @Nullable class_1542 itemEntity = this.method_5699(this.getCamera(), this.method_5751());
                if (itemEntity != null) {
                    itemEntity.method_6982(5);
                }
                this.playCameraRemoveSound();
            }
            this.setCamera(class_1799.field_8037);
            if (source.method_5530()) {
                return true;
            }
            amount = 1.0f;
        }
        if (!this.isClientSide()) {
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.method_5785();
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.method_32875((class_6880)class_5712.field_28736, source.method_5529());
            this.playHitSound();
            if (source.method_5530()) {
                this.method_31472();
                this.showBreakingParticles();
                this.playBreakSound();
            } else if (this.getDamage() > 10.0f) {
                this.destroy(source);
                this.showBreakingParticles();
                this.playBreakSound();
            }
        }
        return true;
    }

    public void setHurtTime(int hurtTime) {
        this.field_6011.method_12778(DATA_ID_HURT, (Object)hurtTime);
    }

    public void setHurtDir(int hurtDir) {
        this.field_6011.method_12778(DATA_ID_HURTDIR, (Object)hurtDir);
    }

    public void setDamage(float damage) {
        this.field_6011.method_12778(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DATA_ID_DAMAGE)).floatValue();
    }

    public int getHurtTime() {
        return (Integer)this.field_6011.method_12789(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return (Integer)this.field_6011.method_12789(DATA_ID_HURTDIR);
    }

    protected void destroy(class_1282 source) {
        this.destroy(this.getDropItem());
    }

    public void destroy(class_1792 dropItem) {
        this.method_5768();
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1799 itemStack = new class_1799((class_1935)dropItem);
            itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
            this.method_5699(itemStack, 0.5f);
        }
    }

    protected void showBreakingParticles() {
        if (this.method_37908() instanceof class_3218) {
            ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564()), this.method_23317(), this.method_23323(0.25), this.method_23321(), 6, (double)(this.method_17681() / 6.0f), (double)(this.method_17682() / 6.0f), (double)(this.method_17681() / 6.0f), 0.05);
        }
    }

    protected void showRepairingParticles() {
        if (this.method_37908() instanceof class_3218) {
            ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10312.method_9564()), this.method_23317(), this.method_23323(0.75), this.method_23321(), 4, (double)(this.method_17681() / 8.0f), (double)(this.method_17682() / 8.0f), (double)(this.method_17681() / 8.0f), 0.05);
        }
    }

    protected class_1792 getDropItem() {
        return Exposure.Items.CAMERA_STAND.get();
    }

    public boolean method_5863() {
        return true;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getDropItem());
    }

    protected double method_7490() {
        return 0.08;
    }

    @NotNull
    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public void playPlaceSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Exposure.SoundEvents.CAMERA_STAND_PLACE.get(), this.method_5634(), 0.8f, 1.0f);
    }

    public void playHitSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Exposure.SoundEvents.CAMERA_STAND_HIT.get(), this.method_5634(), 0.8f, 1.0f);
    }

    public void playBreakSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Exposure.SoundEvents.CAMERA_STAND_BREAK.get(), this.method_5634(), 1.0f, 1.0f);
    }

    public void playCameraSetSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Exposure.SoundEvents.CAMERA_STAND_SET_CAMERA.get(), this.method_5634(), 0.8f, 1.0f);
    }

    public void playCameraRemoveSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Exposure.SoundEvents.CAMERA_STAND_REMOVE_CAMERA.get(), this.method_5634(), 0.8f, 1.0f);
    }

    public void forceUpdate() {
        this.method_5841().method_49743(DATA_ID_CAMERA, (Object)this.getCamera(), true);
    }

    public boolean isClientSide() {
        return this.method_37908().field_9236;
    }

    public boolean method_5787() {
        class_1657 player;
        CameraOperator cameraOperator = this.operator();
        return cameraOperator instanceof class_1657 && (player = (class_1657)cameraOperator).method_7340() || super.method_5787();
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int steps) {
        this.method_5814(x, y, z);
    }

    public void syncRotationToClientsIfNeeded() {
        if (this.isClientSide()) {
            return;
        }
        if (this.operator() != null || this.field_6012 % 10 == 0) {
            this.syncRotationToClients();
        }
    }

    public void syncRotationToClients() {
        Packets.sendToClients(new CameraStandSetRotationsS2CP(this.method_5628(), this.method_36454(), this.method_36455()), pl -> !pl.equals((Object)this.operator()));
    }
}

