/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Levels(int shadows, int midtones, int highlights, int black, int white) {
    public static final Levels EMPTY = new Levels(0, 128, 255, 0, 255);
    public static final Codec<Levels> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("shadows", (Object)0).forGetter(Levels::shadows), (App)Codec.INT.optionalFieldOf("midtones", (Object)128).forGetter(Levels::midtones), (App)Codec.INT.optionalFieldOf("highlights", (Object)255).forGetter(Levels::highlights), (App)Codec.INT.optionalFieldOf("black", (Object)0).forGetter(Levels::black), (App)Codec.INT.optionalFieldOf("white", (Object)255).forGetter(Levels::white)).apply((Applicative)instance, Levels::new));
    public static final class_9139<class_2540, Levels> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48550, Levels::shadows, (class_9139)class_9135.field_48550, Levels::midtones, (class_9139)class_9135.field_48550, Levels::highlights, (class_9139)class_9135.field_48550, Levels::black, (class_9139)class_9135.field_48550, Levels::white, Levels::new);

    public Levels {
        Levels.checkRange(shadows, "shadows");
        Levels.checkRange(midtones, "midtones");
        Levels.checkRange(highlights, "highlights");
        Levels.checkRange(black, "black");
        Levels.checkRange(white, "white");
    }

    private static void checkRange(int value, String name) {
        Preconditions.checkArgument((value >= 0 && value <= 255 ? 1 : 0) != 0, (Object)(name + " '" + value + "' is not valid. 0-255."));
    }

    @Override
    public String toString() {
        return "%s, %s, %s | %s, %s".formatted(this.shadows, this.midtones, this.highlights, this.black, this.white);
    }
}

