/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ShutterSpeed
implements class_3542 {
    public static final ShutterSpeed DEFAULT = new ShutterSpeed("1/60");
    public static final Codec<ShutterSpeed> CODEC = Codec.STRING.comapFlatMap(str -> {
        try {
            return DataResult.success((Object)new ShutterSpeed((String)str));
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }, ShutterSpeed::getNotation);
    public static final class_9139<ByteBuf, ShutterSpeed> STREAM_CODEC = class_9135.field_48554.method_56432(ShutterSpeed::new, ShutterSpeed::getNotation);
    private final float valueMilliseconds;
    private final String notation;

    public ShutterSpeed(String notation) {
        notation = notation.trim();
        if (notation.endsWith("\"")) {
            this.valueMilliseconds = Integer.parseInt(notation.replace("\"", "")) * 1000;
            this.notation = notation;
        } else if (notation.contains("1/")) {
            this.valueMilliseconds = 1.0f / (float)Integer.parseInt(notation.replace("1/", "")) * 1000.0f;
            this.notation = notation;
        } else {
            throw new IllegalArgumentException("'%s' is not a valid shutter speed. Format should be 1/60, 2\", etc.".formatted(notation));
        }
    }

    public String getNotation() {
        return this.notation;
    }

    public float getDurationMilliseconds() {
        return this.valueMilliseconds;
    }

    public int getDurationTicks() {
        return Math.max(1, (int)(this.valueMilliseconds / 50.0f));
    }

    public boolean shouldCauseTickingSound() {
        return this.valueMilliseconds > 999.0f;
    }

    public float getStopsDifference(ShutterSpeed relative) {
        return (float)(Math.log(this.valueMilliseconds / relative.getDurationMilliseconds()) / Math.log(2.0));
    }

    public float getStops() {
        return this.getStopsDifference(DEFAULT);
    }

    public float getBrightness() {
        return 1.0f + this.getStops() * 0.2f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShutterSpeed that = (ShutterSpeed)o;
        return Float.compare(this.valueMilliseconds, that.valueMilliseconds) == 0 && Objects.equals(this.notation, that.notation);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.valueMilliseconds), this.notation);
    }

    @NotNull
    public String method_15434() {
        return this.getNotation();
    }
}

