/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.block.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.world.block.LightroomBlock;
import io.github.mortuusars.exposure.world.block.entity.Lightroom;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.inventory.LightroomMenu;
import io.github.mortuusars.exposure.world.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.LevelUtil;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.lightroom.PrintingMode;
import io.github.mortuusars.exposure.world.lightroom.PrintingProcess;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlockEntity
extends class_2624
implements class_1278 {
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int CONTAINER_DATA_PROGRESS_ID = 0;
    public static final int CONTAINER_DATA_PRINT_TIME_ID = 1;
    public static final int CONTAINER_DATA_SELECTED_FRAME_ID = 2;
    protected final class_3913 containerData = new class_3913(){

        public int method_17390(int id) {
            return switch (id) {
                case 0 -> LightroomBlockEntity.this.progress;
                case 1 -> LightroomBlockEntity.this.printTime;
                case 2 -> LightroomBlockEntity.this.getSelectedFrameIndex();
                default -> 0;
            };
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                LightroomBlockEntity.this.progress = value;
            } else if (id == 1) {
                LightroomBlockEntity.this.printTime = value;
            } else if (id == 2) {
                LightroomBlockEntity.this.setSelectedFrameIndex(value);
            }
            LightroomBlockEntity.this.method_5431();
        }

        public int method_17389() {
            return 3;
        }
    };
    public static final Map<class_1767, Integer> DYE_SLOTS = Map.of(class_1767.field_7955, 2, class_1767.field_7958, 3, class_1767.field_7947, 4, class_1767.field_7963, 5);
    protected class_2371<class_1799> items = class_2371.method_10213((int)7, (Object)class_1799.field_8037);
    protected UUID lastPlayerId = class_156.field_25140;
    protected int selectedFrameIndex;
    protected int progress;
    protected int printTime;
    protected int storedExperience;
    protected boolean advanceFrame;
    protected PrintingMode printingMode = PrintingMode.REGULAR;
    @Nullable
    protected Frame selectedFrame;

    public LightroomBlockEntity(class_2338 pos, class_2680 blockState) {
        super(Exposure.BlockEntityTypes.LIGHTROOM.get(), pos, blockState);
    }

    public static <T extends class_2586> void serverTick(class_1937 ignoredLevel, class_2338 ignoredBlockPos, class_2680 ignoredBlockState, T blockEntity) {
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            lightroomBlockEntity.tick();
        }
    }

    protected void tick() {
        if (this.printTime <= 0 || !this.canPrint()) {
            this.stopPrintingProcess();
            return;
        }
        if (this.progress < this.printTime) {
            ++this.progress;
            if (this.progress % 55 == 0 && this.printTime - this.progress > 12) {
                this.playPrintingSound();
            }
            return;
        }
        @Nullable Frame frame = this.getSelectedFrame();
        Preconditions.checkState((frame != null ? 1 : 0) != 0, (Object)"Frame cannot be null here because of 'canPrint' check. If it is - something went wrong.");
        PrintingProcess process = this.getPrintingProcess(frame);
        this.printFrame(frame, process, true);
        this.stopPrintingProcess();
    }

    public void setLastPlayer(class_1657 player) {
        this.lastPlayerId = player.method_5667();
    }

    public float getProgressPercentage() {
        if (this.progress < 1 || this.printTime < 1) {
            return 0.0f;
        }
        return (float)this.progress / (float)this.printTime;
    }

    public boolean isPrinting() {
        return this.field_11863 != null && (Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)LightroomBlock.PRINTING) != false;
    }

    public boolean isAdvancingFrameOnPrint() {
        return this.advanceFrame;
    }

    protected boolean canEjectFilm() {
        class_2350 facing;
        if (this.field_11863 == null || this.field_11863.field_9236 || this.method_5438(0).method_7960()) {
            return false;
        }
        class_2338 pos = this.method_11016();
        return !this.field_11863.method_8320(pos.method_10093(facing = (class_2350)this.field_11863.method_8320(pos).method_11654((class_2769)LightroomBlock.FACING))).method_26225();
    }

    protected void ejectFilm() {
        if (this.field_11863 == null || this.field_11863.field_9236 || this.method_5438(0).method_7960()) {
            return;
        }
        class_2338 pos = this.method_11016();
        class_2350 facing = (class_2350)this.field_11863.method_8320(pos).method_11654((class_2769)LightroomBlock.FACING);
        class_1799 filmStack = this.method_5434(0, 1);
        class_2382 normal = facing.method_10163();
        class_243 point = class_243.method_24953((class_2382)pos).method_1031((double)((float)normal.method_10263() * 0.75f), (double)((float)normal.method_10264() * 0.75f), (double)((float)normal.method_10260() * 0.75f));
        class_1542 itemEntity = new class_1542(this.field_11863, point.field_1352, point.field_1351, point.field_1350, filmStack);
        itemEntity.method_18800((double)((float)normal.method_10263() * 0.05f), (double)((float)normal.method_10264() * 0.05f + 0.15f), (double)((float)normal.method_10260() * 0.05f));
        itemEntity.method_6988();
        this.field_11863.method_8649((class_1297)itemEntity);
        this.inventoryContentsChanged(0);
    }

    public int getSelectedFrameIndex() {
        return this.selectedFrameIndex;
    }

    public void setSelectedFrameIndex(int index) {
        DevelopedFilmItem developedFilm;
        class_1799 filmStack;
        class_1792 class_17922;
        if (this.selectedFrameIndex != index) {
            this.selectedFrameIndex = index;
            this.stopPrintingProcess();
        }
        this.selectedFrame = (class_17922 = (filmStack = this.method_5438(0)).method_7909()) instanceof DevelopedFilmItem && (developedFilm = (DevelopedFilmItem)class_17922).hasFrameAt(filmStack, this.getSelectedFrameIndex()) ? (Frame)developedFilm.getStoredFrames(filmStack).get(this.getSelectedFrameIndex()) : null;
    }

    public PrintingMode getActualPrintingMode() {
        return this.isRefracted() ? this.printingMode : PrintingMode.REGULAR;
    }

    public PrintingMode getPrintingMode() {
        return this.printingMode;
    }

    public void setPrintMode(PrintingMode printingMode) {
        this.printingMode = printingMode;
        this.stopPrintingProcess();
        this.method_5431();
    }

    @Nullable
    public Frame getSelectedFrame() {
        return this.selectedFrame;
    }

    public boolean isRefracted() {
        return this.field_11863 != null && (Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)LightroomBlock.REFRACTED) != false;
    }

    public void startPrintingProcess(boolean advanceFrameOnFinish) {
        class_2680 state;
        if (!this.canPrint()) {
            return;
        }
        @Nullable Frame frame = this.getSelectedFrame();
        Preconditions.checkState((frame != null ? 1 : 0) != 0, (Object)"Frame cannot be null here because of 'canPrint' check. If it is - something went wrong.");
        PrintingProcess process = this.getPrintingProcess(frame);
        int time = process.getPrintTime();
        this.printTime = this.isRefracted() && process.isRegular() ? time * 3 : time;
        this.advanceFrame = advanceFrameOnFinish;
        if (this.field_11863 != null && (state = this.field_11863.method_8320(this.method_11016())).method_26204() instanceof LightroomBlock && !((Boolean)state.method_11654((class_2769)LightroomBlock.PRINTING)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)LightroomBlock.PRINTING, (Comparable)Boolean.valueOf(true)), 2);
            this.playPrintingStartedSound();
        }
    }

    public void stopPrintingProcess() {
        class_2680 state;
        this.progress = 0;
        this.printTime = 0;
        this.advanceFrame = false;
        if (this.field_11863 != null && (state = this.field_11863.method_8320(this.method_11016())).method_26204() instanceof LightroomBlock && ((Boolean)state.method_11654((class_2769)LightroomBlock.PRINTING)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)LightroomBlock.PRINTING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean canPrint() {
        @Nullable Frame frame = this.getSelectedFrame();
        if (frame == null) {
            return false;
        }
        class_1799 paperStack = this.method_5438(1);
        if (paperStack.method_7960()) {
            return false;
        }
        PrintingProcess process = this.getPrintingProcess(frame);
        return this.isPaperValidForPrint(frame, process) && this.canOutputToResultSlot(frame, process) && this.hasDyesForPrint(frame, process) && this.hasSufficientLightLevel();
    }

    public boolean hasSufficientLightLevel() {
        if (this.field_11863 == null) {
            return false;
        }
        int requiredLightLevel = (Integer)Config.Server.LIGHTROOM_LIGHT_REQUIREMENT.get();
        class_2338 above = this.method_11016().method_10084();
        if (this.isRefracted()) {
            return LevelUtil.getLightLevelAt(this.field_11863, above.method_10084()) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.field_11863, above.method_10093(class_2350.field_11043)) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.field_11863, above.method_10093(class_2350.field_11034)) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.field_11863, above.method_10093(class_2350.field_11035)) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.field_11863, above.method_10093(class_2350.field_11039)) >= requiredLightLevel;
        }
        return LevelUtil.getLightLevelAt(this.field_11863, above) >= requiredLightLevel;
    }

    public boolean canPrintInCreativeMode() {
        @Nullable Frame frame = this.getSelectedFrame();
        if (frame == null) {
            return false;
        }
        PrintingProcess process = this.getPrintingProcess(frame);
        return this.canOutputToResultSlot(frame, process);
    }

    protected PrintingProcess getPrintingProcess(@NotNull Frame frame) {
        return switch (this.getActualPrintingMode()) {
            default -> throw new MatchException(null, null);
            case PrintingMode.REGULAR -> PrintingProcess.fromExposureType(frame.type());
            case PrintingMode.CHROMATIC -> PrintingProcess.fromChromaticStep(this.getChromaticStep(this.method_5438(1)));
        };
    }

    protected boolean isPaperValidForPrint(Frame frame, PrintingProcess process) {
        class_1799 paperStack = this.method_5438(1);
        if (paperStack.method_7960()) {
            return false;
        }
        if (process.isChromatic()) {
            ChromaticSheetItem chromaticSheet;
            class_1792 class_17922;
            return paperStack.method_31573(Exposure.Tags.Items.PHOTO_PAPERS) || (class_17922 = paperStack.method_7909()) instanceof ChromaticSheetItem && !(chromaticSheet = (ChromaticSheetItem)class_17922).canCombine(paperStack);
        }
        return paperStack.method_31573(Exposure.Tags.Items.PHOTO_PAPERS);
    }

    protected boolean hasDyesForPrint(Frame frame, PrintingProcess process) {
        for (class_1767 requiredDye : process.getRequiredDyes()) {
            int slotIndex = DYE_SLOTS.get(requiredDye);
            if (!this.method_5438(slotIndex).method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean canOutputToResultSlot(Frame frame, PrintingProcess process) {
        StackedPhotographsItem stackedPhotographsItem;
        class_1792 class_17922;
        class_1799 resultStack = this.method_5438(6);
        if (process.isChromatic()) {
            return resultStack.method_7960();
        }
        return resultStack.method_7960() || resultStack.method_7909() instanceof PhotographItem || (class_17922 = resultStack.method_7909()) instanceof StackedPhotographsItem && (stackedPhotographsItem = (StackedPhotographsItem)class_17922).canAddPhotograph(resultStack);
    }

    protected int getChromaticStep(class_1799 paper) {
        class_1792 class_17922 = paper.method_7909();
        if (!(class_17922 instanceof ChromaticSheetItem)) {
            return 0;
        }
        ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)class_17922;
        return chromaticSheet.getLayers(paper).size();
    }

    protected void printFrame(Frame frame, PrintingProcess process, boolean consumeIngredients) {
        class_1799 printResult = this.createPrintResult(frame, process);
        this.putPrintResultInOutputSlot(printResult);
        if (consumeIngredients) {
            this.consumePrintIngredients(frame, process);
            this.awardExperienceForPrint(frame, process, printResult);
        }
        this.onFramePrinted(frame, process, printResult);
    }

    public void printFrameInCreative() {
        @Nullable Frame frame = this.getSelectedFrame();
        if (frame == null) {
            Exposure.LOGGER.error("Cannot creatively print a frame: No frame is selected.");
            return;
        }
        PrintingProcess process = this.getPrintingProcess(frame);
        this.printFrame(frame, process, false);
        if (this.method_5438(1).method_7909() instanceof ChromaticSheetItem) {
            this.method_5438(1).method_7934(1);
            this.method_5431();
        }
    }

    protected class_1799 createPrintResult(Frame frame, PrintingProcess process) {
        if (process.isChromatic()) {
            class_1799 paperStack = this.method_5438(1);
            class_1799 chromaticStack = paperStack.method_7909() instanceof ChromaticSheetItem ? paperStack.method_7972() : new class_1799((class_1935)Exposure.Items.CHROMATIC_SHEET.get());
            ChromaticSheetItem chromaticItem = (ChromaticSheetItem)chromaticStack.method_7909();
            chromaticItem.addLayer(chromaticStack, frame);
            @Nullable class_3222 player = this.getLastOrClosestPlayer();
            if (chromaticItem.canCombine(chromaticStack)) {
                if (player != null) {
                    return chromaticItem.combineIntoPhotograph(player, chromaticStack, true);
                }
                class_2487 tag = new class_2487();
                tag.method_10556("printed", true);
                chromaticStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            }
            return chromaticStack;
        }
        class_1799 photographStack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
        photographStack.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
        photographStack.method_57379(Exposure.DataComponents.PHOTOGRAPH_TYPE, (Object)frame.type());
        return photographStack;
    }

    @Nullable
    protected class_3222 getLastOrClosestPlayer() {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1657 class_16572 = serverLevel.method_18470(this.lastPlayerId);
        if (class_16572 instanceof class_3222) {
            class_3222 lastPlayer = (class_3222)class_16572;
            return lastPlayer;
        }
        class_2338 pos = this.method_11016();
        return serverLevel.method_18456().stream().min(Comparator.comparingDouble(pl -> pl.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))).orElse(null);
    }

    protected void putPrintResultInOutputSlot(class_1799 printResult) {
        class_1799 resultStack = this.method_5438(6);
        if (resultStack.method_7960()) {
            resultStack = printResult;
        } else if (resultStack.method_7909() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            class_1799 newStackedPhotographs = new class_1799((class_1935)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, resultStack);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, printResult);
            resultStack = newStackedPhotographs;
        } else {
            class_1792 class_17922 = resultStack.method_7909();
            if (class_17922 instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)class_17922;
                stackedPhotographsItem.addPhotographOnTop(resultStack, printResult);
            } else {
                Exposure.LOGGER.error("Unexpected item in result slot: {}", (Object)resultStack);
                return;
            }
        }
        this.method_5447(6, resultStack);
    }

    protected void consumePrintIngredients(Frame frame, PrintingProcess process) {
        this.method_5438(1).method_7934(1);
        process.getRequiredDyes().forEach(dye -> this.method_5438(DYE_SLOTS.get(dye)).method_7934(1));
        this.method_5431();
    }

    protected void awardExperienceForPrint(Frame frame, PrintingProcess process, class_1799 result) {
        int xp = process.getExperiencePerPrint();
        if (xp > 0) {
            float variability = ThreadLocalRandom.current().nextFloat() * 0.3f + 1.0f;
            int variableXp = (int)Math.max(1.0, Math.ceil((float)xp * variability));
            this.storedExperience += variableXp;
        }
    }

    protected void onFramePrinted(Frame frame, PrintingProcess process, class_1799 result) {
        class_3222 class_32222;
        if (process.isRegular()) {
            frame.identifier().ifId(id -> ExposureServer.exposureRepository().update((String)id, exposure -> exposure.withTag((Function<ExposureData.Tag, ExposureData.Tag>)((Function)ExposureData.Tag::setPrinted))));
        }
        if ((class_32222 = this.getLastOrClosestPlayer()) instanceof class_3222) {
            class_3222 player = class_32222;
            Exposure.CriteriaTriggers.FRAME_PRINTED.get().trigger(player, this.method_11016(), frame, result);
        }
        if (this.advanceFrame) {
            this.advanceFrame();
        }
        this.playPrintingFinishedSound();
    }

    protected void advanceFrame() {
        ItemAndStack film = new ItemAndStack(this.method_5438(0));
        int frames = ((DevelopedFilmItem)film.getItem()).getStoredFramesCount(film.getItemStack());
        if (this.getSelectedFrameIndex() >= frames - 1) {
            if (this.canEjectFilm()) {
                this.ejectFilm();
            }
        } else {
            this.setSelectedFrameIndex(this.getSelectedFrameIndex() + 1);
            this.method_5431();
        }
    }

    public void dropStoredExperience(@Nullable class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.storedExperience > 0) {
                class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)this.method_11016()), (int)this.storedExperience);
                this.storedExperience = 0;
                this.method_5431();
            }
        }
    }

    protected void playPrintingStartedSound() {
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), class_3419.field_15245, 1.0f, this.field_11863.method_8409().method_43057() * 0.3f + 1.0f);
        }
    }

    protected void playPrintingSound() {
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), class_3419.field_15245, 1.0f, this.field_11863.method_8409().method_43057() * 0.3f + 1.0f);
        }
    }

    protected void playPrintingFinishedSound() {
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.8f, 1.0f);
        }
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.exposure.lightroom");
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new LightroomMenu(containerId, inventory, this, this.containerData);
    }

    public boolean isItemValidForSlot(int slot, class_1799 stack) {
        if (slot == 0) {
            return stack.method_7909() instanceof DevelopedFilmItem;
        }
        if (slot == 2) {
            return stack.method_31573(Exposure.Tags.Items.CYAN_PRINTING_DYES);
        }
        if (slot == 3) {
            return stack.method_31573(Exposure.Tags.Items.MAGENTA_PRINTING_DYES);
        }
        if (slot == 4) {
            return stack.method_31573(Exposure.Tags.Items.YELLOW_PRINTING_DYES);
        }
        if (slot == 5) {
            return stack.method_31573(Exposure.Tags.Items.BLACK_PRINTING_DYES);
        }
        if (slot == 1) {
            ChromaticSheetItem chromatic;
            class_1792 class_17922;
            return stack.method_31573(Exposure.Tags.Items.PHOTO_PAPERS) || (class_17922 = stack.method_7909()) instanceof ChromaticSheetItem && (chromatic = (ChromaticSheetItem)class_17922).getLayers(stack).size() < 3;
        }
        if (slot == 6) {
            return stack.method_7909() instanceof PhotographItem || stack.method_7909() instanceof StackedPhotographsItem || stack.method_7909() instanceof ChromaticSheetItem;
        }
        return false;
    }

    protected void inventoryContentsChanged(int slot) {
        if (slot == 0) {
            this.setSelectedFrameIndex(0);
        }
        this.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 face) {
        return Lightroom.ALL_SLOTS;
    }

    public boolean method_5492(int index, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return false;
        }
        return this.method_5437(index, itemStack);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index != 6 && this.isItemValidForSlot(index, stack) && super.method_5437(index, stack);
    }

    public boolean method_5493(int index, @NotNull class_1799 pStack, @NotNull class_2350 direction) {
        for (int outputSlot : Lightroom.OUTPUT_SLOTS) {
            if (index != outputSlot) continue;
            return true;
        }
        return false;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        if (tag.method_10573("Inventory", 10)) {
            class_2487 inventory = tag.method_10562("Inventory");
            class_2499 itemsList = inventory.method_10554("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                class_2487 itemTag = itemsList.method_10602(i);
                int slot = itemTag.method_10550("Slot");
                if (slot < 0 || slot >= this.items.size()) continue;
                class_1799.method_57360((class_7225.class_7874)registries, (class_2520)itemTag).ifPresent(stack -> this.items.set(slot, stack));
            }
        }
        this.setSelectedFrameIndex(tag.method_10550("SelectedFrame"));
        this.progress = tag.method_10550("Progress");
        this.printTime = tag.method_10550("PrintTime");
        this.storedExperience = tag.method_10550("PrintedPhotographsCount");
        this.advanceFrame = tag.method_10577("AdvanceFrame");
        this.printingMode = PrintingMode.fromStringOrDefault(tag.method_10558("PrintMode"), PrintingMode.REGULAR);
        if (tag.method_10573("LastPlayerId", 11)) {
            this.lastPlayerId = tag.method_25926("LastPlayerId");
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        if (this.getSelectedFrameIndex() > 0) {
            tag.method_10569("SelectedFrame", this.getSelectedFrameIndex());
        }
        if (this.progress > 0) {
            tag.method_10569("Progress", this.progress);
        }
        if (this.printTime > 0) {
            tag.method_10569("PrintTime", this.printTime);
        }
        if (this.storedExperience > 0) {
            tag.method_10569("PrintedPhotographsCount", this.storedExperience);
        }
        if (this.advanceFrame) {
            tag.method_10556("AdvanceFrame", true);
        }
        if (this.printingMode != PrintingMode.REGULAR) {
            tag.method_10582("PrintMode", this.printingMode.method_15434());
        }
        if (!this.lastPlayerId.equals(class_156.field_25140)) {
            tag.method_25927("LastPlayerId", this.lastPlayerId);
        }
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    public int method_5439() {
        return 7;
    }

    public boolean method_5442() {
        return this.method_11282().stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.method_11282().get(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.method_11282(), (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.inventoryContentsChanged(slot);
        }
        return itemStack;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.method_11282(), (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.method_11282().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.inventoryContentsChanged(slot);
    }

    public void method_5448() {
        this.method_11282().clear();
        this.inventoryContentsChanged(-1);
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }
}

