/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import io.github.mortuusars.exposure.util.color.Color;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class HSBEffect
implements PixelEffect {
    protected final float h;
    protected final float s;
    protected final float b;

    public HSBEffect(float h, float s, float b) {
        Preconditions.checkArgument((h >= -1.0f && h <= 1.0f ? 1 : 0) != 0, (Object)"h must be in -1 to 1 range.");
        Preconditions.checkArgument((s >= -1.0f && s <= 1.0f ? 1 : 0) != 0, (Object)"s must be in -1 to 1 range.");
        Preconditions.checkArgument((b >= -1.0f && b <= 1.0f ? 1 : 0) != 0, (Object)"b must be in -1 to 1 range.");
        this.h = h;
        this.s = s;
        this.b = b;
    }

    @Override
    public String getIdentifier() {
        return "hsb-h%s-s%s-b%s".formatted(Float.valueOf(this.h), Float.valueOf(this.s), Float.valueOf(this.b));
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = class_5253.class_5254.method_27762((int)colorARGB);
        int red = class_5253.class_5254.method_27765((int)colorARGB);
        int green = class_5253.class_5254.method_27766((int)colorARGB);
        int blue = class_5253.class_5254.method_27767((int)colorARGB);
        float[] hsb = Color.HSB.RGBtoHSB(red, green, blue);
        hsb[0] = (hsb[0] + this.h) % 1.0f;
        if (hsb[0] < 0.0f) {
            hsb[0] = hsb[0] + 1.0f;
        }
        hsb[1] = class_3532.method_15363((float)(hsb[1] * (this.s + 1.0f)), (float)0.0f, (float)1.0f);
        hsb[2] = class_3532.method_15363((float)(hsb[2] * (this.b + 1.0f)), (float)0.0f, (float)1.0f);
        return alpha << 24 | Color.HSB.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }
}

