/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.camera.button;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;

public class FrameCounterButton
extends class_344 {
    protected final int secondaryFontColor;
    protected final int mainFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_MAIN_COLOR);

    public FrameCounterButton(int x, int y, int width, int height, class_8666 sprites) {
        super(x, y, width, height, sprites, button -> {});
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        class_5250 tooltipComponent = class_2561.method_43471((String)"gui.exposure.camera_controls.film_frame_counter.tooltip");
        if (!this.cameraHasFilmRoll()) {
            tooltipComponent.method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.camera_controls.film_frame_counter.tooltip.no_film").method_27696(class_2583.field_24360.method_36139(14508887)));
        }
        this.method_47400(class_7919.method_47407((class_2561)tooltipComponent));
        super.method_48579(guiGraphics, mouseX, mouseY, pPartialTick);
        String text = this.createText();
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        int xPos = 15 + (27 - textWidth) / 2;
        guiGraphics.method_51433(font, text, this.method_46426() + xPos, this.method_46427() + 8, this.secondaryFontColor, false);
        guiGraphics.method_51433(font, text, this.method_46426() + xPos, this.method_46427() + 7, this.mainFontColor, false);
    }

    protected String createText() {
        return Minecrft.player().getActiveExposureCameraOptional().map(camera -> {
            class_1792 patt0$temp;
            class_1799 filmStack = Attachment.FILM.get(camera.getItemStack()).getForReading();
            if (filmStack.method_7960() || !((patt0$temp = filmStack.method_7909()) instanceof FilmRollItem)) {
                return "-";
            }
            FilmRollItem filmItem = (FilmRollItem)patt0$temp;
            int exposedFrames = filmItem.getStoredFrames(filmStack).size();
            int totalFrames = filmItem.getMaxFrameCount(filmStack);
            return exposedFrames + "/" + totalFrames;
        }).orElse("-");
    }

    protected boolean cameraHasFilmRoll() {
        return Minecrft.player().getActiveExposureCameraOptional().map(camera -> Attachment.FILM.isPresent(camera.getItemStack())).orElse(false);
    }
}

