/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.album;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumGUI;
import io.github.mortuusars.exposure.client.gui.screen.album.ChildPhotographScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.PhotographSlotWidget;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.gui.screen.element.TextBlock;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.util.Side;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.component.album.AlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumPage;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class AlbumViewScreen
extends class_437 {
    protected final Pager pager = new Pager().setChangeSound(new SoundEffect(() -> class_3417.field_17481)).onPageChanged(this::onSpreadChanged);
    protected final KeyBindings keyBindings;
    protected final List<Page> pages;
    protected AlbumAccess albumAccess;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;

    public AlbumViewScreen(AlbumAccess albumAccess) {
        super((class_2561)class_2561.method_43473());
        KeyBinding[] keyBindingArray = new KeyBinding[5];
        keyBindingArray[0] = Key.press(Minecrft.options().field_1822).executes(() -> ((AlbumViewScreen)this).method_25419());
        keyBindingArray[1] = Key.press(263).or(Key.press(65)).executes(this.pager::previousPage);
        keyBindingArray[2] = Key.press(262).or(Key.press(68)).executes(this.pager::nextPage);
        keyBindingArray[3] = Key.release(263).or(Key.press(65)).executes(this.pager::resetCooldown);
        keyBindingArray[4] = Key.release(262).or(Key.press(68)).executes(this.pager::resetCooldown);
        this.keyBindings = KeyBindings.of(keyBindingArray);
        this.pages = new ArrayList<Page>();
        this.albumAccess = albumAccess;
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        this.imageWidth = 298;
        this.imageHeight = 188;
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.pages.clear();
        Page leftPage = this.createPage(Side.LEFT, 0);
        this.pages.add(leftPage);
        class_344 previousPageButton = new class_344(this.leftPos + 12, this.topPos + 164, 13, 15, AlbumGUI.PREVIOUS_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        previousPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.previous_page")));
        this.method_37063((class_364)previousPageButton);
        Page rightPage = this.createPage(Side.RIGHT, 140);
        this.pages.add(rightPage);
        class_344 nextPageButton = new class_344(this.leftPos + 273, this.topPos + 164, 13, 15, AlbumGUI.NEXT_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        nextPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.next_page")));
        this.method_37063((class_364)nextPageButton);
        int spreadsCount = (int)Math.ceil((float)this.albumAccess.pages().size() / 2.0f);
        this.pager.setPagesCount(spreadsCount).setPreviousPageButton((class_4264)previousPageButton).setNextPageButton((class_4264)nextPageButton);
    }

    protected Page createPage(Side side, int xOffset) {
        int x = this.leftPos + xOffset;
        int y = this.topPos;
        PhotographSlotWidget photographWidget = new PhotographSlotWidget(this, x + 25, y + 21, 108, 108, () -> this.getPage(side).orElse(PageContent.EMPTY).photograph()).editable(false).primaryAction(widget -> this.inspectPhotograph(widget.getPhotograph()));
        this.method_37063((class_364)photographWidget);
        TextBlock noteWidget = new TextBlock(this.field_22793, x + 22, y + 133, 114, 27, this.getPage(side).orElse(PageContent.EMPTY).note(), this::method_25430);
        noteWidget.fontColor = Config.getColor(Config.Client.ALBUM_FONT_MAIN_COLOR);
        noteWidget.alignment = HorizontalAlignment.CENTER;
        noteWidget.drawShadow = false;
        return new Page(side, photographWidget, noteWidget);
    }

    public List<PageContent> getPages() {
        return this.albumAccess.pages();
    }

    public Optional<PageContent> getPage(int pageIndex) {
        if (pageIndex <= this.getPages().size() - 1) {
            return Optional.ofNullable(this.getPages().get(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<PageContent> getPage(Side side) {
        return this.getPage(this.getCurrentSpreadIndex() * 2 + side.getIndex());
    }

    public int getCurrentSpreadIndex() {
        return this.pager.getPage();
    }

    protected void onSpreadChanged(int oldSpread, int newSpread) {
        this.forEachPage(page -> {
            class_2561 note = this.getPage(page.side).orElse(PageContent.EMPTY).note();
            page.noteWidget().method_25355(note);
        });
    }

    public void setAlbumAccess(AlbumAccess albumAccess) {
        this.albumAccess = albumAccess;
        this.pager.setPagesCount(albumAccess.getPageCount() / 2);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        for (Page page : this.pages) {
            TextBlock noteWidget = page.noteWidget();
            if (!(noteWidget instanceof TextBlock)) continue;
            TextBlock textBlock = noteWidget;
            textBlock.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(class_332 guiGraphics, int x, int y) {
        for (Page page : this.pages) {
            if (!page.photographWidget().method_25367()) continue;
            page.photographWidget().renderTooltip(guiGraphics, x, y);
            return;
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25291(AlbumGUI.TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        int currentSpreadIndex = this.getCurrentSpreadIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex, mouseX, mouseY);
    }

    protected void drawPageNumbers(class_332 guiGraphics, int currentSpreadIndex, int mouseX, int mouseY) {
        class_327 font = Minecrft.get().field_1772;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.method_51433(font, leftPageNumber, this.leftPos + 71 + (8 - font.method_1727(leftPageNumber) / 2), this.topPos + 167, Config.getColor(Config.Client.ALBUM_FONT_SECONDARY_COLOR), false);
        guiGraphics.method_51433(font, rightPageNumber, this.leftPos + 212 + (8 - font.method_1727(rightPageNumber) / 2), this.topPos + 167, Config.getColor(Config.Client.ALBUM_FONT_SECONDARY_COLOR), false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        for (Page page : this.pages) {
            if (!page.noteWidget().method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25430(@Nullable class_2583 style) {
        if (style == null) {
            return false;
        }
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            String pageIndexStr = clickEvent.method_10844();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.method_25430(style);
        if (handled && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return handled;
    }

    protected void forcePage(int pageIndex) {
        this.pager.changePage(pageIndex / 2);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    protected void inspectPhotograph(class_1799 photograph) {
        if (!(photograph.method_7909() instanceof PhotographItem)) {
            return;
        }
        Minecrft.get().method_1507((class_437)new ChildPhotographScreen(this, List.of(new ItemAndStack(photograph))));
        Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), (float)(Minecrft.level().method_8409().method_43057() * 0.2f + 1.3f), (float)0.75f));
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    public record AlbumAccess(List<PageContent> pages) {
        public static final AlbumAccess EMPTY = new AlbumAccess(Collections.emptyList());

        public int getPageCount() {
            return this.pages.size();
        }

        public static AlbumAccess fromItem(class_1799 stack) {
            Object object = stack.method_57824(Exposure.DataComponents.ALBUM_CONTENT);
            if (object instanceof AlbumContent) {
                AlbumContent content = (AlbumContent)object;
                return new AlbumAccess(content.pages().stream().map(PageContent::new).toList());
            }
            object = stack.method_57824(Exposure.DataComponents.SIGNED_ALBUM_CONTENT);
            if (object instanceof SignedAlbumContent) {
                SignedAlbumContent content = (SignedAlbumContent)object;
                return new AlbumAccess(content.pages().stream().map(PageContent::new).toList());
            }
            return EMPTY;
        }
    }

    protected record Page(Side side, PhotographSlotWidget photographWidget, TextBlock noteWidget) {
    }

    public record PageContent(class_1799 photograph, class_2561 note) {
        public static final PageContent EMPTY = new PageContent(class_1799.field_8037, (class_2561)class_2561.method_43473());

        public PageContent(AlbumPage page) {
            this(page.photograph(), (class_2561)class_2561.method_43470((String)page.note()));
        }

        public PageContent(SignedAlbumPage page) {
            this(page.photograph(), page.note());
        }
    }
}

