/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.album;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumGUI;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumSigningScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.PhotographSlotWidget;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.gui.screen.element.TextBlock;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.TextBox;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.AlbumSyncNoteC2SP;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.util.Side;
import io.github.mortuusars.exposure.world.inventory.AlbumMenu;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumScreen
extends class_465<AlbumMenu> {
    public static final class_8666 SIGN_BUTTON_SPRITES = new class_8666(Exposure.resource("album/sign"), Exposure.resource("album/sign_disabled"), Exposure.resource("album/sign_highlighted"));
    protected final Pager pager = new Pager().setChangeSound(new SoundEffect(() -> class_3417.field_17481)).onPageChanged((oldPage, newPage) -> this.clickButton(PagingDirection.fromChange(oldPage, newPage).ordinal()));
    protected final KeyBindings keyBindings;
    protected final List<Page> pages;
    @Nullable
    protected class_4185 enterSignModeButton;

    public AlbumScreen(AlbumMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        KeyBinding[] keyBindingArray = new KeyBinding[5];
        keyBindingArray[0] = Key.press(Minecrft.options().field_1822).executes(() -> ((AlbumScreen)this).method_25419());
        keyBindingArray[1] = Key.press(263).or(Key.press(65)).executes(this.pager::previousPage);
        keyBindingArray[2] = Key.press(262).or(Key.press(68)).executes(this.pager::nextPage);
        keyBindingArray[3] = Key.release(263).or(Key.press(65)).executes(this.pager::resetCooldown);
        keyBindingArray[4] = Key.release(262).or(Key.press(68)).executes(this.pager::resetCooldown);
        this.keyBindings = KeyBindings.of(keyBindingArray);
        this.pages = new ArrayList<Page>();
    }

    protected void method_25426() {
        this.field_2792 = 298;
        this.field_2779 = 188;
        super.method_25426();
        this.field_25268 = -999;
        this.field_25269 = 69;
        this.field_25270 = -999;
        this.pages.clear();
        Page leftPage = this.createPage(Side.LEFT, 0);
        this.pages.add(leftPage);
        class_344 previousPageButton = new class_344(this.field_2776 + 12, this.field_2800 + 164, 13, 15, AlbumGUI.PREVIOUS_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        previousPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.previous_page")));
        this.method_37063((class_364)previousPageButton);
        Page rightPage = this.createPage(Side.RIGHT, 140);
        this.pages.add(rightPage);
        class_344 nextPageButton = new class_344(this.field_2776 + 273, this.field_2800 + 164, 13, 15, AlbumGUI.NEXT_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        nextPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.next_page")));
        this.method_37063((class_364)nextPageButton);
        if (((AlbumMenu)this.method_17577()).isAlbumEditable()) {
            this.enterSignModeButton = new class_344(this.field_2776 - 23, this.field_2800 + 17, 22, 22, SIGN_BUTTON_SPRITES, b -> this.enterSignMode(), (class_2561)class_2561.method_43471((String)"gui.exposure.album.sign"));
            this.enterSignModeButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.album.sign")));
            this.method_37063((class_364)this.enterSignModeButton);
        }
        int spreadsCount = (int)Math.ceil((float)((AlbumMenu)this.method_17577()).getPages().size() / 2.0f);
        this.pager.setPagesCount(spreadsCount).setPreviousPageButton((class_4264)previousPageButton).setNextPageButton((class_4264)nextPageButton);
    }

    protected void method_37432() {
        this.forEachPage(page -> page.noteWidget.ifLeft(TextBox::tick));
    }

    protected Page createPage(Side side, int xOffset) {
        Either noteWidget;
        int x = this.field_2776 + xOffset;
        int y = this.field_2800;
        class_768 page = new class_768(x, y, 149, 188);
        class_768 photo = new class_768(x + 25, y + 21, 108, 108);
        class_768 note = new class_768(x + 22, y + 133, 114, 27);
        PhotographSlotWidget photographWidget = new PhotographSlotWidget((class_437)this, photo.method_3321(), photo.method_3322(), photo.method_3319(), photo.method_3320(), () -> ((AlbumMenu)this.method_17577()).getPhotograph(side)){

            @Override
            public boolean method_25402(double mouseX, double mouseY, int button) {
                return !AlbumScreen.this.isInAddingMode() && super.method_25402(mouseX, mouseY, button);
            }

            public boolean method_49606() {
                return !AlbumScreen.this.isInAddingMode() && super.method_49606();
            }
        };
        photographWidget.editable(((AlbumMenu)this.method_17577()).isAlbumEditable()).primaryAction(widget -> {
            if (!widget.inspectPhotograph() && widget.getPhotograph().method_7960() && widget.isEditable()) {
                this.clickButton(side == Side.LEFT ? 2 : 3);
                Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        }).secondaryAction(widget -> {
            if (widget.isEditable() && !widget.getPhotograph().method_7960()) {
                this.clickButton(side == Side.LEFT ? 2 : 3);
                Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), (float)0.7f, (float)1.1f));
            }
        });
        this.method_37063((class_364)photographWidget);
        if (((AlbumMenu)this.method_17577()).isAlbumEditable()) {
            TextBox textBox = new TextBox(this.field_22793, note.method_3321(), note.method_3322(), note.method_3319(), note.method_3320(), () -> ((AlbumMenu)this.method_17577()).getPage(side).map(AlbumPage::note).orElse(""), text -> this.onNoteChanged(side, (String)text)).setFontColor(Config.getColor(Config.Client.ALBUM_FONT_MAIN_COLOR)).setSelectionColor(Config.getColor(Config.Client.ALBUM_SELECTION_COLOR), Config.getColor(Config.Client.ALBUM_SELECTION_UNFOCUSED_COLOR));
            textBox.horizontalAlignment = HorizontalAlignment.CENTER;
            this.method_37063((class_364)textBox);
            noteWidget = Either.left((Object)((Object)textBox));
        } else {
            TextBlock textBlock = new TextBlock(this.field_22793, note.method_3321(), note.method_3322(), note.method_3319(), note.method_3320(), this.getNoteComponent(side), this::method_25430);
            textBlock.fontColor = Config.getColor(Config.Client.ALBUM_FONT_MAIN_COLOR);
            textBlock.alignment = HorizontalAlignment.CENTER;
            textBlock.drawShadow = false;
            noteWidget = Either.right((Object)((Object)textBlock));
        }
        return new Page(side, page, photo, note, photographWidget, (Either<TextBox, TextBlock>)noteWidget);
    }

    protected void onNoteChanged(Side side, String noteText) {
        int pageIndex = ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() * 2 + side.getIndex();
        ((AlbumMenu)this.method_17577()).updatePage(pageIndex, page -> page.setNote(noteText));
        Packets.sendToServer(new AlbumSyncNoteC2SP(pageIndex, noteText));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateWidgetVisibility();
        this.field_25270 = this.isInAddingMode() ? ((AlbumMenu)this.method_17577()).getPlayerInventorySlots().getFirst().field_7872 - 12 : -999;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
        for (Page page : this.pages) {
            class_339 noteWidget = page.getNoteWidget();
            if (!(noteWidget instanceof TextBlock)) continue;
            TextBlock textBlock = (TextBlock)noteWidget;
            textBlock.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.isInAddingMode()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (class_1735 slot : ((AlbumMenu)this.method_17577()).field_7761) {
                if (slot.method_7677().method_7960() || slot.method_7677().method_7909() instanceof PhotographItem) continue;
                guiGraphics.method_25291(AlbumGUI.TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 350, 176.0f, 188.0f, 18, 18, 512, 512);
            }
            RenderSystem.disableBlend();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    private void updateWidgetVisibility() {
        this.forEachPage(page -> {
            page.getNoteWidget().field_22764 = !this.isInAddingMode();
        });
        for (Page page2 : this.pages) {
            page2.photographWidget.field_22764 = !((AlbumMenu)this.method_17577()).getPhotograph(page2.side).method_7960() || !this.isInAddingMode() && ((AlbumMenu)this.method_17577()).isAlbumEditable();
        }
        if (this.enterSignModeButton != null) {
            this.enterSignModeButton.field_22764 = ((AlbumMenu)this.method_17577()).canSignAlbum();
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 15.0f);
        super.method_2388(guiGraphics, mouseX, mouseY);
        guiGraphics.method_51448().method_22909();
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (this.isInAddingMode() && this.field_2787 != null && !this.field_2787.method_7677().method_7960() && !(this.field_2787.method_7677().method_7909() instanceof PhotographItem)) {
            return;
        }
        if (!this.isInAddingMode()) {
            for (Page page : this.pages) {
                boolean hasText;
                if (page.photographWidget.method_25367()) {
                    page.photographWidget.renderTooltip(guiGraphics, x, y);
                    return;
                }
                if (!((AlbumMenu)this.method_17577()).isAlbumEditable() || !page.isMouseOver(page.noteArea, x, y)) continue;
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                tooltip.add(class_2561.method_43471((String)"gui.exposure.album.note"));
                if (!page.getNoteWidget().method_25370()) {
                    tooltip.add(class_2561.method_43471((String)"gui.exposure.album.left_click_to_edit"));
                }
                if (hasText = page.noteWidget.left().map(box -> !box.getText().isEmpty()).orElse(false).booleanValue()) {
                    tooltip.add(class_2561.method_43471((String)"gui.exposure.album.right_click_to_clear"));
                }
                guiGraphics.method_51437(this.field_22793, tooltip, Optional.empty(), x, y);
                return;
            }
        }
        super.method_2380(guiGraphics, x, y);
    }

    @NotNull
    public List<class_2561> method_51454(class_1799 stack) {
        List tooltipLines = super.method_51454(stack);
        if (this.isInAddingMode() && this.field_2787 != null && this.field_2787.method_7677() == stack && stack.method_7909() instanceof PhotographItem) {
            tooltipLines.add(class_2561.method_43473());
            tooltipLines.add(class_2561.method_43471((String)"gui.exposure.album.left_click_to_add"));
        }
        return tooltipLines;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25291(AlbumGUI.TEXTURE, this.field_2776, this.field_2800, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 512);
        if (this.enterSignModeButton != null && this.enterSignModeButton.field_22764) {
            guiGraphics.method_25290(AlbumGUI.TEXTURE, this.field_2776 - 27, this.field_2800 + 14, 447.0f, 0.0f, 27, 28, 512, 512);
        }
        int currentSpreadIndex = ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex);
        if (this.isInAddingMode()) {
            AlbumPlayerInventorySlot firstSlot = ((AlbumMenu)this.method_17577()).getPlayerInventorySlots().getFirst();
            int x = firstSlot.field_7873 - 8;
            int y = firstSlot.field_7872 - 18;
            guiGraphics.method_25291(AlbumGUI.TEXTURE, this.field_2776 + x, this.field_2800 + y, 10, 0.0f, 188.0f, 176, 100, 512, 512);
            @Nullable Side pageBeingAddedTo = ((AlbumMenu)this.method_17577()).getSideBeingAddedTo();
            for (Page page : this.pages) {
                if (page.side != pageBeingAddedTo) continue;
                guiGraphics.method_52706(PhotographSlotWidget.EMPTY_SPRITES.comp_1606(), page.photoArea.method_3321(), page.photoArea.method_3322(), page.photoArea.method_3319(), page.photoArea.method_3320());
            }
        }
    }

    protected void drawPageNumbers(class_332 guiGraphics, int currentSpreadIndex) {
        class_327 font = Minecrft.get().field_1772;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.method_51433(font, leftPageNumber, this.field_2776 + 71 + (8 - font.method_1727(leftPageNumber) / 2), this.field_2800 + 167, Config.getColor(Config.Client.ALBUM_FONT_SECONDARY_COLOR), false);
        guiGraphics.method_51433(font, rightPageNumber, this.field_2776 + 212 + (8 - font.method_1727(rightPageNumber) / 2), this.field_2800 + 167, Config.getColor(Config.Client.ALBUM_FONT_SECONDARY_COLOR), false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isInAddingMode()) {
            if (!(this.isHoveringOverInventory(mouseX, mouseY) || this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button) && !((AlbumMenu)this.method_17577()).method_34255().method_7960())) {
                this.clickButton(-1);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
        for (Page page : this.pages) {
            if (!((AlbumMenu)this.method_17577()).isAlbumEditable() || button != 1 || !page.isMouseOver(page.noteArea, mouseX, mouseY)) continue;
            page.noteWidget.ifLeft(box -> box.setText(""));
            return true;
        }
        boolean handled = super.method_25402(mouseX, mouseY, button);
        for (Page page : this.pages) {
            TextBlock textBlock;
            class_339 noteWidget = page.getNoteWidget();
            if (!(noteWidget instanceof TextBlock) || !(textBlock = (TextBlock)noteWidget).method_25402(mouseX, mouseY, button)) continue;
            handled = true;
            break;
        }
        for (Page page : this.pages) {
            if (!page.getNoteWidget().method_25370() || page.isMouseOver(page.noteArea, mouseX, mouseY)) continue;
            this.method_25395(null);
            return true;
        }
        if (!(this.method_25399() instanceof TextBox)) {
            this.method_25395(null);
        }
        return handled;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.field_2794 && !((AlbumMenu)this.method_17577()).method_34255().method_7960() && ((AlbumMenu)this.method_17577()).method_34255().method_7947() == 1) {
            this.field_2794 = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25430(@Nullable class_2583 style) {
        if (style == null) {
            return false;
        }
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            String pageIndexStr = clickEvent.method_10844();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.method_25430(style);
        if (handled && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return handled;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInAddingMode()) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return this.method_25399() != null && this.method_25397() && button == 0 && this.method_25399().method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected void clickButton(int buttonId) {
        ((AlbumMenu)this.method_17577()).method_7604((class_1657)Minecrft.player(), buttonId);
        Minecrft.gameMode().method_2900(((AlbumMenu)this.method_17577()).field_7763, buttonId);
        if (buttonId == -1) {
            this.method_25395(null);
        }
        if (buttonId == AlbumMenu.PREVIOUS_PAGE_BUTTON || buttonId == AlbumMenu.NEXT_PAGE_BUTTON) {
            for (Page page : this.pages) {
                page.noteWidget.ifLeft(TextBox::setCursorToEnd).ifRight(textBlock -> textBlock.method_25355(this.getNoteComponent(page.side)));
            }
        }
    }

    protected boolean isHoveringOverInventory(double mouseX, double mouseY) {
        if (!this.isInAddingMode()) {
            return false;
        }
        AlbumPlayerInventorySlot firstSlot = ((AlbumMenu)this.method_17577()).getPlayerInventorySlots().getFirst();
        int x = firstSlot.field_7873 - 8;
        int y = firstSlot.field_7872 - 18;
        return this.method_2378(x, y, 176, 100, mouseX, mouseY);
    }

    protected boolean isHoveringOverSignElement(double mouseX, double mouseY) {
        return this.enterSignModeButton != null && this.enterSignModeButton.field_22764 && this.method_2378(this.field_2776 - 27, this.field_2800 + 14, 27, 28, mouseX, mouseY);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.isHoveringOverInventory(mouseX, mouseY) && !this.isHoveringOverSignElement(mouseX, mouseY);
    }

    protected boolean forcePage(int pageIndex) {
        try {
            int newSpreadIndex = pageIndex / 2;
            if (newSpreadIndex == ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() || newSpreadIndex < 0 || newSpreadIndex > ((AlbumMenu)this.method_17577()).getPages().size() / 2) {
                return false;
            }
            PagingDirection pagingDirection = newSpreadIndex < ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() ? PagingDirection.PREVIOUS : PagingDirection.NEXT;
            for (int pageChanges = 0; !(newSpreadIndex == ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() && this.pager.canChangePage(pagingDirection) || pageChanges > 16); ++pageChanges) {
                this.pager.changePage(pagingDirection);
            }
            return true;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot force page: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        for (Page page : this.pages) {
            class_339 widget = (class_339)page.noteWidget.map(box -> box, block -> block);
            if (!widget.method_25370()) continue;
            if (keyCode == 256) {
                this.method_25395(null);
                return true;
            }
            return widget.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.isInAddingMode() && (Minecrft.options().field_1822.method_1417(keyCode, scanCode) || keyCode == 256)) {
            this.clickButton(-1);
            return true;
        }
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        for (Page page : this.pages) {
            if (!((class_339)page.noteWidget.map(box -> box, block -> block)).method_25370()) continue;
            return super.method_16803(keyCode, scanCode, modifiers);
        }
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    @NotNull
    protected class_2561 getNoteComponent(Side side) {
        return (class_2561)((AlbumMenu)this.method_17577()).getPage(side).map(page -> class_2561.method_43470((String)page.note())).orElse(class_2561.method_43473());
    }

    protected void enterSignMode() {
        if (this.isInAddingMode()) {
            this.clickButton(-1);
        }
        Minecrft.get().method_1507((class_437)new AlbumSigningScreen(this));
    }

    protected boolean isInAddingMode() {
        return ((AlbumMenu)this.method_17577()).isInAddingPhotographMode();
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    protected class Page {
        public final Side side;
        public final class_768 pageArea;
        public final class_768 photoArea;
        public final class_768 noteArea;
        public final PhotographSlotWidget photographWidget;
        public final Either<TextBox, TextBlock> noteWidget;

        private Page(Side side, class_768 pageArea, class_768 photoArea, class_768 noteArea, PhotographSlotWidget photographWidget, Either<TextBox, TextBlock> noteWidget) {
            this.side = side;
            this.pageArea = pageArea;
            this.photoArea = photoArea;
            this.noteArea = noteArea;
            this.photographWidget = photographWidget;
            this.noteWidget = noteWidget;
        }

        public boolean isMouseOver(class_768 area, double mouseX, double mouseY) {
            return AlbumScreen.this.method_2378(area.method_3321() - AlbumScreen.this.field_2776, area.method_3322() - AlbumScreen.this.field_2800, area.method_3319(), area.method_3320(), mouseX, mouseY);
        }

        public class_339 getNoteWidget() {
            return (class_339)this.noteWidget.map(box -> box, block -> block);
        }
    }
}

