/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.template;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.action.CaptureAction;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.capture.saving.ExposureUploader;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.util.cycles.task.EmptyTask;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.capture.Projection;
import net.minecraft.class_1297;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PathCaptureTemplate
implements CaptureTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Task<?> createTask(CaptureParameters params) {
        if (params.exposureId().isEmpty()) {
            LOGGER.error("Failed to create capture task: exposure id cannot be empty. '{}'", (Object)params);
            return new EmptyTask();
        }
        @Nullable class_1297 entity = Minecrft.level().method_8469(params.cameraHolderId().orElse(Minecrft.player().method_5628()).intValue());
        if (entity == null) {
            LOGGER.error("Failed to create capture task: camera holder entity cannot be obtained. '{}'", (Object)params);
            return new EmptyTask();
        }
        if (params.projection().isEmpty()) {
            LOGGER.error("Cannot load: projecting info is missing. {}", (Object)params);
            return new EmptyTask();
        }
        Projection projection = params.projection().get();
        String path = projection.path();
        class_6880<ColorPalette> palette = this.getColorPalette(params);
        return Capture.of(Capture.path(path), CaptureAction.optional(params.cameraId(), CaptureAction::interplanarProjection)).logErrorAndGetResult(LOGGER).thenAsync(this.applyEffectsToImage(params.mutable().setCropFactor(1.0f).build())).thenAsync(Palettizer.fromDitherMode(projection.mode()).palettizeAndClose((ColorPalette)palette.comp_349())).thenAsync(this.convertToExposureData(palette, this.createExposureTag(params, true))).acceptAsync(image -> ExposureUploader.upload(params.exposureId(), image)).onError(this.printCasualErrorInChat());
    }
}

