/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.template;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.PalettedImage;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmProperties;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmStyle;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public interface CaptureTemplate {
    public Task<?> createTask(CaptureParameters var1);

    default public class_6880<ColorPalette> getColorPalette(CaptureParameters params) {
        return ColorPalettes.get(Minecrft.registryAccess(), params.filmProperties().colorPalette());
    }

    default public Function<Image, Image> applyEffectsToImage(CaptureParameters params) {
        FilmProperties film = params.filmProperties();
        FilmStyle style = film.style();
        return ImageEffect.chain(ImageEffect.Crop.SQUARE_CENTER, ImageEffect.Crop.factor(params.cropFactor()), ImageEffect.Resize.to(film.size().orElse((Integer)Config.Server.DEFAULT_FRAME_SIZE.get())), ImageEffect.exposure(params.getShutterSpeed().getBrightness() * (style.sensitivity().floatValue() + 1.0f)), ImageEffect.contrast(style.contrast().floatValue()), ImageEffect.levels(style.levels()), ImageEffect.hsb(style.hsb()), ImageEffect.noise(style.noise().floatValue()), ImageEffect.optional(params.filmProperties().type() == ExposureType.BLACK_AND_WHITE, params.singleChannel().map(ImageEffect::singleChannelBlackAndWhite).orElse(ImageEffect.BLACK_AND_WHITE)));
    }

    default public Function<PalettedImage, ExposureData> convertToExposureData(class_6880<ColorPalette> palette, ExposureData.Tag tag) {
        class_2960 paletteId = ((class_5321)palette.method_40230().orElseThrow()).method_29177();
        return image -> new ExposureData(image.width(), image.height(), image.pixels(), paletteId, tag);
    }

    default public ExposureData.Tag createExposureTag(CaptureParameters params, boolean isLoaded) {
        return new ExposureData.Tag(params.filmProperties().type(), Minecrft.player().method_5820(), UnixTimestamp.Seconds.now(), isLoaded, false);
    }

    @NotNull
    default public Consumer<TranslatableError> printCasualErrorInChat() {
        return err -> {
            Minecrft.execute(() -> Minecrft.player().method_7353((class_2561)err.casual().method_27692(class_124.field_1061), false));
            Exposure.LOGGER.error(err.technical().getString());
        };
    }
}

