/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.saving;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.util.color.Color;
import java.io.File;
import net.minecraft.class_1011;
import org.slf4j.Logger;

public class NativeImageFileSaver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File file;

    public NativeImageFileSaver(File file) {
        this.file = file;
    }

    public NativeImageFileSaver(String filePath) {
        this.file = new File(filePath);
    }

    public void save(Image image) {
        try (class_1011 nativeImage = new class_1011(image.width(), image.height(), false);){
            for (int y = 0; y < image.height(); ++y) {
                for (int x = 0; x < image.width(); ++x) {
                    int pixelColor = image.getPixelARGB(x, y);
                    nativeImage.method_4305(x, y, Color.ARGBtoABGR(pixelColor));
                }
            }
            boolean ignored = this.file.getParentFile().mkdirs();
            nativeImage.method_4325(this.file);
            LOGGER.info("Saved image: {}", (Object)this.file);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save image to file: {}", (Object)e.toString());
        }
    }
}

