/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.advancements.predicate.CameraPredicate;
import io.github.mortuusars.exposure.advancements.predicate.FramePredicate;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

public class FrameExposedTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, CameraHolder cameraHolder, class_1799 cameraStack, Frame frame, List<class_2338> locationsInFrame, List<class_1309> entitiesInFrame) {
        this.method_22510(player, triggerInstance -> triggerInstance.matches(player, cameraHolder, cameraStack, frame, locationsInFrame, entitiesInFrame));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<CameraPredicate> camera;
        private final Optional<FramePredicate> frame;
        private final Optional<class_2090> locationInFrame;
        private final Optional<List<class_5258>> entitiesInFrame;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)CameraPredicate.CODEC.optionalFieldOf("camera").forGetter(TriggerInstance::camera), (App)FramePredicate.CODEC.optionalFieldOf("frame").forGetter(TriggerInstance::frame), (App)class_2090.field_45760.optionalFieldOf("location_in_frame").forGetter(TriggerInstance::locationInFrame), (App)class_2048.field_47250.listOf().optionalFieldOf("entities_in_frame").forGetter(TriggerInstance::entitiesInFrame)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<CameraPredicate> camera, Optional<FramePredicate> frame, Optional<class_2090> locationInFrame, Optional<List<class_5258>> entitiesInFrame) {
            this.player = player;
            this.camera = camera;
            this.frame = frame;
            this.locationInFrame = locationInFrame;
            this.entitiesInFrame = entitiesInFrame;
        }

        public boolean matches(class_3222 player, CameraHolder cameraHolder, class_1799 cameraStack, Frame frame, List<class_2338> locationsInFrame, List<class_1309> entitiesInFrame) {
            return !(!this.camera.isEmpty() && !this.camera.get().matches(player.method_51469(), cameraStack, cameraHolder.asHolderEntity().method_19538()) || !this.frame.isEmpty() && !this.frame.get().matches(frame) || !this.locationsMatch(player, locationsInFrame) || !this.entitiesInFrameMatch(player, cameraHolder, entitiesInFrame));
        }

        private boolean locationsMatch(class_3222 player, List<class_2338> locationsInFrame) {
            return this.locationInFrame.isEmpty() || locationsInFrame.stream().anyMatch(pos -> this.locationInFrame.get().method_9018(player.method_51469(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5));
        }

        private boolean entitiesInFrameMatch(class_3222 player, CameraHolder cameraHolder, List<class_1309> entitiesInFrame) {
            return this.entitiesInFrame.isEmpty() || this.entitiesInFrame.get().stream().allMatch(predicate -> entitiesInFrame.stream().anyMatch(entity -> {
                class_47 context = TriggerInstance.createContextForHolder(player.method_51469(), cameraHolder, (class_1297)entity);
                return predicate.method_27806(context);
            }));
        }

        public static class_47 createContextForHolder(class_3218 level, CameraHolder holder, class_1297 entity) {
            class_8567 lootParams = new class_8567.class_8568(level).method_51874(class_181.field_1226, (Object)entity).method_51874(class_181.field_24424, (Object)holder.asHolderEntity().method_19538()).method_51875(class_173.field_24423);
            return new class_47.class_48(lootParams).method_309(Optional.empty());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;camera;frame;locationInFrame;entitiesInFrame", "player", "camera", "frame", "locationInFrame", "entitiesInFrame"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;camera;frame;locationInFrame;entitiesInFrame", "player", "camera", "frame", "locationInFrame", "entitiesInFrame"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;camera;frame;locationInFrame;entitiesInFrame", "player", "camera", "frame", "locationInFrame", "entitiesInFrame"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<CameraPredicate> camera() {
            return this.camera;
        }

        public Optional<FramePredicate> frame() {
            return this.frame;
        }

        public Optional<class_2090> locationInFrame() {
            return this.locationInFrame;
        }

        public Optional<List<class_5258>> entitiesInFrame() {
            return this.entitiesInFrame;
        }
    }
}

