/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.villagers.json.adapters;

import com.glisco.numismaticoverhaul.currency.CurrencyHelper;
import com.glisco.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.glisco.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9306;
import net.minecraft.class_9636;
import org.jetbrains.annotations.NotNull;

public class EnchantItemAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public class_3853.class_1652 deserialize(JsonObject json) {
        this.loadDefaultStats(json, false);
        VillagerJsonHelper.assertInt(json, "level");
        boolean allow_treasure = VillagerJsonHelper.boolean_getOrDefault(json, "allow_treasure", false);
        int level = json.get("level").getAsInt();
        class_1799 item = VillagerJsonHelper.ItemStack_getOrDefault(json, "item", new class_1799((class_1935)class_1802.field_8529));
        int base_price = class_3518.method_15282((JsonObject)json, (String)"base_price", (int)200);
        return new Factory(item, this.max_uses, this.villager_experience, level, allow_treasure, this.price_multiplier, base_price);
    }

    private static class Factory
    implements class_3853.class_1652 {
        private final int experience;
        private final int maxUses;
        private final int level;
        private final boolean allowTreasure;
        private final class_1799 toEnchant;
        private final float multiplier;
        private final int basePrice;

        public Factory(class_1799 item, int maxUses, int experience, int level, boolean allowTreasure, float multiplier, int basePrice) {
            this.experience = experience;
            this.maxUses = maxUses;
            this.level = level;
            this.allowTreasure = allowTreasure;
            this.toEnchant = item;
            this.multiplier = multiplier;
            this.basePrice = basePrice;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 itemStack = this.toEnchant.method_7972();
            class_2378 enchantmentRegistry = entity.method_37908().method_30349().method_30530(class_7924.field_41265);
            Optional nonTreasureEnchants = enchantmentRegistry.method_40266(class_9636.field_51558);
            Optional treasureRegistry = enchantmentRegistry.method_40266(class_9636.field_51545);
            List enchants = List.of();
            if (this.allowTreasure && treasureRegistry.isPresent()) {
                enchants = class_1890.method_8230((class_5819)random, (class_1799)itemStack, (int)this.level, (Stream)((class_6885.class_6888)treasureRegistry.get()).method_40239());
            } else if (nonTreasureEnchants.isPresent()) {
                enchants = class_1890.method_8230((class_5819)random, (class_1799)itemStack, (int)this.level, (Stream)((class_6885.class_6888)nonTreasureEnchants.get()).method_40239());
            }
            class_1799 finalItemStack = itemStack.method_7972();
            if (finalItemStack.method_31574(class_1802.field_8529)) {
                finalItemStack = new class_1799((class_1935)class_1802.field_8598);
            }
            for (class_1889 enchant : enchants) {
                finalItemStack.method_7978(enchant.field_9093, enchant.field_9094);
            }
            int price = this.basePrice;
            class_9304 enchantments = class_1890.method_57532((class_1799)finalItemStack);
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                class_6880 enchantment = (class_6880)entry.getKey();
                boolean isTreasure = enchantment.method_40220(class_9636.field_51557);
                if (enchantment.method_40220(class_9636.field_51546)) {
                    price *= 2;
                }
                price += (int)((float)price * 0.1f + (float)this.basePrice * (isTreasure ? 2.0f : 1.0f) * (float)entry.getIntValue() * class_3532.method_15344((class_5819)random, (float)0.8f, (float)1.2f) * (5.0f / (float)((class_1887)enchantment.comp_349()).method_58445()));
            }
            class_1799 itemAndCost = CurrencyHelper.getClosest(price);
            return new class_1914(new class_9306((class_1935)itemAndCost.method_7909(), itemAndCost.method_7947()), Optional.of(new class_9306((class_1935)this.toEnchant.method_7909())), finalItemStack, this.maxUses, this.experience, this.multiplier);
        }
    }
}

